# Nanbeige4
## 论文
[Nanbeige4-3B](https://arxiv.org/pdf/2512.06266)

## 模型简介
Nanbeige4-3B-Base是Nanbeige大语言模型第四代家族中的一款30亿参数基座模型。该模型表明，即使模型规模紧凑，通过持续提升数据质量与优化训练方法，仍能实现卓越性能。在相同监督微调数据上进行训练时，本模型显著优于同规模开源模型，并超越如Qwen3-8B等更大参数量模型。

<div align=center>
    <img src="./doc/perf.png"/>
</div>


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name Nanbeige --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动

vllm serve Nanbeige/Nanbeige4-3B-Base/    --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1   --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/completions"   -H "Content-Type: application/json"     --data '{
                "model": "Nanbeige/Nanbeige4-3B-Base/",
                "prompt": "很久以前,",
                "max_tokens": 512,
                "temperature": 0.5
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Nanbeige4-3B-Base | 3B | K100AI | 1 | [下载地址](https://huggingface.co/Nanbeige/Nanbeige4-3B-Base) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/nanbeige4_vllm

## 参考资料
- https://hf-mirror.com/Nanbeige/Nanbeige4-3B-Base
