# MythoMax-L2
## 论文
暂无

## 模型简介
MythoMax-L2模型是基于MythoLogic-L2模型与Huginn模型，采用了一种高度实验性的张量分层融合技术。融合的核心思想在于：模型的每一层均由多个张量构成，而每个张量又承载着特定功能。通过以MythoLogic-L2的深度理解能力作为输入基础，结合Huginn强大的文本生成能力作为输出引擎，最终得到的模型在两方面均实现超越。与MythoMix的主要区别在于，让更多Huginn的特性融入模型首尾部分的独立张量中，从而显著提升了模型整体结构的连贯性。得益于其独特的设计，该模型在角色扮演与故事创作方面均表现出色。

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

推荐使用镜像:image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name MythoMax-L2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve  "Gryphe/MythoMax-L2-13b"
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/completions" \
	-H "Content-Type: application/json" \
	--data '{
		"model": "Gryphe/MythoMax-L2-13b",
		"prompt": "Once upon a time,",
		"max_tokens": 512,
		"temperature": 0.5
	}'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| MythoMax-L2-13b | 13B | K100AI | 1 | [下载地址](https://huggingface.co/Gryphe/MythoMax-L2-13b) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mythomax-l2_vllm

## 参考资料
- https://huggingface.co/Gryphe/MythoMax-L2-13b
