# 仓库目录结构
* 除预训练模型外其他文件总大小尽量不要超过50M
```
    Project
    ├── dataset
    │   ├── label_1
    │             ├── xxx.png
    │             ├── xxx.png
    │             └── ...
    │   └── label_2
    │             ├── xxx.png
    │             ├── xxx.png
    │             └── ...  
    ├── model
    │   ├── xxx.pth #预训练模型 
    │   ├── xxx.onnx #对应的onnx模型
    │   └── xxx.mxr #对应的migraphx离线推理模型
    ├── doc
    │   ├── icon.png
    │   ├── xxx.png
    │   └── xxx.png
    ├── README.md
    ├── requirement.txt
    ├── model.properties
    ├── code_file1.py
    ├── code_file2.py
    ├── code_file3.py
    ├── dirs
    │   ├── code_file4.py
    │   ├── code_file5.py
    └── └── code_file6.py
```

* icon.png:模型的图标文件，上传者需放至项目根目录供前端读取，所需算法类别图标可到 飞书->云文档->云盘->icon 查找，当前没有所需算法类别图标则提交设计申请即可。
![icon](./icon.png)

* README.md:参照下图，`十二大标题`为必选项，二级标题以下的标题或内容根据自己的项目灵活增删。
![img](./doc/readme.png)

* requirement.txt：模型依赖统一写到此文件，与深度学习相关的库请注释，以免安装为nv库。
```
说明：数据基本由公司网盘储存并提供url下载或直接读取，数据信息介绍由超算互联网商城提供，内部无数据时提供官网下载地址。
```

* 需要提供迷你数据集以供使用者快速上手项目。

* model.properties：`五大属性`固定模板如下：
```
    # 模型唯一标识
    modelCode=Project ID
    # 模型名称
    modelName=模型名称(同项目名称：模型名_深度学习框架)
    # 模型描述
    modelDescription=简要描述此模型(尽量50字以内)
    # 应用场景
    appScenario=推理,训练,OCR,政府,交通,零售,金融,医疗(首先描述推理、训练信息，然后描述算法类别信息，最后描述应用行业信息，多个标签用英文逗号隔开。)
    # 框架类型
    frameType=paddle(说明使用的算法框架, 多个标签用英文逗号隔开。)
```

* 增加LICENSE（必要），源github无LICENSE则在LICENSE里填：None LICENSE Currently；CONTRIBUTORS.md根据源github有无提供（非必要）。