#!/bin/bash
# Change for multinode config

NNODES=1
NODE_RANK=0
GPUS_PER_NODE=2
MASTER_ADDR=127.0.0.1
MASTER_PORT=29513
CUDA_VISIBLE_DEVICES=0,1
# GPUS_PER_NODE=1
DISTRIBUTED_ARGS="--nproc_per_node $GPUS_PER_NODE --nnodes $NNODES --node_rank $NODE_RANK --master_addr $MASTER_ADDR --master_port $MASTER_PORT"

# change LOAD to your local path of DocOwl1.5-Omni
# batch size = per_device_train_batch_size x GPUS_PER_NODE x NNODES x gradient_accumulation_steps

torchrun $DISTRIBUTED_ARGS mplug_docowl/train/train_docowl.py \
    --deepspeed '/home/wanglch/projects/mPLUG-DocOwl1.5-Omni/scripts/zero2.json' \
    --model_name_or_path '/home/wanglch/projects/mPLUG-DocOwl1.5-Omni/DocOwl1.5-Omni-base' \
    --version v1 \
    --data_path '/home/wanglch/projects/mPLUG-DocOwl1.5-Omni/DocLocal4K/mini_imges.jsonl' \
    --image_folder '/home/wanglch/projects/mPLUG-DocOwl1.5-Omni/DocLocal4K' \
    --image_size 448 \
    --crop_anchors 'grid_9' \
    --add_global_img True \
    --add_textual_crop_indicator True \
    --fp16 True \
    --output_dir '/home/wanglch/projects/saves/DocOwl1.5/train_multi_dcu' \
    --num_train_epochs 10 \
    --per_device_train_batch_size 1 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 8 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 500 \
    --save_total_limit 4 \
    --learning_rate 1e-4 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 False \
    --model_max_length 3600 \
    --gradient_checkpointing True \
    --tune_vision2text True \
    --freeze_vision_model True \
    --freeze_backbone True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to tensorboard

