# MobileNetv4
轻量化之王MobileNetV4，手机推理速度3.8ms，在移动CPU、DSP、GPU以及苹果M处理器和谷歌Pixel Edge TPU全都高性能。
## 论文
`MobileNetV4 - Universal Models for the Mobile Ecosystem`
- https://arxiv.org/pdf/2404.10518

## 模型结构
通用UIB块在倒瓶颈块中引入两个可选的DW，一个在扩展层之前，另一个在扩展层和投影层之间，很好地统一了几个重要现有块，包括原始的IB块、ConvNext块以及ViT中的FFN块。此外，UIB还引入了一种新的变体：额外的深度卷积IB（ExtraDW）块；MobileMQA一个专为加速器优化的新型注意力块，它能提供超过39%的推理速度提升。
<div align=center>
    <img src="./doc/structure.png"/>
</div>

## 算法原理
利用标准组件引入新的通用反转瓶颈UIB和移动MQA层，并结合改进的神经架构搜索（NAS）方法改进mobilenet，然后将这些与一种新颖的、最先进的蒸馏方法相结合。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv mobilenetv4_pytorch MobileNetv4 # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
docker run -it --shm-size=32G -v $PWD/MobileNetv4:/home/MobileNetv4 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name mobilenetv4 <your IMAGE ID> bash
cd /home/MobileNetv4
pip install -r requirements.txt # requirements.txt
```
### Dockerfile（方法二）
```
cd MobileNetv4/docker
docker build --no-cache -t mobilenetv4:latest .
docker run --shm-size=32G --name mobilenetv4 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../MobileNetv4:/home/MobileNetv4 -it mobilenetv4 bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04
python:python3.10
torch:2.1.0
torchvision:0.16.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
pip install -r requirements.txt # requirements.txt
```

## 数据集
源论文采用`ImageNet`训练，本步骤说明采用数据集`flowers`，项目中已提供[`flowers`](./datasets/flowers/)迷你数据集进行试用，解压即可，完整数据集请从以下官网下载：
- https://www.kaggle.com/datasets/alxmamaev/flowers-recognition?resource=download

数据目录结构如下：
```
datasets/flowers
    ├── train
    ├── ├── daisy
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── ├── dandelion
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── ├── rose
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── ├── sunflower
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── └── tulip
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    └── val
    ├── ├── daisy
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── ├── dandelion
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── ├── rose
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── ├── sunflower
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
    ├── └── tulip
    ├── ├── ├── xxx.jpg
    ├── ├── └── xxx.jpg
```

## 训练
### 单机单卡
```
python train.py --data_path "./datasets/flowers" --num_classes 5 --input_size 256 --gpu 0 # params: 2.383641M
```
更多资料可参考源项目的[`readme_origin`](./readme_origin.md)

## 推理
```
python predict.py
# MODEL_PATH = './checkpoints/model_MNV4ConvSmall_seed901_best.pt' # 使用MNV4ConvSmall训练权重，训练结果位于checkpoints下。
```

## result
`输入：`
```
"results/6089825811_80f253fbe1.jpg"
```
<div align=center>
    <img src="./doc/6089825811_80f253fbe1.png"/>
</div>

`输出：`
```
Vertification picture: 6089825811_80f253fbe1.jpg
Recognition result: daisy
Recognition confidence: 0.9952988
```

### 精度
max epoch为300，推理框架：pytorch。

|  device   |  Train_Loss  |  Train_Acc@1  |
|:---------:|:------:|:------:|
| DCU Z100L | 0.25923 | 94.460 |
| GPU V100S | 0.29128 | 90.720 |

## 应用场景
### 算法类别
`图像识别`
### 热点应用行业
`制造,电商,医疗,能源,教育`
## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/mobilenetv4_pytorch.git
## 参考资料
- https://github.com/Reversev/Deeplearning_pytorch/blob/master/CV_net/MobileNetv4/predict.py
- https://github.com/tensorflow/models/blob/master/official/vision/modeling/backbones/mobilenet.py
- https://github.com/jiaowoguanren0615/MobileNetV4/tree/main
- https://www.jianshu.com/p/992f0ebf656a
