# MobileNetv3_PyTorch算力测试

## 模型介绍

MobileNetV3是一种轻量级的卷积神经网络模型，由Google Brain团队于2019年提出。相对于MobileNetV2，MobileNetV3在准确性和模型大小上都有所提升。MobileNetV3主要采用了以下几种技术：

1. 倒残差结构：MobileNetV3使用了一种新的倒残差结构，通过在瓶颈层中使用两个卷积层和一个可分离卷积层，来提高准确性和收敛速度。
2. 自适应线性单元（AdaLIN）：MobileNetV3使用了自适应线性单元（AdaLIN）来替代传统的批归一化（Batch Normalization）层，以在准确性和模型大小之间取得平衡。
3. 利用Squeeze-and-Excitation模块进行通道注意力：MobileNetV3引入了Squeeze-and-Excitation（SE）模块，通过学习每个通道的重要性，对特征图中的每个通道进行加权，从而提高模型的准确性。
4. 硬件感知：MobileNetV3对不同硬件设备进行了优化，可以在CPU、GPU和移动端等设备上高效地运行。

MobileNetV3可以用于图像分类、目标检测、实例分割等任务，是一种轻量级、高效、准确性较高的卷积神经网络模型，可以在移动设备等资源受限的场景下进行应用。



## 模型结构

MobileNetV3模型结构主要由三部分组成：特征提取网络、分类器和辅助模块。其中，特征提取网络是MobileNetV3的核心部分，采用了一些创新的设计来提高模型的准确性和效率。

1. 特征提取网络：MobileNetV3的特征提取网络由一系列瓶颈块组成，每个瓶颈块包含一个1x1卷积层、一个可分离卷积层和一个1x1卷积层。MobileNetV3还引入了倒残差结构，通过在瓶颈块中使用两个卷积层和一个可分离卷积层，来提高准确性和收敛速度。此外，MobileNetV3还采用了自适应线性单元（AdaLIN）来替代传统的批归一化（Batch Normalization）层，以在准确性和模型大小之间取得平衡。MobileNetV3还引入了Squeeze-and-Excitation（SE）模块，通过学习每个通道的重要性，对特征图中的每个通道进行加权，从而提高模型的准确性。
2. 分类器：MobileNetV3的分类器采用了全局平均池化和一些全连接层，将特征提取网络输出的特征映射到各个类别的概率。
3. 辅助模块：MobileNetV3还引入了一些辅助模块，如多尺度训练、标签平滑等，来提高模型的准确性和泛化能力。

MobileNetV3的模型结构非常适合用于移动设备等资源受限的场景下，因为它具有轻量级、高效和准确性较高的特点。



## 数据集

本次训练使用的[CIFAR-10数据集](https://www.cs.toronto.edu/~kriz/cifar.html)

CIFAR-10是一个常用的图像分类数据集，由加拿大的加尔加里大学Alex Krizhevsky等人于2009年发布。该数据集包含了10个类别，每个类别包含了6000张32x32大小的彩色图像，共计60000张图像。

CIFAR-10数据集是一个相对较小的数据集，但它包含了各种各样的物体和场景，是一个非常有代表性的数据集。它被广泛应用于图像分类算法的评估和比较，是一个标准的基准测试数据集。

CIFAR-10数据集相对于其他图像数据集，具有以下几个特点：

1. 数据量相对较小，但类别丰富，适合用于训练和测试轻量级的模型。
2. 图像尺寸较小，可以在较短的时间内处理完成。
3. 图像质量较低，具有一定的噪声和变形，对算法的鲁棒性和泛化能力提出了一定的挑战。

CIFAR-10数据集是一个非常有用的数据集，既可以用于学术研究，也可以用于实际应用中。

## 训练

提供光源拉取的训练镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest
```



```
python -m torch.distributed.run --nproc_per_node 4 train.py --batch-size=128 --mode=small --print-freq=1 --dataset=CIFAR10 --ema-decay=0 --label-smoothing=0 --lr=0.2 --save-epoch-freq=10 --lr-decay=cos --lr-min=0 --warmup-epochs=5 --weight-decay=6e-5 --num-epochs=400 --num-workers=2 --width-multiplier=1  --data-dir /data/ --save-path /data/mobilenetv3out/ --resume ./pretrained/best_model_wts-67.52.pth 2>&1 | tee mobilenetv3_dcu_`date +%Y%m%d%H%M%S`.log
```

data-dir值为存放数据集的目录，如下图data目录下存放cifar-10-batches-py数据集目录，data-dir值为/data/

![1](D:\Model_Use\MobileNetv3\1.png)

--resume 为预训练模型路径

日志使用tee存入log文件中



## 准确率数据

| 卡数 |  精度  |
| :--: | :----: |
|  4   | 0.9144 |



## 源码仓库及问题反馈

http://developer.hpccube.com/codes/modelzoo/conformer_pytorch.git

## 参考

[https://github.com/showlo/mobilenetv3](https://github.com/showlo/mobilenetv3)