# MobileNetV3

## 论文

Searching for MobileNetV3

https://arxiv.org/pdf/1905.02244.pdf

## 模型结构

MobileNetv3模型采用轻量级的深度可分离卷积（depthwise separable convolution）结构，以减少模型参数量和计算复杂度。

![Backbone](Backbone.png)

## 算法原理

MobileNetv3模型采用混合使用轻量级深度可分离卷积和逆残差结构（Inverted Residuals）的算法原理，以实现高效计算和良好的模型性能

![Algorithm_principle](Algorithm_principle.png)

## 环境配置
### Docker(方法一)
此处提供[光源](https://www.sourcefind.cn/#/service-list)拉取docker镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm_fp32_dtk22.10.1_py38_centos-7.6-latest
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /root/tvm-0.11-dev0/apps/
git clone  http://developer.hpccube.com/codes/modelzoo/mobilenet_v3_tvm.git
```

## 数据集
在本测试中可以使用ImageNet-2012数据集。
- 官方下载通道
  - [https://image-net.org/](https://image-net.org/)
  数据结构如下：
```
data
    ├──imagenet
        ├── meta
            ├──val.txt
            ├──train.txt
            ...
        ├── train
        ├── val
```


## 推理

Python Deploy测试参考：
```
    cd  mobilenet_v3_tvm
    ulimit -s unlimited
    export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
    export HIP_VISIBLE_DEVICES=2(此处修改为对应加速卡ID号)
    python  val_onnx.py --test-only  --data-path /parastor/DL_DATA/ImageNet-pytorch --model mobilenet_v3_large --b 1 --pretrained
```
## result
![result](result.png)

## 精度

测试数据：ImageNet-pytorch，使用的加速卡:Z100L。
| Acc@1 | Acc@5 |
| :------: | :------: |
| 74.054 | 91.340 |
## 应用场景
### 算法类别
图像分类

### 热点行业
制造,能源,交通,网安
## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/mobilenet_v3_tvm

## 参考资料

https://github.com/open-mmlab/mmpretrain

