# MobileNet_v3

## 论文

Searching for MobileNetV3

https://arxiv.org/pdf/1905.02244.pdf

## 模型结构

MobileNetv3模型采用轻量级的深度可分离卷积（depthwise separable convolution）结构，以减少模型参数量和计算复杂度。

![Backbone](Backbone.png)

## 算法原理

MobileNetv3模型采用混合使用轻量级深度可分离卷积和逆残差结构（Inverted Residuals）的算法原理，以实现高效计算和良好的模型性能

![Algorithm_principle](Algorithm_principle.png)

## 环境配置
### Docker(方法一)
此处提供[光源](https://www.sourcefind.cn/#/service-list)拉取docker镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm_fp32_dtk22.10.1_py38_centos-7.6-latest
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /root/tvm-0.11-dev0/apps/
git clone  http://developer.hpccube.com/codes/modelzoo/mobilenet_v3_tvm.git
```

## 数据集
在本测试中可以使用ImageNet数据集。
下载ImageNet数据集：https://image-net.org/
数据结构如下：
```
data
    ├──imagenet
        ├── meta
            ├──val.txt
            ├──train.txt
            ...
        ├── train
        ├── val

```


## 推理

Python Deploy测试参考：
```
    cd  mobilenet_v3_tvm
    ulimit -s unlimited
    export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
    export HIP_VISIBLE_DEVICES=2(此处修改为对应加速卡ID号)
    python  val_onnx.py --test-only  --data-path /parastor/DL_DATA/ImageNet-pytorch --model mobilenet_v3_large --b 1 --pretrained
```
## result
![result](result.png)

### 精度

测试数据：ImageNet-pytorch，使用的加速卡:Z100L。
```
Test:  [    0/50000]  eta: 21:13:14  loss: 3.7605 (3.7605)  acc1: 0.0000 (0.0000)  acc5: 100.0000 (100.0000)  time: 1.5279  data: 1.2693  max mem: 86
Test:  [  100/50000]  eta: 0:16:33  loss: 0.0005 (0.5272)  acc1: 100.0000 (88.1188)  acc5: 100.0000 (97.0297)  time: 0.0051  data: 0.0002  max mem: 86
Test:  [  200/50000]  eta: 0:10:23  loss: 0.1722 (0.6195)  acc1: 100.0000 (82.5871)  acc5: 100.0000 (96.5174)  time: 0.0050  data: 0.0002  max mem: 86
Test:  [  300/50000]  eta: 0:08:11  loss: 0.0325 (0.6624)  acc1: 100.0000 (82.0598)  acc5: 100.0000 (96.0133)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [  400/50000]  eta: 0:07:03  loss: 0.0283 (0.7113)  acc1: 100.0000 (81.7955)  acc5: 100.0000 (94.7631)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [  500/50000]  eta: 0:06:19  loss: 0.0000 (0.6293)  acc1: 100.0000 (83.8323)  acc5: 100.0000 (95.4092)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [  600/50000]  eta: 0:05:51  loss: 0.0002 (0.5730)  acc1: 100.0000 (85.3577)  acc5: 100.0000 (95.8403)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [  700/50000]  eta: 0:05:30  loss: 0.0023 (0.5215)  acc1: 100.0000 (86.5906)  acc5: 100.0000 (96.2910)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [  800/50000]  eta: 0:05:13  loss: 0.0003 (0.4884)  acc1: 100.0000 (87.5156)  acc5: 100.0000 (96.5044)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [  900/50000]  eta: 0:04:59  loss: 0.0004 (0.4812)  acc1: 100.0000 (87.6804)  acc5: 100.0000 (96.8923)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 1000/50000]  eta: 0:04:50  loss: 0.0004 (0.4654)  acc1: 100.0000 (88.4116)  acc5: 100.0000 (97.0030)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 1100/50000]  eta: 0:04:42  loss: 0.0158 (0.5022)  acc1: 100.0000 (87.4659)  acc5: 100.0000 (96.5486)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 1200/50000]  eta: 0:04:35  loss: 0.0051 (0.4699)  acc1: 100.0000 (88.1765)  acc5: 100.0000 (96.8360)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 1300/50000]  eta: 0:04:30  loss: 0.0049 (0.4499)  acc1: 100.0000 (88.8547)  acc5: 100.0000 (96.9254)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 1400/50000]  eta: 0:04:24  loss: 0.0190 (0.5285)  acc1: 100.0000 (87.2234)  acc5: 100.0000 (96.4311)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 1500/50000]  eta: 0:04:19  loss: 0.0029 (0.5403)  acc1: 100.0000 (87.1419)  acc5: 100.0000 (96.1359)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 1600/50000]  eta: 0:04:16  loss: 0.0291 (0.5636)  acc1: 100.0000 (86.8832)  acc5: 100.0000 (96.0025)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [ 1700/50000]  eta: 0:04:13  loss: 0.0790 (0.6317)  acc1: 100.0000 (85.3028)  acc5: 100.0000 (95.7084)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 1800/50000]  eta: 0:04:10  loss: 0.8301 (0.6861)  acc1: 0.0000 (83.8978)  acc5: 100.0000 (95.2804)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [ 1900/50000]  eta: 0:04:07  loss: 0.1593 (0.6977)  acc1: 100.0000 (83.2194)  acc5: 100.0000 (95.4235)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 2000/50000]  eta: 0:04:05  loss: 0.0165 (0.7040)  acc1: 100.0000 (83.2084)  acc5: 100.0000 (95.4023)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 2100/50000]  eta: 0:04:03  loss: 0.0156 (0.7113)  acc1: 100.0000 (82.8653)  acc5: 100.0000 (95.4307)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 2200/50000]  eta: 0:04:01  loss: 0.0035 (0.7085)  acc1: 100.0000 (82.9623)  acc5: 100.0000 (95.4112)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 2300/50000]  eta: 0:03:59  loss: 0.0000 (0.7477)  acc1: 100.0000 (82.3990)  acc5: 100.0000 (95.0456)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 2400/50000]  eta: 0:03:57  loss: 0.0144 (0.7674)  acc1: 100.0000 (81.7576)  acc5: 100.0000 (94.9188)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [ 2500/50000]  eta: 0:03:55  loss: 0.1349 (0.7727)  acc1: 100.0000 (81.7673)  acc5: 100.0000 (94.7621)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 2600/50000]  eta: 0:03:53  loss: 0.0001 (0.7679)  acc1: 100.0000 (81.8916)  acc5: 100.0000 (94.6943)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 2700/50000]  eta: 0:03:50  loss: 0.2303 (0.7688)  acc1: 100.0000 (81.7845)  acc5: 100.0000 (94.6686)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 2800/50000]  eta: 0:03:48  loss: 0.1836 (0.7950)  acc1: 100.0000 (81.1853)  acc5: 100.0000 (94.5734)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 2900/50000]  eta: 0:03:47  loss: 0.0785 (0.7940)  acc1: 100.0000 (81.0410)  acc5: 100.0000 (94.5881)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 3000/50000]  eta: 0:03:45  loss: 0.8794 (0.8190)  acc1: 100.0000 (80.5398)  acc5: 100.0000 (94.3019)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 3100/50000]  eta: 0:03:43  loss: 0.1602 (0.8417)  acc1: 100.0000 (79.8130)  acc5: 100.0000 (94.3567)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 3200/50000]  eta: 0:03:41  loss: 0.0120 (0.8620)  acc1: 100.0000 (79.2565)  acc5: 100.0000 (94.0331)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 3300/50000]  eta: 0:03:40  loss: 0.1979 (0.8830)  acc1: 100.0000 (78.8549)  acc5: 100.0000 (93.9109)  time: 0.0041  data: 0.0003  max mem: 86
Test:  [ 3400/50000]  eta: 0:03:39  loss: 0.8700 (0.8987)  acc1: 0.0000 (78.3593)  acc5: 100.0000 (93.7959)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [ 3500/50000]  eta: 0:03:38  loss: 0.0001 (0.9023)  acc1: 100.0000 (77.8920)  acc5: 100.0000 (93.7446)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 3600/50000]  eta: 0:03:37  loss: 0.0002 (0.8921)  acc1: 100.0000 (78.0894)  acc5: 100.0000 (93.7795)  time: 0.0048  data: 0.0002  max mem: 86
Test:  [ 3700/50000]  eta: 0:03:36  loss: 1.0290 (0.8984)  acc1: 0.0000 (77.5736)  acc5: 100.0000 (93.8665)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 3800/50000]  eta: 0:03:35  loss: 0.0186 (0.9037)  acc1: 100.0000 (77.2691)  acc5: 100.0000 (93.9227)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 3900/50000]  eta: 0:03:35  loss: 0.0721 (0.9016)  acc1: 100.0000 (77.3135)  acc5: 100.0000 (93.9503)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 4000/50000]  eta: 0:03:34  loss: 0.0351 (0.9084)  acc1: 100.0000 (77.3057)  acc5: 100.0000 (93.8765)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 4100/50000]  eta: 0:03:33  loss: 0.0029 (0.8997)  acc1: 100.0000 (77.4689)  acc5: 100.0000 (94.0015)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 4200/50000]  eta: 0:03:32  loss: 0.0013 (0.8858)  acc1: 100.0000 (77.7910)  acc5: 100.0000 (94.1204)  time: 0.0048  data: 0.0002  max mem: 86
Test:  [ 4300/50000]  eta: 0:03:32  loss: 0.0011 (0.8741)  acc1: 100.0000 (78.1214)  acc5: 100.0000 (94.1641)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 4400/50000]  eta: 0:03:31  loss: 0.0000 (0.8666)  acc1: 100.0000 (78.1641)  acc5: 100.0000 (94.2513)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 4500/50000]  eta: 0:03:30  loss: 0.0001 (0.8528)  acc1: 100.0000 (78.5603)  acc5: 100.0000 (94.3568)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [ 4600/50000]  eta: 0:03:30  loss: 0.0002 (0.8414)  acc1: 100.0000 (78.8524)  acc5: 100.0000 (94.3708)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 4700/50000]  eta: 0:03:29  loss: 0.0031 (0.8295)  acc1: 100.0000 (79.1534)  acc5: 100.0000 (94.4905)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 4800/50000]  eta: 0:03:29  loss: 0.0007 (0.8202)  acc1: 100.0000 (79.4210)  acc5: 100.0000 (94.5220)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 4900/50000]  eta: 0:03:28  loss: 0.0011 (0.8136)  acc1: 100.0000 (79.6164)  acc5: 100.0000 (94.5725)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [ 5000/50000]  eta: 0:03:27  loss: 0.0025 (0.8080)  acc1: 100.0000 (79.7041)  acc5: 100.0000 (94.6411)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 5100/50000]  eta: 0:03:26  loss: 0.3220 (0.8063)  acc1: 100.0000 (79.7099)  acc5: 100.0000 (94.6481)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 5200/50000]  eta: 0:03:25  loss: 0.0062 (0.8012)  acc1: 100.0000 (79.8500)  acc5: 100.0000 (94.6164)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [ 5300/50000]  eta: 0:03:25  loss: 0.0002 (0.7945)  acc1: 100.0000 (80.0415)  acc5: 100.0000 (94.6237)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 5400/50000]  eta: 0:03:24  loss: 0.0015 (0.7994)  acc1: 100.0000 (80.1889)  acc5: 100.0000 (94.5751)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 5500/50000]  eta: 0:03:24  loss: 0.0039 (0.8008)  acc1: 100.0000 (80.2218)  acc5: 100.0000 (94.5646)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [ 5600/50000]  eta: 0:03:23  loss: 0.0009 (0.7973)  acc1: 100.0000 (80.3428)  acc5: 100.0000 (94.5903)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 5700/50000]  eta: 0:03:22  loss: 0.0045 (0.8016)  acc1: 100.0000 (80.3368)  acc5: 100.0000 (94.4922)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 5800/50000]  eta: 0:03:21  loss: 0.0441 (0.8010)  acc1: 100.0000 (80.4172)  acc5: 100.0000 (94.4665)  time: 0.0043  data: 0.0003  max mem: 86
Test:  [ 5900/50000]  eta: 0:03:20  loss: 0.0016 (0.8022)  acc1: 100.0000 (80.5287)  acc5: 100.0000 (94.4416)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 6000/50000]  eta: 0:03:20  loss: 0.0303 (0.8104)  acc1: 100.0000 (80.4199)  acc5: 100.0000 (94.4176)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 6100/50000]  eta: 0:03:19  loss: 0.0044 (0.8116)  acc1: 100.0000 (80.3475)  acc5: 100.0000 (94.4271)  time: 0.0038  data: 0.0001  max mem: 86
Test:  [ 6200/50000]  eta: 0:03:18  loss: 0.0818 (0.8107)  acc1: 100.0000 (80.3580)  acc5: 100.0000 (94.3719)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 6300/50000]  eta: 0:03:17  loss: 0.0063 (0.8139)  acc1: 100.0000 (80.2888)  acc5: 100.0000 (94.3977)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 6400/50000]  eta: 0:03:17  loss: 0.0055 (0.8195)  acc1: 100.0000 (80.3000)  acc5: 100.0000 (94.2978)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 6500/50000]  eta: 0:03:16  loss: 0.0001 (0.8117)  acc1: 100.0000 (80.4645)  acc5: 100.0000 (94.3393)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 6600/50000]  eta: 0:03:15  loss: 0.0092 (0.8027)  acc1: 100.0000 (80.6696)  acc5: 100.0000 (94.4251)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 6700/50000]  eta: 0:03:15  loss: 0.0012 (0.7978)  acc1: 100.0000 (80.7790)  acc5: 100.0000 (94.4337)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 6800/50000]  eta: 0:03:14  loss: 0.0000 (0.7927)  acc1: 100.0000 (80.8558)  acc5: 100.0000 (94.4861)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 6900/50000]  eta: 0:03:13  loss: 0.0122 (0.7864)  acc1: 100.0000 (81.0172)  acc5: 100.0000 (94.5225)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [ 7000/50000]  eta: 0:03:12  loss: 0.0003 (0.7786)  acc1: 100.0000 (81.2170)  acc5: 100.0000 (94.5579)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 7100/50000]  eta: 0:03:11  loss: 0.0009 (0.7743)  acc1: 100.0000 (81.3407)  acc5: 100.0000 (94.5782)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [ 7200/50000]  eta: 0:03:11  loss: 0.0001 (0.7686)  acc1: 100.0000 (81.4331)  acc5: 100.0000 (94.6257)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 7300/50000]  eta: 0:03:10  loss: 0.0002 (0.7626)  acc1: 100.0000 (81.6053)  acc5: 100.0000 (94.6583)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 7400/50000]  eta: 0:03:09  loss: 0.0007 (0.7567)  acc1: 100.0000 (81.7457)  acc5: 100.0000 (94.7034)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [ 7500/50000]  eta: 0:03:10  loss: 0.0025 (0.7521)  acc1: 100.0000 (81.8558)  acc5: 100.0000 (94.7074)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [ 7600/50000]  eta: 0:03:09  loss: 0.0618 (0.7581)  acc1: 100.0000 (81.7392)  acc5: 100.0000 (94.6718)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [ 7700/50000]  eta: 0:03:08  loss: 0.2603 (0.7584)  acc1: 100.0000 (81.7167)  acc5: 100.0000 (94.6760)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [ 7800/50000]  eta: 0:03:08  loss: 0.3902 (0.7611)  acc1: 100.0000 (81.6177)  acc5: 100.0000 (94.6545)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 7900/50000]  eta: 0:03:08  loss: 0.0121 (0.7564)  acc1: 100.0000 (81.7745)  acc5: 100.0000 (94.6969)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [ 8000/50000]  eta: 0:03:07  loss: 0.6661 (0.7616)  acc1: 0.0000 (81.5523)  acc5: 100.0000 (94.6882)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 8100/50000]  eta: 0:03:07  loss: 0.0326 (0.7601)  acc1: 100.0000 (81.5578)  acc5: 100.0000 (94.6797)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 8200/50000]  eta: 0:03:07  loss: 0.6533 (0.7703)  acc1: 100.0000 (81.4413)  acc5: 100.0000 (94.5982)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 8300/50000]  eta: 0:03:06  loss: 0.5622 (0.7768)  acc1: 100.0000 (81.3637)  acc5: 100.0000 (94.5428)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 8400/50000]  eta: 0:03:06  loss: 0.9667 (0.7885)  acc1: 0.0000 (80.9666)  acc5: 100.0000 (94.4768)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 8500/50000]  eta: 0:03:06  loss: 0.0256 (0.7869)  acc1: 100.0000 (81.0022)  acc5: 100.0000 (94.5065)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 8600/50000]  eta: 0:03:05  loss: 0.0389 (0.7950)  acc1: 100.0000 (80.8394)  acc5: 100.0000 (94.4774)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [ 8700/50000]  eta: 0:03:05  loss: 0.2748 (0.7973)  acc1: 100.0000 (80.7378)  acc5: 100.0000 (94.4604)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [ 8800/50000]  eta: 0:03:04  loss: 0.1653 (0.8007)  acc1: 100.0000 (80.7181)  acc5: 100.0000 (94.4438)  time: 0.0046  data: 0.0003  max mem: 86
Test:  [ 8900/50000]  eta: 0:03:04  loss: 0.1470 (0.7986)  acc1: 100.0000 (80.7550)  acc5: 100.0000 (94.4388)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [ 9000/50000]  eta: 0:03:03  loss: 0.2561 (0.7993)  acc1: 100.0000 (80.7133)  acc5: 100.0000 (94.4340)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [ 9100/50000]  eta: 0:03:03  loss: 0.0316 (0.7989)  acc1: 100.0000 (80.6725)  acc5: 100.0000 (94.4621)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [ 9200/50000]  eta: 0:03:02  loss: 0.3239 (0.7978)  acc1: 100.0000 (80.6543)  acc5: 100.0000 (94.4680)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 9300/50000]  eta: 0:03:01  loss: 0.1094 (0.8015)  acc1: 100.0000 (80.5075)  acc5: 100.0000 (94.4737)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [ 9400/50000]  eta: 0:03:00  loss: 0.2506 (0.8040)  acc1: 100.0000 (80.4489)  acc5: 100.0000 (94.4580)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 9500/50000]  eta: 0:03:00  loss: 0.1578 (0.8035)  acc1: 100.0000 (80.4021)  acc5: 100.0000 (94.4743)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [ 9600/50000]  eta: 0:03:00  loss: 0.0188 (0.8056)  acc1: 100.0000 (80.4187)  acc5: 100.0000 (94.4381)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [ 9700/50000]  eta: 0:02:59  loss: 0.4514 (0.8102)  acc1: 100.0000 (80.2495)  acc5: 100.0000 (94.4233)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [ 9800/50000]  eta: 0:02:58  loss: 0.0612 (0.8095)  acc1: 100.0000 (80.2775)  acc5: 100.0000 (94.4189)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [ 9900/50000]  eta: 0:02:58  loss: 0.3089 (0.8120)  acc1: 100.0000 (80.2242)  acc5: 100.0000 (94.4248)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [10000/50000]  eta: 0:02:57  loss: 0.0415 (0.8116)  acc1: 100.0000 (80.2320)  acc5: 100.0000 (94.4606)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [10100/50000]  eta: 0:02:57  loss: 0.5171 (0.8145)  acc1: 100.0000 (80.0614)  acc5: 100.0000 (94.4758)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [10200/50000]  eta: 0:02:56  loss: 0.0181 (0.8114)  acc1: 100.0000 (80.0902)  acc5: 100.0000 (94.5103)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [10300/50000]  eta: 0:02:56  loss: 0.0997 (0.8119)  acc1: 100.0000 (80.0408)  acc5: 100.0000 (94.5345)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [10400/50000]  eta: 0:02:55  loss: 0.0290 (0.8098)  acc1: 100.0000 (80.0788)  acc5: 100.0000 (94.5582)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [10500/50000]  eta: 0:02:55  loss: 0.0330 (0.8097)  acc1: 100.0000 (80.1257)  acc5: 100.0000 (94.5624)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [10600/50000]  eta: 0:02:54  loss: 0.1191 (0.8095)  acc1: 100.0000 (80.1057)  acc5: 100.0000 (94.5477)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [10700/50000]  eta: 0:02:54  loss: 0.0099 (0.8100)  acc1: 100.0000 (80.0953)  acc5: 100.0000 (94.5426)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [10800/50000]  eta: 0:02:53  loss: 0.2072 (0.8087)  acc1: 100.0000 (80.1315)  acc5: 100.0000 (94.5468)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [10900/50000]  eta: 0:02:53  loss: 0.0128 (0.8042)  acc1: 100.0000 (80.2312)  acc5: 100.0000 (94.5785)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [11000/50000]  eta: 0:02:52  loss: 0.0486 (0.8027)  acc1: 100.0000 (80.2382)  acc5: 100.0000 (94.6187)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [11100/50000]  eta: 0:02:52  loss: 0.0621 (0.8054)  acc1: 100.0000 (80.1910)  acc5: 100.0000 (94.6041)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [11200/50000]  eta: 0:02:51  loss: 0.0130 (0.8056)  acc1: 100.0000 (80.1893)  acc5: 100.0000 (94.5719)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [11300/50000]  eta: 0:02:51  loss: 0.0220 (0.8028)  acc1: 100.0000 (80.2407)  acc5: 100.0000 (94.5934)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [11400/50000]  eta: 0:02:50  loss: 0.0704 (0.8124)  acc1: 100.0000 (80.1333)  acc5: 100.0000 (94.5180)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [11500/50000]  eta: 0:02:50  loss: 0.0229 (0.8090)  acc1: 100.0000 (80.2278)  acc5: 100.0000 (94.5135)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [11600/50000]  eta: 0:02:49  loss: 0.3336 (0.8100)  acc1: 100.0000 (80.1396)  acc5: 100.0000 (94.5005)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [11700/50000]  eta: 0:02:49  loss: 0.0793 (0.8110)  acc1: 100.0000 (80.1214)  acc5: 100.0000 (94.4877)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [11800/50000]  eta: 0:02:48  loss: 0.0249 (0.8095)  acc1: 100.0000 (80.1542)  acc5: 100.0000 (94.5174)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [11900/50000]  eta: 0:02:47  loss: 0.0822 (0.8103)  acc1: 100.0000 (80.1361)  acc5: 100.0000 (94.4711)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [12000/50000]  eta: 0:02:47  loss: 0.0385 (0.8100)  acc1: 100.0000 (80.1350)  acc5: 100.0000 (94.5088)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [12100/50000]  eta: 0:02:46  loss: 0.2712 (0.8136)  acc1: 100.0000 (79.9273)  acc5: 100.0000 (94.5376)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [12200/50000]  eta: 0:02:46  loss: 0.0601 (0.8135)  acc1: 100.0000 (79.8951)  acc5: 100.0000 (94.5496)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [12300/50000]  eta: 0:02:45  loss: 0.0080 (0.8108)  acc1: 100.0000 (79.9610)  acc5: 100.0000 (94.5695)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [12400/50000]  eta: 0:02:45  loss: 0.0194 (0.8125)  acc1: 100.0000 (79.9129)  acc5: 100.0000 (94.5488)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [12500/50000]  eta: 0:02:44  loss: 0.2914 (0.8163)  acc1: 100.0000 (79.7696)  acc5: 100.0000 (94.5444)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [12600/50000]  eta: 0:02:44  loss: 0.0031 (0.8145)  acc1: 100.0000 (79.7794)  acc5: 100.0000 (94.5877)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [12700/50000]  eta: 0:02:43  loss: 0.0760 (0.8128)  acc1: 100.0000 (79.7969)  acc5: 100.0000 (94.6146)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [12800/50000]  eta: 0:02:43  loss: 0.0001 (0.8072)  acc1: 100.0000 (79.9234)  acc5: 100.0000 (94.6489)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [12900/50000]  eta: 0:02:42  loss: 0.0351 (0.8071)  acc1: 100.0000 (79.9008)  acc5: 100.0000 (94.6516)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [13000/50000]  eta: 0:02:42  loss: 0.0030 (0.8019)  acc1: 100.0000 (80.0323)  acc5: 100.0000 (94.6927)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [13100/50000]  eta: 0:02:41  loss: 0.0005 (0.7990)  acc1: 100.0000 (80.1084)  acc5: 100.0000 (94.7180)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [13200/50000]  eta: 0:02:40  loss: 0.0728 (0.7972)  acc1: 100.0000 (80.1454)  acc5: 100.0000 (94.7352)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [13300/50000]  eta: 0:02:40  loss: 0.6036 (0.7994)  acc1: 100.0000 (80.0241)  acc5: 100.0000 (94.7372)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [13400/50000]  eta: 0:02:39  loss: 0.0842 (0.8006)  acc1: 100.0000 (79.9269)  acc5: 100.0000 (94.7392)  time: 0.0050  data: 0.0002  max mem: 86
Test:  [13500/50000]  eta: 0:02:39  loss: 0.3301 (0.7995)  acc1: 100.0000 (79.9348)  acc5: 100.0000 (94.7634)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [13600/50000]  eta: 0:02:38  loss: 0.4816 (0.8014)  acc1: 100.0000 (79.8765)  acc5: 100.0000 (94.7651)  time: 0.0039  data: 0.0001  max mem: 86
Test:  [13700/50000]  eta: 0:02:38  loss: 0.0488 (0.8076)  acc1: 100.0000 (79.8044)  acc5: 100.0000 (94.7376)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [13800/50000]  eta: 0:02:37  loss: 0.0009 (0.8044)  acc1: 100.0000 (79.9145)  acc5: 100.0000 (94.7685)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [13900/50000]  eta: 0:02:37  loss: 0.2700 (0.8054)  acc1: 100.0000 (79.8576)  acc5: 100.0000 (94.7917)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [14000/50000]  eta: 0:02:36  loss: 0.0046 (0.8038)  acc1: 100.0000 (79.8657)  acc5: 100.0000 (94.8218)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [14100/50000]  eta: 0:02:36  loss: 0.6475 (0.8075)  acc1: 100.0000 (79.7603)  acc5: 100.0000 (94.8089)  time: 0.0049  data: 0.0002  max mem: 86
Test:  [14200/50000]  eta: 0:02:35  loss: 0.0036 (0.8107)  acc1: 100.0000 (79.5930)  acc5: 100.0000 (94.8032)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [14300/50000]  eta: 0:02:34  loss: 0.8769 (0.8150)  acc1: 0.0000 (79.5189)  acc5: 100.0000 (94.7416)  time: 0.0038  data: 0.0003  max mem: 86
Test:  [14400/50000]  eta: 0:02:34  loss: 0.0047 (0.8161)  acc1: 100.0000 (79.5500)  acc5: 100.0000 (94.7365)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [14500/50000]  eta: 0:02:33  loss: 0.0571 (0.8135)  acc1: 100.0000 (79.5945)  acc5: 100.0000 (94.7659)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [14600/50000]  eta: 0:02:33  loss: 0.0004 (0.8125)  acc1: 100.0000 (79.6384)  acc5: 100.0000 (94.7743)  time: 0.0035  data: 0.0002  max mem: 86
Test:  [14700/50000]  eta: 0:02:32  loss: 0.0237 (0.8089)  acc1: 100.0000 (79.7293)  acc5: 100.0000 (94.8031)  time: 0.0099  data: 0.0060  max mem: 86
Test:  [14800/50000]  eta: 0:02:32  loss: 0.0363 (0.8052)  acc1: 100.0000 (79.7784)  acc5: 100.0000 (94.8382)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [14900/50000]  eta: 0:02:31  loss: 0.0038 (0.8080)  acc1: 100.0000 (79.7933)  acc5: 100.0000 (94.8259)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [15000/50000]  eta: 0:02:31  loss: 0.1103 (0.8090)  acc1: 100.0000 (79.7680)  acc5: 100.0000 (94.8203)  time: 0.0050  data: 0.0002  max mem: 86
Test:  [15100/50000]  eta: 0:02:31  loss: 0.0379 (0.8061)  acc1: 100.0000 (79.8027)  acc5: 100.0000 (94.8414)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [15200/50000]  eta: 0:02:30  loss: 0.2943 (0.8078)  acc1: 100.0000 (79.7448)  acc5: 100.0000 (94.8622)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [15300/50000]  eta: 0:02:30  loss: 0.0289 (0.8078)  acc1: 100.0000 (79.7137)  acc5: 100.0000 (94.8827)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [15400/50000]  eta: 0:02:29  loss: 0.0153 (0.8058)  acc1: 100.0000 (79.7546)  acc5: 100.0000 (94.8964)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [15500/50000]  eta: 0:02:29  loss: 0.0358 (0.8057)  acc1: 100.0000 (79.7239)  acc5: 100.0000 (94.8907)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [15600/50000]  eta: 0:02:28  loss: 0.1787 (0.8104)  acc1: 100.0000 (79.6103)  acc5: 100.0000 (94.8529)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [15700/50000]  eta: 0:02:28  loss: 0.2585 (0.8120)  acc1: 100.0000 (79.5172)  acc5: 100.0000 (94.8602)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [15800/50000]  eta: 0:02:27  loss: 0.0670 (0.8148)  acc1: 100.0000 (79.5140)  acc5: 100.0000 (94.8168)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [15900/50000]  eta: 0:02:27  loss: 0.0272 (0.8127)  acc1: 100.0000 (79.5736)  acc5: 100.0000 (94.8368)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [16000/50000]  eta: 0:02:26  loss: 0.0547 (0.8122)  acc1: 100.0000 (79.6013)  acc5: 100.0000 (94.8503)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [16100/50000]  eta: 0:02:26  loss: 0.0000 (0.8089)  acc1: 100.0000 (79.6907)  acc5: 100.0000 (94.8699)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [16200/50000]  eta: 0:02:25  loss: 0.0006 (0.8054)  acc1: 100.0000 (79.7852)  acc5: 100.0000 (94.8954)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [16300/50000]  eta: 0:02:25  loss: 0.0003 (0.8019)  acc1: 100.0000 (79.8724)  acc5: 100.0000 (94.9267)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [16400/50000]  eta: 0:02:24  loss: 0.0062 (0.8004)  acc1: 100.0000 (79.9281)  acc5: 100.0000 (94.9332)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [16500/50000]  eta: 0:02:24  loss: 0.0020 (0.8020)  acc1: 100.0000 (79.9224)  acc5: 100.0000 (94.8973)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [16600/50000]  eta: 0:02:24  loss: 0.0321 (0.8014)  acc1: 100.0000 (79.9108)  acc5: 100.0000 (94.9160)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [16700/50000]  eta: 0:02:23  loss: 0.0001 (0.7972)  acc1: 100.0000 (80.0132)  acc5: 100.0000 (94.9464)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [16800/50000]  eta: 0:02:23  loss: 0.0031 (0.7957)  acc1: 100.0000 (80.0488)  acc5: 100.0000 (94.9646)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [16900/50000]  eta: 0:02:22  loss: 0.0138 (0.7970)  acc1: 100.0000 (80.0781)  acc5: 100.0000 (94.9707)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [17000/50000]  eta: 0:02:22  loss: 0.0021 (0.7951)  acc1: 100.0000 (80.1306)  acc5: 100.0000 (94.9768)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [17100/50000]  eta: 0:02:21  loss: 1.9055 (0.7958)  acc1: 0.0000 (80.1181)  acc5: 100.0000 (94.9594)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [17200/50000]  eta: 0:02:21  loss: 0.0138 (0.7940)  acc1: 100.0000 (80.1523)  acc5: 100.0000 (94.9770)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [17300/50000]  eta: 0:02:20  loss: 0.4505 (0.7939)  acc1: 100.0000 (80.1225)  acc5: 100.0000 (94.9829)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [17400/50000]  eta: 0:02:20  loss: 0.0002 (0.7931)  acc1: 100.0000 (80.1448)  acc5: 100.0000 (94.9601)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [17500/50000]  eta: 0:02:19  loss: 0.3345 (0.7926)  acc1: 100.0000 (80.0640)  acc5: 100.0000 (94.9774)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [17600/50000]  eta: 0:02:19  loss: 0.0260 (0.7892)  acc1: 100.0000 (80.1432)  acc5: 100.0000 (95.0003)  time: 0.0039  data: 0.0003  max mem: 86
Test:  [17700/50000]  eta: 0:02:18  loss: 0.0452 (0.7887)  acc1: 100.0000 (80.1198)  acc5: 100.0000 (95.0172)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [17800/50000]  eta: 0:02:18  loss: 0.0026 (0.7865)  acc1: 100.0000 (80.1865)  acc5: 100.0000 (95.0171)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [17900/50000]  eta: 0:02:17  loss: 0.0605 (0.7897)  acc1: 100.0000 (80.1017)  acc5: 100.0000 (95.0226)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [18000/50000]  eta: 0:02:17  loss: 0.1980 (0.7939)  acc1: 100.0000 (79.9956)  acc5: 100.0000 (95.0114)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [18100/50000]  eta: 0:02:17  loss: 0.0005 (0.7933)  acc1: 100.0000 (79.9845)  acc5: 100.0000 (95.0113)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [18200/50000]  eta: 0:02:16  loss: 0.0000 (0.7923)  acc1: 100.0000 (80.0231)  acc5: 100.0000 (95.0113)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [18300/50000]  eta: 0:02:16  loss: 0.0105 (0.7899)  acc1: 100.0000 (80.1049)  acc5: 100.0000 (95.0221)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [18400/50000]  eta: 0:02:15  loss: 0.0868 (0.7898)  acc1: 100.0000 (80.1261)  acc5: 100.0000 (95.0166)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [18500/50000]  eta: 0:02:15  loss: 0.0747 (0.7911)  acc1: 100.0000 (80.1146)  acc5: 100.0000 (94.9949)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [18600/50000]  eta: 0:02:14  loss: 0.0352 (0.7937)  acc1: 100.0000 (80.1086)  acc5: 100.0000 (94.9734)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [18700/50000]  eta: 0:02:14  loss: 0.0732 (0.7940)  acc1: 100.0000 (80.1294)  acc5: 100.0000 (94.9575)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [18800/50000]  eta: 0:02:13  loss: 0.0474 (0.7955)  acc1: 100.0000 (80.1074)  acc5: 100.0000 (94.9418)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [18900/50000]  eta: 0:02:13  loss: 0.1086 (0.7941)  acc1: 100.0000 (80.1386)  acc5: 100.0000 (94.9474)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [19000/50000]  eta: 0:02:12  loss: 0.0733 (0.7935)  acc1: 100.0000 (80.1484)  acc5: 100.0000 (94.9529)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [19100/50000]  eta: 0:02:12  loss: 1.5252 (0.7983)  acc1: 0.0000 (80.0063)  acc5: 100.0000 (94.9322)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [19200/50000]  eta: 0:02:11  loss: 0.0863 (0.8004)  acc1: 100.0000 (79.9385)  acc5: 100.0000 (94.9273)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [19300/50000]  eta: 0:02:11  loss: 0.7411 (0.7994)  acc1: 100.0000 (79.9285)  acc5: 100.0000 (94.9277)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [19400/50000]  eta: 0:02:10  loss: 0.0001 (0.8005)  acc1: 100.0000 (79.9083)  acc5: 100.0000 (94.9281)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [19500/50000]  eta: 0:02:10  loss: 0.0033 (0.8001)  acc1: 100.0000 (79.9190)  acc5: 100.0000 (94.9182)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [19600/50000]  eta: 0:02:09  loss: 0.0073 (0.8024)  acc1: 100.0000 (79.8786)  acc5: 100.0000 (94.9033)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [19700/50000]  eta: 0:02:09  loss: 0.0179 (0.8002)  acc1: 100.0000 (79.9452)  acc5: 100.0000 (94.9140)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [19800/50000]  eta: 0:02:08  loss: 0.1315 (0.8002)  acc1: 100.0000 (79.9303)  acc5: 100.0000 (94.9043)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [19900/50000]  eta: 0:02:08  loss: 0.0081 (0.7988)  acc1: 100.0000 (79.9910)  acc5: 100.0000 (94.9148)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [20000/50000]  eta: 0:02:07  loss: 0.1578 (0.7995)  acc1: 100.0000 (79.9760)  acc5: 100.0000 (94.9053)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [20100/50000]  eta: 0:02:07  loss: 0.1097 (0.8019)  acc1: 100.0000 (79.9015)  acc5: 100.0000 (94.8858)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [20200/50000]  eta: 0:02:06  loss: 0.0078 (0.8048)  acc1: 100.0000 (79.8673)  acc5: 100.0000 (94.8567)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [20300/50000]  eta: 0:02:06  loss: 0.0131 (0.8054)  acc1: 100.0000 (79.8778)  acc5: 100.0000 (94.8278)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [20400/50000]  eta: 0:02:05  loss: 0.0012 (0.8049)  acc1: 100.0000 (79.8882)  acc5: 100.0000 (94.8434)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [20500/50000]  eta: 0:02:05  loss: 0.3294 (0.8079)  acc1: 100.0000 (79.8303)  acc5: 100.0000 (94.8490)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [20600/50000]  eta: 0:02:04  loss: 0.0362 (0.8077)  acc1: 100.0000 (79.8262)  acc5: 100.0000 (94.8498)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [20700/50000]  eta: 0:02:04  loss: 0.7428 (0.8134)  acc1: 0.0000 (79.7111)  acc5: 100.0000 (94.8022)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [20800/50000]  eta: 0:02:03  loss: 1.3721 (0.8242)  acc1: 0.0000 (79.5058)  acc5: 100.0000 (94.6685)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [20900/50000]  eta: 0:02:03  loss: 0.0012 (0.8234)  acc1: 100.0000 (79.5225)  acc5: 100.0000 (94.6701)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [21000/50000]  eta: 0:02:02  loss: 0.2224 (0.8257)  acc1: 100.0000 (79.4724)  acc5: 100.0000 (94.6574)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [21100/50000]  eta: 0:02:02  loss: 0.2699 (0.8258)  acc1: 100.0000 (79.4749)  acc5: 100.0000 (94.6590)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [21200/50000]  eta: 0:02:02  loss: 0.2430 (0.8297)  acc1: 100.0000 (79.3925)  acc5: 100.0000 (94.6465)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [21300/50000]  eta: 0:02:01  loss: 0.0005 (0.8302)  acc1: 100.0000 (79.3953)  acc5: 100.0000 (94.6387)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [21400/50000]  eta: 0:02:01  loss: 0.1168 (0.8315)  acc1: 100.0000 (79.3748)  acc5: 100.0000 (94.6358)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [21500/50000]  eta: 0:02:00  loss: 0.0134 (0.8331)  acc1: 100.0000 (79.3591)  acc5: 100.0000 (94.6096)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [21600/50000]  eta: 0:02:00  loss: 0.1121 (0.8323)  acc1: 100.0000 (79.3713)  acc5: 100.0000 (94.6067)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [21700/50000]  eta: 0:01:59  loss: 0.0110 (0.8337)  acc1: 100.0000 (79.3374)  acc5: 100.0000 (94.6039)  time: 0.0040  data: 0.0003  max mem: 86
Test:  [21800/50000]  eta: 0:01:59  loss: 0.7444 (0.8395)  acc1: 0.0000 (79.1982)  acc5: 100.0000 (94.5369)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [21900/50000]  eta: 0:01:58  loss: 0.2301 (0.8426)  acc1: 100.0000 (79.1425)  acc5: 100.0000 (94.5071)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [22000/50000]  eta: 0:01:58  loss: 0.0000 (0.8459)  acc1: 100.0000 (79.0964)  acc5: 100.0000 (94.4548)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [22100/50000]  eta: 0:01:57  loss: 0.1825 (0.8474)  acc1: 100.0000 (79.0733)  acc5: 100.0000 (94.4392)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [22200/50000]  eta: 0:01:57  loss: 0.0235 (0.8493)  acc1: 100.0000 (79.0370)  acc5: 100.0000 (94.4327)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [22300/50000]  eta: 0:01:56  loss: 1.0514 (0.8507)  acc1: 0.0000 (79.0054)  acc5: 100.0000 (94.4173)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [22400/50000]  eta: 0:01:56  loss: 0.0888 (0.8552)  acc1: 100.0000 (78.9072)  acc5: 100.0000 (94.3753)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [22500/50000]  eta: 0:01:55  loss: 0.0557 (0.8541)  acc1: 100.0000 (78.9298)  acc5: 100.0000 (94.3825)  time: 0.0045  data: 0.0003  max mem: 86
Test:  [22600/50000]  eta: 0:01:55  loss: 0.0050 (0.8534)  acc1: 100.0000 (78.9567)  acc5: 100.0000 (94.3719)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [22700/50000]  eta: 0:01:54  loss: 0.2502 (0.8564)  acc1: 100.0000 (78.8952)  acc5: 100.0000 (94.3439)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [22800/50000]  eta: 0:01:54  loss: 0.0013 (0.8606)  acc1: 100.0000 (78.7948)  acc5: 100.0000 (94.2766)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [22900/50000]  eta: 0:01:53  loss: 0.1173 (0.8620)  acc1: 100.0000 (78.7608)  acc5: 100.0000 (94.2492)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [23000/50000]  eta: 0:01:53  loss: 0.3043 (0.8637)  acc1: 100.0000 (78.7314)  acc5: 100.0000 (94.2263)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [23100/50000]  eta: 0:01:52  loss: 1.0789 (0.8663)  acc1: 0.0000 (78.6156)  acc5: 100.0000 (94.2080)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [23200/50000]  eta: 0:01:52  loss: 0.4022 (0.8728)  acc1: 100.0000 (78.5311)  acc5: 100.0000 (94.1554)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [23300/50000]  eta: 0:01:52  loss: 1.2780 (0.8800)  acc1: 0.0000 (78.4044)  acc5: 100.0000 (94.0346)  time: 0.0053  data: 0.0013  max mem: 86
Test:  [23400/50000]  eta: 0:01:51  loss: 0.0102 (0.8784)  acc1: 100.0000 (78.4411)  acc5: 100.0000 (94.0473)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [23500/50000]  eta: 0:01:51  loss: 1.7649 (0.8824)  acc1: 0.0000 (78.3584)  acc5: 100.0000 (94.0088)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [23600/50000]  eta: 0:01:50  loss: 0.0051 (0.8853)  acc1: 100.0000 (78.3314)  acc5: 100.0000 (93.9791)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [23700/50000]  eta: 0:01:50  loss: 0.2883 (0.8852)  acc1: 100.0000 (78.3511)  acc5: 100.0000 (93.9707)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [23800/50000]  eta: 0:01:49  loss: 0.0004 (0.8854)  acc1: 100.0000 (78.3581)  acc5: 100.0000 (93.9582)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [23900/50000]  eta: 0:01:49  loss: 0.0361 (0.8858)  acc1: 100.0000 (78.3566)  acc5: 100.0000 (93.9417)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [24000/50000]  eta: 0:01:49  loss: 1.5626 (0.8937)  acc1: 0.0000 (78.2051)  acc5: 100.0000 (93.8628)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [24100/50000]  eta: 0:01:48  loss: 0.1333 (0.8958)  acc1: 100.0000 (78.1503)  acc5: 100.0000 (93.8467)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [24200/50000]  eta: 0:01:48  loss: 0.0076 (0.8986)  acc1: 100.0000 (78.0340)  acc5: 100.0000 (93.8391)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [24300/50000]  eta: 0:01:47  loss: 1.0008 (0.9013)  acc1: 0.0000 (77.9433)  acc5: 100.0000 (93.8315)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [24400/50000]  eta: 0:01:47  loss: 0.1565 (0.9017)  acc1: 100.0000 (77.9394)  acc5: 100.0000 (93.8281)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [24500/50000]  eta: 0:01:46  loss: 0.0557 (0.9064)  acc1: 100.0000 (77.8499)  acc5: 100.0000 (93.7839)  time: 0.0044  data: 0.0003  max mem: 86
Test:  [24600/50000]  eta: 0:01:46  loss: 0.0539 (0.9073)  acc1: 100.0000 (77.8383)  acc5: 100.0000 (93.7889)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [24700/50000]  eta: 0:01:46  loss: 2.4288 (0.9127)  acc1: 0.0000 (77.7337)  acc5: 100.0000 (93.7250)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [24800/50000]  eta: 0:01:45  loss: 0.0067 (0.9131)  acc1: 100.0000 (77.7146)  acc5: 100.0000 (93.7261)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [24900/50000]  eta: 0:01:45  loss: 0.3004 (0.9131)  acc1: 100.0000 (77.7037)  acc5: 100.0000 (93.7312)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [25000/50000]  eta: 0:01:44  loss: 1.6132 (0.9186)  acc1: 0.0000 (77.5929)  acc5: 100.0000 (93.6643)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [25100/50000]  eta: 0:01:44  loss: 1.4236 (0.9222)  acc1: 0.0000 (77.5427)  acc5: 100.0000 (93.6178)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [25200/50000]  eta: 0:01:44  loss: 0.2022 (0.9257)  acc1: 100.0000 (77.4811)  acc5: 100.0000 (93.5637)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [25300/50000]  eta: 0:01:43  loss: 0.8040 (0.9300)  acc1: 0.0000 (77.3962)  acc5: 100.0000 (93.5220)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [25400/50000]  eta: 0:01:43  loss: 0.0320 (0.9325)  acc1: 100.0000 (77.3670)  acc5: 100.0000 (93.5042)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [25500/50000]  eta: 0:01:42  loss: 0.4818 (0.9350)  acc1: 100.0000 (77.3029)  acc5: 100.0000 (93.4630)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [25600/50000]  eta: 0:01:42  loss: 0.3171 (0.9337)  acc1: 100.0000 (77.3173)  acc5: 100.0000 (93.4768)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [25700/50000]  eta: 0:01:41  loss: 0.9818 (0.9333)  acc1: 0.0000 (77.2966)  acc5: 100.0000 (93.4789)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [25800/50000]  eta: 0:01:41  loss: 0.7947 (0.9360)  acc1: 0.0000 (77.2334)  acc5: 100.0000 (93.4382)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [25900/50000]  eta: 0:01:41  loss: 0.1149 (0.9387)  acc1: 100.0000 (77.1592)  acc5: 100.0000 (93.4095)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [26000/50000]  eta: 0:01:40  loss: 0.0282 (0.9402)  acc1: 100.0000 (77.1586)  acc5: 100.0000 (93.3810)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [26100/50000]  eta: 0:01:40  loss: 0.0062 (0.9403)  acc1: 100.0000 (77.1695)  acc5: 100.0000 (93.3834)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [26200/50000]  eta: 0:01:39  loss: 0.8185 (0.9423)  acc1: 100.0000 (77.1383)  acc5: 100.0000 (93.3514)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [26300/50000]  eta: 0:01:39  loss: 0.0799 (0.9432)  acc1: 100.0000 (77.0959)  acc5: 100.0000 (93.3425)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [26400/50000]  eta: 0:01:39  loss: 1.7410 (0.9467)  acc1: 0.0000 (76.9857)  acc5: 100.0000 (93.3184)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [26500/50000]  eta: 0:01:38  loss: 0.3317 (0.9479)  acc1: 100.0000 (76.9895)  acc5: 100.0000 (93.2984)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [26600/50000]  eta: 0:01:38  loss: 0.2205 (0.9518)  acc1: 100.0000 (76.9294)  acc5: 100.0000 (93.2559)  time: 0.0049  data: 0.0002  max mem: 86
Test:  [26700/50000]  eta: 0:01:37  loss: 0.0376 (0.9516)  acc1: 100.0000 (76.9409)  acc5: 100.0000 (93.2474)  time: 0.0048  data: 0.0002  max mem: 86
Test:  [26800/50000]  eta: 0:01:37  loss: 0.0017 (0.9525)  acc1: 100.0000 (76.9412)  acc5: 100.0000 (93.2279)  time: 0.0048  data: 0.0002  max mem: 86
Test:  [26900/50000]  eta: 0:01:37  loss: 0.0244 (0.9534)  acc1: 100.0000 (76.9228)  acc5: 100.0000 (93.2307)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [27000/50000]  eta: 0:01:36  loss: 0.3235 (0.9550)  acc1: 100.0000 (76.8823)  acc5: 100.0000 (93.2225)  time: 0.0048  data: 0.0002  max mem: 86
Test:  [27100/50000]  eta: 0:01:36  loss: 1.2845 (0.9566)  acc1: 0.0000 (76.8348)  acc5: 100.0000 (93.1995)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [27200/50000]  eta: 0:01:36  loss: 0.4835 (0.9589)  acc1: 100.0000 (76.7876)  acc5: 100.0000 (93.1730)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [27300/50000]  eta: 0:01:35  loss: 0.0237 (0.9588)  acc1: 100.0000 (76.7847)  acc5: 100.0000 (93.1578)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [27400/50000]  eta: 0:01:35  loss: 0.0135 (0.9583)  acc1: 100.0000 (76.8038)  acc5: 100.0000 (93.1572)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [27500/50000]  eta: 0:01:34  loss: 1.2116 (0.9596)  acc1: 0.0000 (76.7863)  acc5: 100.0000 (93.1457)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [27600/50000]  eta: 0:01:34  loss: 0.1187 (0.9596)  acc1: 100.0000 (76.7834)  acc5: 100.0000 (93.1452)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [27700/50000]  eta: 0:01:34  loss: 0.0066 (0.9588)  acc1: 100.0000 (76.7987)  acc5: 100.0000 (93.1447)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [27800/50000]  eta: 0:01:33  loss: 0.0399 (0.9574)  acc1: 100.0000 (76.8426)  acc5: 100.0000 (93.1549)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [27900/50000]  eta: 0:01:33  loss: 0.1268 (0.9612)  acc1: 100.0000 (76.8073)  acc5: 100.0000 (93.1149)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [28000/50000]  eta: 0:01:32  loss: 0.0496 (0.9647)  acc1: 100.0000 (76.7223)  acc5: 100.0000 (93.0824)  time: 0.0062  data: 0.0002  max mem: 86
Test:  [28100/50000]  eta: 0:01:32  loss: 0.0062 (0.9628)  acc1: 100.0000 (76.7695)  acc5: 100.0000 (93.0928)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [28200/50000]  eta: 0:01:31  loss: 0.3135 (0.9621)  acc1: 100.0000 (76.7810)  acc5: 100.0000 (93.0854)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [28300/50000]  eta: 0:01:31  loss: 0.0000 (0.9602)  acc1: 100.0000 (76.8135)  acc5: 100.0000 (93.1063)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [28400/50000]  eta: 0:01:31  loss: 2.3275 (0.9628)  acc1: 0.0000 (76.7508)  acc5: 100.0000 (93.0777)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [28500/50000]  eta: 0:01:30  loss: 0.0125 (0.9610)  acc1: 100.0000 (76.7903)  acc5: 100.0000 (93.0880)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [28600/50000]  eta: 0:01:30  loss: 0.0271 (0.9603)  acc1: 100.0000 (76.7945)  acc5: 100.0000 (93.0981)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [28700/50000]  eta: 0:01:29  loss: 0.0012 (0.9598)  acc1: 100.0000 (76.8092)  acc5: 100.0000 (93.1013)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [28800/50000]  eta: 0:01:29  loss: 0.0002 (0.9593)  acc1: 100.0000 (76.8272)  acc5: 100.0000 (93.1009)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [28900/50000]  eta: 0:01:28  loss: 0.5748 (0.9582)  acc1: 100.0000 (76.8209)  acc5: 100.0000 (93.1110)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [29000/50000]  eta: 0:01:28  loss: 0.0352 (0.9589)  acc1: 100.0000 (76.7801)  acc5: 100.0000 (93.1175)  time: 0.0034  data: 0.0002  max mem: 86
Test:  [29100/50000]  eta: 0:01:27  loss: 0.0741 (0.9591)  acc1: 100.0000 (76.7912)  acc5: 100.0000 (93.1136)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [29200/50000]  eta: 0:01:27  loss: 0.0006 (0.9596)  acc1: 100.0000 (76.7919)  acc5: 100.0000 (93.1167)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [29300/50000]  eta: 0:01:26  loss: 2.7847 (0.9667)  acc1: 0.0000 (76.6766)  acc5: 100.0000 (93.0310)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [29400/50000]  eta: 0:01:26  loss: 0.4571 (0.9681)  acc1: 100.0000 (76.6403)  acc5: 100.0000 (93.0104)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [29500/50000]  eta: 0:01:26  loss: 0.0102 (0.9711)  acc1: 100.0000 (76.5838)  acc5: 100.0000 (92.9833)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [29600/50000]  eta: 0:01:25  loss: 0.0034 (0.9734)  acc1: 100.0000 (76.5413)  acc5: 100.0000 (92.9665)  time: 0.0102  data: 0.0067  max mem: 86
Test:  [29700/50000]  eta: 0:01:25  loss: 0.1565 (0.9735)  acc1: 100.0000 (76.5462)  acc5: 100.0000 (92.9632)  time: 0.0040  data: 0.0003  max mem: 86
Test:  [29800/50000]  eta: 0:01:24  loss: 0.0976 (0.9718)  acc1: 100.0000 (76.5813)  acc5: 100.0000 (92.9801)  time: 0.0035  data: 0.0002  max mem: 86
Test:  [29900/50000]  eta: 0:01:24  loss: 0.0910 (0.9741)  acc1: 100.0000 (76.5392)  acc5: 100.0000 (92.9434)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [30000/50000]  eta: 0:01:23  loss: 0.0262 (0.9762)  acc1: 100.0000 (76.5008)  acc5: 100.0000 (92.9302)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [30100/50000]  eta: 0:01:23  loss: 0.4759 (0.9820)  acc1: 100.0000 (76.4061)  acc5: 100.0000 (92.8640)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [30200/50000]  eta: 0:01:23  loss: 0.0131 (0.9812)  acc1: 100.0000 (76.4346)  acc5: 100.0000 (92.8810)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [30300/50000]  eta: 0:01:22  loss: 0.0078 (0.9805)  acc1: 100.0000 (76.4595)  acc5: 100.0000 (92.8814)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [30400/50000]  eta: 0:01:22  loss: 0.0000 (0.9786)  acc1: 100.0000 (76.5074)  acc5: 100.0000 (92.8884)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [30500/50000]  eta: 0:01:21  loss: 0.0187 (0.9795)  acc1: 100.0000 (76.4991)  acc5: 100.0000 (92.8756)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [30600/50000]  eta: 0:01:21  loss: 0.0008 (0.9788)  acc1: 100.0000 (76.5433)  acc5: 100.0000 (92.8760)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [30700/50000]  eta: 0:01:20  loss: 0.0136 (0.9775)  acc1: 100.0000 (76.5675)  acc5: 100.0000 (92.8862)  time: 0.0046  data: 0.0010  max mem: 86
Test:  [30800/50000]  eta: 0:01:20  loss: 0.0479 (0.9777)  acc1: 100.0000 (76.5722)  acc5: 100.0000 (92.8704)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [30900/50000]  eta: 0:01:19  loss: 0.2425 (0.9775)  acc1: 100.0000 (76.5865)  acc5: 100.0000 (92.8708)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [31000/50000]  eta: 0:01:19  loss: 0.6480 (0.9819)  acc1: 100.0000 (76.4879)  acc5: 100.0000 (92.8260)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [31100/50000]  eta: 0:01:19  loss: 0.0027 (0.9835)  acc1: 100.0000 (76.4059)  acc5: 100.0000 (92.8009)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [31200/50000]  eta: 0:01:18  loss: 2.3043 (0.9897)  acc1: 0.0000 (76.3020)  acc5: 100.0000 (92.7310)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [31300/50000]  eta: 0:01:18  loss: 0.0125 (0.9893)  acc1: 100.0000 (76.3011)  acc5: 100.0000 (92.7351)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [31400/50000]  eta: 0:01:17  loss: 0.0191 (0.9905)  acc1: 100.0000 (76.2778)  acc5: 100.0000 (92.7168)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [31500/50000]  eta: 0:01:17  loss: 0.1016 (0.9900)  acc1: 100.0000 (76.2896)  acc5: 100.0000 (92.7272)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [31600/50000]  eta: 0:01:16  loss: 0.9199 (0.9900)  acc1: 100.0000 (76.2856)  acc5: 100.0000 (92.7217)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [31700/50000]  eta: 0:01:16  loss: 5.9094 (0.9981)  acc1: 0.0000 (76.1774)  acc5: 0.0000 (92.6248)  time: 0.0039  data: 0.0003  max mem: 86
Test:  [31800/50000]  eta: 0:01:16  loss: 0.5320 (0.9992)  acc1: 100.0000 (76.1580)  acc5: 100.0000 (92.6197)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [31900/50000]  eta: 0:01:15  loss: 0.0417 (0.9993)  acc1: 100.0000 (76.1387)  acc5: 100.0000 (92.6272)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [32000/50000]  eta: 0:01:15  loss: 1.1720 (1.0015)  acc1: 0.0000 (75.9976)  acc5: 100.0000 (92.6315)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [32100/50000]  eta: 0:01:14  loss: 0.0168 (1.0000)  acc1: 100.0000 (76.0350)  acc5: 100.0000 (92.6420)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [32200/50000]  eta: 0:01:14  loss: 1.3763 (1.0011)  acc1: 0.0000 (75.9976)  acc5: 100.0000 (92.6182)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [32300/50000]  eta: 0:01:13  loss: 0.0001 (1.0009)  acc1: 100.0000 (76.0193)  acc5: 100.0000 (92.6256)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [32400/50000]  eta: 0:01:13  loss: 0.4792 (1.0012)  acc1: 100.0000 (76.0100)  acc5: 100.0000 (92.6052)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [32500/50000]  eta: 0:01:12  loss: 0.1603 (1.0021)  acc1: 100.0000 (76.0100)  acc5: 100.0000 (92.5879)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [32600/50000]  eta: 0:01:12  loss: 0.8276 (1.0068)  acc1: 0.0000 (75.9271)  acc5: 100.0000 (92.5248)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [32700/50000]  eta: 0:01:12  loss: 0.0924 (1.0085)  acc1: 100.0000 (75.9029)  acc5: 100.0000 (92.4926)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [32800/50000]  eta: 0:01:11  loss: 1.1209 (1.0095)  acc1: 100.0000 (75.8940)  acc5: 100.0000 (92.4758)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [32900/50000]  eta: 0:01:11  loss: 0.7599 (1.0134)  acc1: 0.0000 (75.7940)  acc5: 100.0000 (92.4470)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [33000/50000]  eta: 0:01:10  loss: 0.0403 (1.0133)  acc1: 100.0000 (75.8007)  acc5: 100.0000 (92.4396)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [33100/50000]  eta: 0:01:10  loss: 0.0076 (1.0135)  acc1: 100.0000 (75.8104)  acc5: 100.0000 (92.4353)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [33200/50000]  eta: 0:01:09  loss: 0.9662 (1.0160)  acc1: 0.0000 (75.7537)  acc5: 100.0000 (92.4099)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [33300/50000]  eta: 0:01:09  loss: 0.3771 (1.0177)  acc1: 100.0000 (75.6884)  acc5: 100.0000 (92.4056)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [33400/50000]  eta: 0:01:09  loss: 1.1264 (1.0185)  acc1: 0.0000 (75.6654)  acc5: 100.0000 (92.3954)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [33500/50000]  eta: 0:01:08  loss: 0.0021 (1.0160)  acc1: 100.0000 (75.7231)  acc5: 100.0000 (92.4181)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [33600/50000]  eta: 0:01:08  loss: 0.0493 (1.0149)  acc1: 100.0000 (75.7269)  acc5: 100.0000 (92.4347)  time: 0.0036  data: 0.0002  max mem: 86
Test:  [33700/50000]  eta: 0:01:07  loss: 1.4782 (1.0162)  acc1: 0.0000 (75.7010)  acc5: 100.0000 (92.4275)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [33800/50000]  eta: 0:01:07  loss: 2.0012 (1.0179)  acc1: 0.0000 (75.6664)  acc5: 100.0000 (92.4056)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [33900/50000]  eta: 0:01:06  loss: 0.2956 (1.0205)  acc1: 100.0000 (75.6261)  acc5: 100.0000 (92.3719)  time: 0.0038  data: 0.0002  max mem: 86
Test:  [34000/50000]  eta: 0:01:06  loss: 0.0472 (1.0215)  acc1: 100.0000 (75.6272)  acc5: 100.0000 (92.3502)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [34100/50000]  eta: 0:01:06  loss: 1.8225 (1.0236)  acc1: 0.0000 (75.5755)  acc5: 100.0000 (92.3316)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [34200/50000]  eta: 0:01:05  loss: 0.0572 (1.0243)  acc1: 100.0000 (75.5709)  acc5: 100.0000 (92.3277)  time: 0.0037  data: 0.0002  max mem: 86
Test:  [34300/50000]  eta: 0:01:05  loss: 0.0000 (1.0229)  acc1: 100.0000 (75.6100)  acc5: 100.0000 (92.3268)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [34400/50000]  eta: 0:01:04  loss: 0.0172 (1.0238)  acc1: 100.0000 (75.5908)  acc5: 100.0000 (92.3142)  time: 0.0049  data: 0.0002  max mem: 86
Test:  [34500/50000]  eta: 0:01:04  loss: 2.5449 (1.0254)  acc1: 0.0000 (75.5572)  acc5: 100.0000 (92.2988)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [34600/50000]  eta: 0:01:03  loss: 0.1552 (1.0262)  acc1: 100.0000 (75.5556)  acc5: 100.0000 (92.2835)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [34700/50000]  eta: 0:01:03  loss: 0.4390 (1.0281)  acc1: 100.0000 (75.4935)  acc5: 100.0000 (92.2596)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [34800/50000]  eta: 0:01:03  loss: 0.0076 (1.0276)  acc1: 100.0000 (75.5151)  acc5: 100.0000 (92.2588)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [34900/50000]  eta: 0:01:02  loss: 0.7986 (1.0291)  acc1: 100.0000 (75.4792)  acc5: 100.0000 (92.2495)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [35000/50000]  eta: 0:01:02  loss: 0.0039 (1.0286)  acc1: 100.0000 (75.4921)  acc5: 100.0000 (92.2545)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [35100/50000]  eta: 0:01:01  loss: 0.0001 (1.0286)  acc1: 100.0000 (75.5021)  acc5: 100.0000 (92.2538)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [35200/50000]  eta: 0:01:01  loss: 0.0196 (1.0284)  acc1: 100.0000 (75.4922)  acc5: 100.0000 (92.2587)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [35300/50000]  eta: 0:01:01  loss: 0.8688 (1.0297)  acc1: 0.0000 (75.4766)  acc5: 100.0000 (92.2608)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [35400/50000]  eta: 0:01:00  loss: 0.0061 (1.0310)  acc1: 100.0000 (75.4668)  acc5: 100.0000 (92.2432)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [35500/50000]  eta: 0:01:00  loss: 0.3687 (1.0314)  acc1: 100.0000 (75.4373)  acc5: 100.0000 (92.2509)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [35600/50000]  eta: 0:00:59  loss: 0.0745 (1.0329)  acc1: 100.0000 (75.3996)  acc5: 100.0000 (92.2334)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [35700/50000]  eta: 0:00:59  loss: 0.0009 (1.0327)  acc1: 100.0000 (75.4153)  acc5: 100.0000 (92.2271)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [35800/50000]  eta: 0:00:58  loss: 0.0018 (1.0322)  acc1: 100.0000 (75.4309)  acc5: 100.0000 (92.2293)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [35900/50000]  eta: 0:00:58  loss: 0.3446 (1.0322)  acc1: 100.0000 (75.4352)  acc5: 100.0000 (92.2258)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [36000/50000]  eta: 0:00:58  loss: 0.0002 (1.0324)  acc1: 100.0000 (75.4312)  acc5: 100.0000 (92.2252)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [36100/50000]  eta: 0:00:57  loss: 0.0874 (1.0323)  acc1: 100.0000 (75.4411)  acc5: 100.0000 (92.2246)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [36200/50000]  eta: 0:00:57  loss: 0.0008 (1.0320)  acc1: 100.0000 (75.4620)  acc5: 100.0000 (92.2157)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [36300/50000]  eta: 0:00:56  loss: 1.0876 (1.0326)  acc1: 0.0000 (75.4332)  acc5: 100.0000 (92.2068)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [36400/50000]  eta: 0:00:56  loss: 0.0012 (1.0310)  acc1: 100.0000 (75.4677)  acc5: 100.0000 (92.2172)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [36500/50000]  eta: 0:00:56  loss: 0.1963 (1.0367)  acc1: 100.0000 (75.3925)  acc5: 100.0000 (92.1372)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [36600/50000]  eta: 0:00:55  loss: 0.8977 (1.0400)  acc1: 0.0000 (75.3367)  acc5: 100.0000 (92.1013)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [36700/50000]  eta: 0:00:55  loss: 1.2821 (1.0421)  acc1: 100.0000 (75.3031)  acc5: 100.0000 (92.0765)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [36800/50000]  eta: 0:00:54  loss: 0.3187 (1.0422)  acc1: 100.0000 (75.2860)  acc5: 100.0000 (92.0790)  time: 0.0050  data: 0.0002  max mem: 86
Test:  [36900/50000]  eta: 0:00:54  loss: 0.5414 (1.0421)  acc1: 100.0000 (75.2852)  acc5: 100.0000 (92.0761)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [37000/50000]  eta: 0:00:54  loss: 0.0000 (1.0410)  acc1: 100.0000 (75.3142)  acc5: 100.0000 (92.0759)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [37100/50000]  eta: 0:00:53  loss: 0.4119 (1.0430)  acc1: 100.0000 (75.2594)  acc5: 100.0000 (92.0514)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [37200/50000]  eta: 0:00:53  loss: 0.5268 (1.0443)  acc1: 100.0000 (75.2292)  acc5: 100.0000 (92.0352)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [37300/50000]  eta: 0:00:52  loss: 0.0056 (1.0465)  acc1: 100.0000 (75.1588)  acc5: 100.0000 (92.0243)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [37400/50000]  eta: 0:00:52  loss: 1.4897 (1.0469)  acc1: 0.0000 (75.1611)  acc5: 100.0000 (92.0029)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [37500/50000]  eta: 0:00:52  loss: 0.0313 (1.0487)  acc1: 100.0000 (75.1100)  acc5: 100.0000 (91.9815)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [37600/50000]  eta: 0:00:51  loss: 0.3074 (1.0492)  acc1: 100.0000 (75.0911)  acc5: 100.0000 (91.9869)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [37700/50000]  eta: 0:00:51  loss: 0.0172 (1.0496)  acc1: 100.0000 (75.0882)  acc5: 100.0000 (91.9790)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [37800/50000]  eta: 0:00:50  loss: 0.0022 (1.0492)  acc1: 100.0000 (75.0985)  acc5: 100.0000 (91.9817)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [37900/50000]  eta: 0:00:50  loss: 0.0170 (1.0489)  acc1: 100.0000 (75.1036)  acc5: 100.0000 (91.9765)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [38000/50000]  eta: 0:00:49  loss: 0.0966 (1.0499)  acc1: 100.0000 (75.0954)  acc5: 100.0000 (91.9502)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [38100/50000]  eta: 0:00:49  loss: 0.0094 (1.0497)  acc1: 100.0000 (75.0978)  acc5: 100.0000 (91.9556)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [38200/50000]  eta: 0:00:49  loss: 0.0218 (1.0517)  acc1: 100.0000 (75.0792)  acc5: 100.0000 (91.9191)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [38300/50000]  eta: 0:00:48  loss: 0.0913 (1.0534)  acc1: 100.0000 (75.0503)  acc5: 100.0000 (91.9010)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [38400/50000]  eta: 0:00:48  loss: 3.0212 (1.0541)  acc1: 0.0000 (75.0475)  acc5: 100.0000 (91.8830)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [38500/50000]  eta: 0:00:47  loss: 0.0590 (1.0545)  acc1: 100.0000 (75.0500)  acc5: 100.0000 (91.8677)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [38600/50000]  eta: 0:00:47  loss: 0.0100 (1.0544)  acc1: 100.0000 (75.0706)  acc5: 100.0000 (91.8681)  time: 0.0043  data: 0.0001  max mem: 86
Test:  [38700/50000]  eta: 0:00:47  loss: 0.4904 (1.0564)  acc1: 100.0000 (75.0239)  acc5: 100.0000 (91.8478)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [38800/50000]  eta: 0:00:46  loss: 0.4960 (1.0580)  acc1: 100.0000 (74.9852)  acc5: 100.0000 (91.8250)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [38900/50000]  eta: 0:00:46  loss: 0.0769 (1.0580)  acc1: 100.0000 (74.9852)  acc5: 100.0000 (91.8305)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [39000/50000]  eta: 0:00:45  loss: 0.0051 (1.0587)  acc1: 100.0000 (74.9904)  acc5: 100.0000 (91.8207)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [39100/50000]  eta: 0:00:45  loss: 0.0018 (1.0566)  acc1: 100.0000 (75.0313)  acc5: 100.0000 (91.8391)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [39200/50000]  eta: 0:00:45  loss: 0.0012 (1.0582)  acc1: 100.0000 (74.9802)  acc5: 100.0000 (91.8242)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [39300/50000]  eta: 0:00:44  loss: 0.1853 (1.0605)  acc1: 100.0000 (74.9396)  acc5: 100.0000 (91.7865)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [39400/50000]  eta: 0:00:44  loss: 0.6406 (1.0621)  acc1: 0.0000 (74.9042)  acc5: 100.0000 (91.7667)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [39500/50000]  eta: 0:00:43  loss: 0.1936 (1.0617)  acc1: 100.0000 (74.9095)  acc5: 100.0000 (91.7698)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [39600/50000]  eta: 0:00:43  loss: 0.0425 (1.0628)  acc1: 100.0000 (74.8946)  acc5: 100.0000 (91.7527)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [39700/50000]  eta: 0:00:42  loss: 0.0153 (1.0645)  acc1: 100.0000 (74.8747)  acc5: 100.0000 (91.7357)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [39800/50000]  eta: 0:00:42  loss: 0.0769 (1.0651)  acc1: 100.0000 (74.8675)  acc5: 100.0000 (91.7238)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [39900/50000]  eta: 0:00:42  loss: 0.0277 (1.0658)  acc1: 100.0000 (74.8528)  acc5: 100.0000 (91.7170)  time: 0.0051  data: 0.0002  max mem: 86
Test:  [40000/50000]  eta: 0:00:41  loss: 0.6600 (1.0687)  acc1: 100.0000 (74.8131)  acc5: 100.0000 (91.6777)  time: 0.0047  data: 0.0002  max mem: 86
Test:  [40100/50000]  eta: 0:00:41  loss: 0.0090 (1.0668)  acc1: 100.0000 (74.8560)  acc5: 100.0000 (91.6935)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [40200/50000]  eta: 0:00:40  loss: 0.0264 (1.0652)  acc1: 100.0000 (74.8887)  acc5: 100.0000 (91.7067)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [40300/50000]  eta: 0:00:40  loss: 0.0093 (1.0654)  acc1: 100.0000 (74.8815)  acc5: 100.0000 (91.7099)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [40400/50000]  eta: 0:00:40  loss: 0.0218 (1.0666)  acc1: 100.0000 (74.8744)  acc5: 100.0000 (91.6834)  time: 0.0085  data: 0.0045  max mem: 86
Test:  [40500/50000]  eta: 0:00:39  loss: 1.6256 (1.0685)  acc1: 0.0000 (74.8228)  acc5: 100.0000 (91.6644)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [40600/50000]  eta: 0:00:39  loss: 0.1739 (1.0713)  acc1: 100.0000 (74.7691)  acc5: 100.0000 (91.6381)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [40700/50000]  eta: 0:00:38  loss: 2.0720 (1.0730)  acc1: 0.0000 (74.7353)  acc5: 100.0000 (91.6145)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [40800/50000]  eta: 0:00:38  loss: 0.2095 (1.0723)  acc1: 100.0000 (74.7555)  acc5: 100.0000 (91.6277)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [40900/50000]  eta: 0:00:38  loss: 0.9667 (1.0716)  acc1: 100.0000 (74.7610)  acc5: 100.0000 (91.6359)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [41000/50000]  eta: 0:00:37  loss: 0.1690 (1.0745)  acc1: 100.0000 (74.7128)  acc5: 100.0000 (91.6051)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [41100/50000]  eta: 0:00:37  loss: 0.0553 (1.0729)  acc1: 100.0000 (74.7500)  acc5: 100.0000 (91.6182)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [41200/50000]  eta: 0:00:36  loss: 0.7887 (1.0736)  acc1: 100.0000 (74.7506)  acc5: 100.0000 (91.5973)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [41300/50000]  eta: 0:00:36  loss: 0.0577 (1.0742)  acc1: 100.0000 (74.7125)  acc5: 100.0000 (91.5958)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [41400/50000]  eta: 0:00:35  loss: 0.4766 (1.0766)  acc1: 100.0000 (74.6649)  acc5: 100.0000 (91.5751)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [41500/50000]  eta: 0:00:35  loss: 0.0224 (1.0772)  acc1: 100.0000 (74.6633)  acc5: 100.0000 (91.5616)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [41600/50000]  eta: 0:00:35  loss: 0.2120 (1.0775)  acc1: 100.0000 (74.6569)  acc5: 100.0000 (91.5579)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [41700/50000]  eta: 0:00:34  loss: 0.0137 (1.0766)  acc1: 100.0000 (74.6745)  acc5: 100.0000 (91.5661)  time: 0.0040  data: 0.0001  max mem: 86
Test:  [41800/50000]  eta: 0:00:34  loss: 0.0237 (1.0781)  acc1: 0.0000 (74.6322)  acc5: 100.0000 (91.5409)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [41900/50000]  eta: 0:00:33  loss: 2.3601 (1.0831)  acc1: 0.0000 (74.5113)  acc5: 100.0000 (91.4775)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [42000/50000]  eta: 0:00:33  loss: 0.3241 (1.0853)  acc1: 100.0000 (74.4601)  acc5: 100.0000 (91.4597)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [42100/50000]  eta: 0:00:33  loss: 0.9063 (1.0870)  acc1: 100.0000 (74.4329)  acc5: 100.0000 (91.4349)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [42200/50000]  eta: 0:00:32  loss: 0.0135 (1.0873)  acc1: 100.0000 (74.4129)  acc5: 100.0000 (91.4291)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [42300/50000]  eta: 0:00:32  loss: 0.1794 (1.0892)  acc1: 100.0000 (74.3883)  acc5: 100.0000 (91.4045)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [42400/50000]  eta: 0:00:31  loss: 0.0941 (1.0898)  acc1: 100.0000 (74.3615)  acc5: 100.0000 (91.3988)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [42500/50000]  eta: 0:00:31  loss: 0.0792 (1.0902)  acc1: 100.0000 (74.3347)  acc5: 100.0000 (91.4073)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [42600/50000]  eta: 0:00:30  loss: 0.0957 (1.0900)  acc1: 100.0000 (74.3292)  acc5: 100.0000 (91.4133)  time: 0.0056  data: 0.0002  max mem: 86
Test:  [42700/50000]  eta: 0:00:30  loss: 0.0044 (1.0891)  acc1: 100.0000 (74.3472)  acc5: 100.0000 (91.4217)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [42800/50000]  eta: 0:00:30  loss: 0.0020 (1.0896)  acc1: 100.0000 (74.3487)  acc5: 100.0000 (91.4091)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [42900/50000]  eta: 0:00:29  loss: 0.2166 (1.0903)  acc1: 100.0000 (74.3293)  acc5: 100.0000 (91.4105)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43000/50000]  eta: 0:00:29  loss: 0.4386 (1.0907)  acc1: 100.0000 (74.3239)  acc5: 100.0000 (91.3909)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [43100/50000]  eta: 0:00:28  loss: 0.1530 (1.0923)  acc1: 100.0000 (74.2883)  acc5: 100.0000 (91.3668)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [43200/50000]  eta: 0:00:28  loss: 0.0065 (1.0916)  acc1: 100.0000 (74.3085)  acc5: 100.0000 (91.3706)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43300/50000]  eta: 0:00:27  loss: 0.5499 (1.0922)  acc1: 100.0000 (74.2685)  acc5: 100.0000 (91.3651)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [43400/50000]  eta: 0:00:27  loss: 0.3370 (1.0916)  acc1: 100.0000 (74.2748)  acc5: 100.0000 (91.3735)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43500/50000]  eta: 0:00:27  loss: 0.2863 (1.0939)  acc1: 100.0000 (74.2374)  acc5: 100.0000 (91.3519)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43600/50000]  eta: 0:00:26  loss: 0.2812 (1.0930)  acc1: 100.0000 (74.2391)  acc5: 100.0000 (91.3672)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43700/50000]  eta: 0:00:26  loss: 0.0013 (1.0925)  acc1: 100.0000 (74.2592)  acc5: 100.0000 (91.3663)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43800/50000]  eta: 0:00:25  loss: 0.1880 (1.0916)  acc1: 100.0000 (74.2791)  acc5: 100.0000 (91.3723)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [43900/50000]  eta: 0:00:25  loss: 0.0064 (1.0920)  acc1: 100.0000 (74.2375)  acc5: 100.0000 (91.3692)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [44000/50000]  eta: 0:00:25  loss: 0.0775 (1.0924)  acc1: 100.0000 (74.2165)  acc5: 100.0000 (91.3638)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [44100/50000]  eta: 0:00:24  loss: 0.1228 (1.0920)  acc1: 100.0000 (74.2341)  acc5: 100.0000 (91.3675)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [44200/50000]  eta: 0:00:24  loss: 1.8513 (1.0932)  acc1: 0.0000 (74.2110)  acc5: 100.0000 (91.3509)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [44300/50000]  eta: 0:00:23  loss: 3.8736 (1.0965)  acc1: 0.0000 (74.1541)  acc5: 100.0000 (91.3117)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [44400/50000]  eta: 0:00:23  loss: 0.4045 (1.0968)  acc1: 100.0000 (74.1650)  acc5: 100.0000 (91.3065)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [44500/50000]  eta: 0:00:22  loss: 0.4718 (1.0967)  acc1: 100.0000 (74.1579)  acc5: 100.0000 (91.3036)  time: 0.0051  data: 0.0002  max mem: 86
Test:  [44600/50000]  eta: 0:00:22  loss: 0.0673 (1.0961)  acc1: 100.0000 (74.1732)  acc5: 100.0000 (91.3051)  time: 0.0049  data: 0.0002  max mem: 86
Test:  [44700/50000]  eta: 0:00:22  loss: 1.4266 (1.0967)  acc1: 0.0000 (74.1370)  acc5: 100.0000 (91.3089)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [44800/50000]  eta: 0:00:21  loss: 0.0431 (1.0960)  acc1: 100.0000 (74.1479)  acc5: 100.0000 (91.3216)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [44900/50000]  eta: 0:00:21  loss: 0.0027 (1.0956)  acc1: 100.0000 (74.1632)  acc5: 100.0000 (91.3276)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [45000/50000]  eta: 0:00:20  loss: 2.0405 (1.0988)  acc1: 0.0000 (74.0917)  acc5: 100.0000 (91.3024)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [45100/50000]  eta: 0:00:20  loss: 0.0499 (1.0986)  acc1: 100.0000 (74.1026)  acc5: 100.0000 (91.2907)  time: 0.0046  data: 0.0002  max mem: 86
Test:  [45200/50000]  eta: 0:00:20  loss: 0.0301 (1.0984)  acc1: 100.0000 (74.1112)  acc5: 100.0000 (91.2944)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [45300/50000]  eta: 0:00:19  loss: 0.2390 (1.0996)  acc1: 100.0000 (74.0889)  acc5: 100.0000 (91.2629)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [45400/50000]  eta: 0:00:19  loss: 1.2460 (1.1034)  acc1: 0.0000 (74.0006)  acc5: 100.0000 (91.2227)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [45500/50000]  eta: 0:00:18  loss: 0.6810 (1.1048)  acc1: 100.0000 (73.9588)  acc5: 100.0000 (91.2266)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [45600/50000]  eta: 0:00:18  loss: 0.2011 (1.1071)  acc1: 100.0000 (73.9194)  acc5: 100.0000 (91.2041)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [45700/50000]  eta: 0:00:17  loss: 0.0228 (1.1068)  acc1: 100.0000 (73.9240)  acc5: 100.0000 (91.2059)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [45800/50000]  eta: 0:00:17  loss: 0.0003 (1.1058)  acc1: 100.0000 (73.9416)  acc5: 100.0000 (91.2185)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [45900/50000]  eta: 0:00:17  loss: 0.1972 (1.1048)  acc1: 100.0000 (73.9657)  acc5: 100.0000 (91.2289)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [46000/50000]  eta: 0:00:16  loss: 0.1110 (1.1049)  acc1: 100.0000 (73.9745)  acc5: 100.0000 (91.2176)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [46100/50000]  eta: 0:00:16  loss: 0.6403 (1.1047)  acc1: 100.0000 (73.9745)  acc5: 100.0000 (91.2236)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [46200/50000]  eta: 0:00:15  loss: 1.0495 (1.1057)  acc1: 100.0000 (73.9703)  acc5: 100.0000 (91.2145)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [46300/50000]  eta: 0:00:15  loss: 0.4804 (1.1053)  acc1: 100.0000 (73.9595)  acc5: 100.0000 (91.2183)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [46400/50000]  eta: 0:00:15  loss: 0.0027 (1.1038)  acc1: 100.0000 (73.9812)  acc5: 100.0000 (91.2351)  time: 0.0045  data: 0.0002  max mem: 86
Test:  [46500/50000]  eta: 0:00:14  loss: 0.0935 (1.1043)  acc1: 100.0000 (73.9575)  acc5: 100.0000 (91.2346)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [46600/50000]  eta: 0:00:14  loss: 0.0400 (1.1054)  acc1: 100.0000 (73.9297)  acc5: 100.0000 (91.2255)  time: 0.0039  data: 0.0002  max mem: 86
Test:  [46700/50000]  eta: 0:00:13  loss: 0.0019 (1.1049)  acc1: 100.0000 (73.9406)  acc5: 100.0000 (91.2207)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [46800/50000]  eta: 0:00:13  loss: 0.0435 (1.1051)  acc1: 100.0000 (73.9429)  acc5: 100.0000 (91.2160)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [46900/50000]  eta: 0:00:12  loss: 0.0004 (1.1039)  acc1: 100.0000 (73.9707)  acc5: 100.0000 (91.2283)  time: 0.0064  data: 0.0026  max mem: 86
Test:  [47000/50000]  eta: 0:00:12  loss: 0.0368 (1.1030)  acc1: 100.0000 (73.9771)  acc5: 100.0000 (91.2470)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [47100/50000]  eta: 0:00:12  loss: 0.0096 (1.1024)  acc1: 100.0000 (73.9814)  acc5: 100.0000 (91.2550)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [47200/50000]  eta: 0:00:11  loss: 0.1077 (1.1020)  acc1: 100.0000 (73.9772)  acc5: 100.0000 (91.2608)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [47300/50000]  eta: 0:00:11  loss: 0.0041 (1.1010)  acc1: 100.0000 (73.9984)  acc5: 100.0000 (91.2729)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [47400/50000]  eta: 0:00:10  loss: 0.6002 (1.1012)  acc1: 100.0000 (73.9816)  acc5: 100.0000 (91.2871)  time: 0.0040  data: 0.0002  max mem: 86
Test:  [47500/50000]  eta: 0:00:10  loss: 0.0593 (1.1010)  acc1: 100.0000 (73.9816)  acc5: 100.0000 (91.2907)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [47600/50000]  eta: 0:00:10  loss: 0.1147 (1.1010)  acc1: 100.0000 (73.9795)  acc5: 100.0000 (91.2985)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [47700/50000]  eta: 0:00:09  loss: 0.0013 (1.0998)  acc1: 100.0000 (74.0068)  acc5: 100.0000 (91.3042)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [47800/50000]  eta: 0:00:09  loss: 0.0000 (1.0988)  acc1: 100.0000 (74.0298)  acc5: 100.0000 (91.3140)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [47900/50000]  eta: 0:00:08  loss: 0.0004 (1.0977)  acc1: 100.0000 (74.0590)  acc5: 100.0000 (91.3259)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48000/50000]  eta: 0:00:08  loss: 0.0048 (1.0966)  acc1: 100.0000 (74.0818)  acc5: 100.0000 (91.3335)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48100/50000]  eta: 0:00:07  loss: 1.0288 (1.0997)  acc1: 100.0000 (74.0276)  acc5: 100.0000 (91.2996)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48200/50000]  eta: 0:00:07  loss: 0.0181 (1.0999)  acc1: 100.0000 (74.0296)  acc5: 100.0000 (91.2927)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48300/50000]  eta: 0:00:07  loss: 0.0095 (1.0998)  acc1: 100.0000 (74.0399)  acc5: 100.0000 (91.2921)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [48400/50000]  eta: 0:00:06  loss: 0.1439 (1.1010)  acc1: 100.0000 (74.0171)  acc5: 100.0000 (91.2874)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48500/50000]  eta: 0:00:06  loss: 2.2339 (1.1049)  acc1: 0.0000 (73.9449)  acc5: 100.0000 (91.2435)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [48600/50000]  eta: 0:00:05  loss: 0.0188 (1.1055)  acc1: 100.0000 (73.9244)  acc5: 100.0000 (91.2409)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48700/50000]  eta: 0:00:05  loss: 0.1100 (1.1054)  acc1: 100.0000 (73.9163)  acc5: 100.0000 (91.2527)  time: 0.0041  data: 0.0002  max mem: 86
Test:  [48800/50000]  eta: 0:00:05  loss: 1.7498 (1.1053)  acc1: 0.0000 (73.9206)  acc5: 100.0000 (91.2584)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [48900/50000]  eta: 0:00:04  loss: 0.3690 (1.1059)  acc1: 100.0000 (73.8983)  acc5: 100.0000 (91.2660)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [49000/50000]  eta: 0:00:04  loss: 0.1133 (1.1072)  acc1: 100.0000 (73.8699)  acc5: 100.0000 (91.2573)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [49100/50000]  eta: 0:00:03  loss: 0.1942 (1.1067)  acc1: 100.0000 (73.8906)  acc5: 100.0000 (91.2609)  time: 0.0046  data: 0.0003  max mem: 86
Test:  [49200/50000]  eta: 0:00:03  loss: 0.0112 (1.1064)  acc1: 100.0000 (73.9030)  acc5: 100.0000 (91.2624)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [49300/50000]  eta: 0:00:02  loss: 0.0015 (1.1046)  acc1: 100.0000 (73.9478)  acc5: 100.0000 (91.2760)  time: 0.0042  data: 0.0001  max mem: 86
Test:  [49400/50000]  eta: 0:00:02  loss: 0.6341 (1.1039)  acc1: 0.0000 (73.9459)  acc5: 100.0000 (91.2897)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [49500/50000]  eta: 0:00:02  loss: 0.0015 (1.1020)  acc1: 100.0000 (73.9884)  acc5: 100.0000 (91.3052)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [49600/50000]  eta: 0:00:01  loss: 0.0005 (1.1002)  acc1: 100.0000 (74.0287)  acc5: 100.0000 (91.3207)  time: 0.0044  data: 0.0002  max mem: 86
Test:  [49700/50000]  eta: 0:00:01  loss: 0.0000 (1.0989)  acc1: 100.0000 (74.0629)  acc5: 100.0000 (91.3342)  time: 0.0043  data: 0.0002  max mem: 86
Test:  [49800/50000]  eta: 0:00:00  loss: 0.0000 (1.0973)  acc1: 100.0000 (74.1049)  acc5: 100.0000 (91.3496)  time: 0.0042  data: 0.0002  max mem: 86
Test:  [49900/50000]  eta: 0:00:00  loss: 0.5711 (1.0966)  acc1: 100.0000 (74.1188)  acc5: 100.0000 (91.3589)  time: 0.0043  data: 0.0002  max mem: 86
Test: Total time: 0:03:30
 * Acc@1 74.054 Acc@5 91.340
```
## 应用场景
### 算法类别
图像分类

### 热点行业
制造,能源,交通,网安
## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/mobilenet_v3_tvm

## 参考资料

https://github.com/open-mmlab/mmpretrain

