# TVM 
## 模型介绍
```
   mobilenet_v2是mobilenet系列中的一个经典模型，mobilenet_v2适用于各种图像分类任务。本示例为使用TVM对训练
好的mobilenet_v2 onnx格式的模型文件，进行推理调优及部署的流程。
```
## 模型结构
```
    mobilenet_v2
```
## 模型文件
  模型文件下载地址： 
```
    "https://github.com/onnx/models/blob/main/vision/classification/mobilenet/model/mobilenetv2-7.onnx"
```
## 数据集
  python 推理及调优代码使用的图片数据为：
```
    "https://s3.amazonaws.com/model-server/inputs/kitten.jpg"
``` 
  标签数据为：
```
    "https://s3.amazonaws.com/onnx-model-zoo/synset.txt"
```
   C++部署代码使用数据为：
```
    "https://github.com/ultralytics/yolov5/releases/download/v1.0/coco128.zip"
```
## 推理、自动调优及部署
###  环境配置
  拉取镜像：
```
    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm-0.11_fp32_cpp_dtk22.10_py38_centos-7.6-latest
```

###  执行推理及调优
  下载模型文件后执行以下命令进行推理测试及调优测试：
```
    python tune_MobileNet_V2.py
```
    
    
### 单卡部署推理测试
  下载配置好镜像之后，cd /tvm-0.11-dev0/apps/ 进入该路径下，将代码下载放到该路径下，cd tvm_tune_resnet50-v2/ 进入该路径后，
执行以下命令：
```
    mkdir -p lib
    python prepare_test_libs.py
    sh run_example.sh
```
## 准确率数据
```
   max_num:12.6444
   max_iter:0x106028a4
   max_num_index:161
```
## TVM版本
```
    TVM-0.11
```   
    

## 源码仓库及问题反馈

   * https://developer.hpccube.com/codes/modelzoo/mobilenet_v2_tvm

## 参考

   * [https://tvm.apache.org/docs/how_to/tune_with_autoscheduler/tune_network_cuda.html#sphx-glr-how-to-tune-with-autoscheduler-tune-network-cuda-py]()

