# MobileNet_v2
## 论文
 `MobileNetV2: Inverted Residuals and Linear Bottlenecks`
 - https://arxiv.org/abs/1801.04381
  
## 模型介绍
```
mobilenet_v2是mobilenet系列中的一个经典模型，由Google在2018年提出。它是MobileNet系列中的第二个版本，主要用于移动设备和嵌入式设备等资源受限的环境中进行图像分类、目标检测等计算机视觉任务。
。本示例为使用TVM对训练好的mobilenet_v2 onnx格式的模型文件，进行推理调优及部署的流程。
```
## 模型结构
  MobieNet_v2 以图中所示的逆残差结构构建网络
  
 ![image.png](./image.png)

## 算法原理
```
MobileNetV2的网络结构主要由两部分组成：特征提取层和分类器。

特征提取层采用了一连串的瓶颈块来减小模型大小和计算量。每个瓶颈块包括逐点卷积、逐通道扩展和逐点卷积三个操作。其中逐点卷积用于降低特征图的通道数量，逐通道扩展则是为了增加特征图的深度，逐点卷积再次将通道数量转换为更小的值。MobileNetV2引入了倒残差结构，即先使用逐点卷积缩小通道数量，然后使用瓶颈块处理特征图，最后再使用逐点卷积扩展通道数量。最后一个重要的设计是Squeeze-and-Excitation (SE)模块，它可以用于进一步优化特征提取。SE模块通过使用全局平均池化来获取特征图中每个通道的全局信息，并使用两个全连接层来动态地调整每个通道的权重，以增强重要的特征并抑制无关的特征。

分类器采用全局平均池化和全连接层来进行图像分类。全局平均池化将特征图的每个通道降为一个值，然后将这些值传递给全连接层进行分类。这种方法不仅可以减少参数数量，还可以防止过拟合。
```


## 环境配置
### Docker（方法一）

拉取镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm-0.11_fp32_cpp_dtk22.10_py38_centos-7.6-latest
```
创建并启动容器
```
docker run --shm-size 16g --network=host --name=mobilenet_v2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/mobilenet_v2_tvm:/home/mobilenet_v2_tvm -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集
python 推理及调优代码使用的图片数据为：
```
   "https://s3.amazonaws.com/model-server/inputs/kitten.jpg"
``` 
标签数据为：
```
   "https://s3.amazonaws.com/onnx-model-zoo/synset.txt"
```
  C++部署代码使用数据为：
```
   "https://github.com/ultralytics/yolov5/releases/download/v1.0/coco128.zip"
```
##  推理

模型文件下载地址： 
```
  "https://github.com/onnx/models/blob/main/vision/classification/mobilenet/model/mobilenetv2-7.onnx"
```
下载模型文件后执行以下命令进行推理测试及调优测试：
```
    export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
    python tune_MobileNet_V2.py
```
    
    
### 单卡部署推理测试
下载配置好镜像之后，cd /tvm-0.11-dev0/apps/ 进入该路径下，将代码下载放到该路径下，cd tvm_tune_resnet50-v2/ 进入该路径后，
执行以下命令：
```
    mkdir -p lib
    export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
    python prepare_test_libs.py
    sh run_example.sh
```
## 精度
```
   max_num:12.6444
   max_iter:0x106028a4
   max_num_index:161
```
## results

## 应用场景

### 算法类别

图像分类

### 热点应用行业

制造,政府,医疗,科研
    

## 源码仓库及问题反馈

   * https://developer.hpccube.com/codes/modelzoo/mobilenet_v2_tvm

## 参考资料

   * [https://tvm.apache.org/docs/how_to/tune_with_autoscheduler/tune_network_cuda.html#sphx-glr-how-to-tune-with-autoscheduler-tune-network-cuda-py]()

