# mobilenet_prune
## 论文
* EfficientNet https://arxiv.org/pdf/1905.11946.pdf 
* mobilenetv2 https://arxiv.org/pdf/1801.04381.pdf 
* mobilenetv3 https://arxiv.org/pdf/1905.02244.pdf 
## 模型结构
mobilenetv2:

![image](https://developer.hpccube.com/codes/modelzoo/mobilenet_prune/-/raw/main/mobilenetv2.png)

详细模型结构见官方论文：
* EfficientNet https://arxiv.org/pdf/1905.11946.pdf 
* mobilenetv2 https://arxiv.org/pdf/1801.04381.pdf 
* mobilenetv3 https://arxiv.org/pdf/1905.02244.pdf 
## 算法原理
mobilenetv2:

具有线性瓶颈的反转残差(inverted residual )：该模块将低维压缩表示作为输入，首先将其扩展为高维度并使用轻量级沿深度卷积(depthwiseconvolution)进行滤波。随后通过线性卷积将特征投射回低维表示。中间层使用轻量级的沿深度卷积来对特征进行滤波作为非线性的来源。
![image](https://developer.hpccube.com/codes/modelzoo/mobilenet_prune/-/raw/main/mobilenetV2.png)

## 数据集
`CIFAR-10`
- 数据集快速下载中心:
  - [SCNet AIDatasets](http://113.200.138.88:18080/aidatasets)
- 数据集快速通道下载地址：
  - [数据集快速下载地址](http://113.200.138.88:18080/aidatasets/project-dependency/cifar)
- 官方下载通道
  - [https://www.cs.toronto.edu/~kriz/cifar.html](https://www.cs.toronto.edu/~kriz/cifar.html)

训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
├── cifar-10-batches-py
│   ├── batches.meta
│   ├── data_batch_1
│   ├── data_batch_2
│   ├── data_batch_3
│   ├── data_batch_4
│   ├── data_batch_5
│   ├── readme.html
│   └── test_batch
```
**tips：本模型也会自动下载数据集
## 环境配置
在[光源](https://sourcefind.cn/#/main-page)可拉取剪枝及微调的docker镜像，在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载torch安装包。mobilenet_prune推荐的镜像如下：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker run -d -t --privileged --device=/dev/kfd --device=/dev/dri/ -v /opt/hyhal:/opt/hyhal:ro --network=host --group-add video --name prune-test image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker exec -it prune-test bash
```
安装依赖
```
cd mobilenet_prune
pip3 install -r requirements.txt
```
## 训练
### 剪枝
efficientnet
```
python3 main.py --mode prune --model efficientnet --batch-size 128 --restore ./checkpoints/efficientnet.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv2
```
python3 main.py --mode prune --model mobilenetv2 --batch-size 128 --restore ./checkpoints/mobilenetv2.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv3
```
python3 main.py --mode prune --model mobilenetv3 --batch-size 128 --restore ./checkpoints/mobilenetv3.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
### 测试
efficientnet
```
python3 main.py --mode test --model efficientnet --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-efficientnet/cifar10_efficientnet_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv2
```
python3 main.py --mode test --model mobilenetv2 --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-mobilenetv2/cifar10_mobilenetv2_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv3
```
python3 main.py --mode test --model mobilenetv3 --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-mobilenetv3/cifar10_mobilenetv3_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
## result
![image](https://developer.hpccube.com/codes/modelzoo/mobilenet_prune/-/raw/main/result.png)
### 精度
method l1
| model | Base Acc | Pruned Acc | 
| :------: | :------: |:------: |
| efficientnet | 0.9300 | 0.9248 | 
| mobilenetv2 | 0.9222 | 0.9205 | 
| mobilenetv3 | 0.9034 | 0.8963 | 

method lamp
| model | Base Acc | Pruned Acc | 
| :------: | :------: |:------: |
| efficientnet | 0.9300 | 0.9256 | 
| mobilenetv2 | 0.9222 | 0.9225 | 
| mobilenetv3 | 0.9034 | 0.9044 | 

method group_norm
| model | Base Acc | Pruned Acc | 
| :------: | :------: |:------: |
| efficientnet | 0.9300 | 0.8977 | 
| mobilenetv2 | 0.9222 | 0.8953 | 
| mobilenetv3 | 0.9034 | 0.8852 | 

## 应用场景
### 算法类别
图像分类
### 热点应用行业
交通,金融,医疗,教育,家居
## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/mobilenet_prune
## 参考资料
* [Torch-Pruning](https://github.com/VainF/Torch-Pruning)

