# mobilenet_prune
## 论文
EfficientNet
https://arxiv.org/pdf/1905.11946.pdf
mobilenetv2
https://arxiv.org/pdf/1801.04381.pdf
mobilenetv3
https://arxiv.org/pdf/1905.02244.pdf
## 模型结构
mobilenetv2:

![image](https://developer.hpccube.com/codes/modelzoo/mobilenet_prune/-/raw/main/mobilenet.png)
模型结构见官方论文：
EfficientNet
https://arxiv.org/pdf/1905.11946.pdf
mobilenetv2
https://arxiv.org/pdf/1801.04381.pdf
mobilenetv3
https://arxiv.org/pdf/1905.02244.pdf
## 算法原理
CNN原理
## 数据集
torchvision.datasets.CIFAR10
## 环境配置
在[光源](https://sourcefind.cn/#/main-page)可拉取剪枝及微调的docker镜像，在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载torch安装包。mobilenet_prune推荐的镜像如下：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py37-latest
```
获取最新的dtk并安装依赖
```
cd /opt
wget http://10.0.50.210:8000/jenkins/rocm/23.04.1/centos7/DTK-23.04.1-rc4-centos7-x86_64.tar.gz
tar -zxvf DTK-23.04.1-rc4-centos7-x86_64.tar.gz
source /opt/dtk-23.04.1/env.sh
cd mobilenet_prune
pip3 install -r requirements.txt
```

## 剪枝
efficientnet
```
python3 main.py --mode prune --model efficientnet --batch-size 128 --restore ./checkpoints/efficientnet.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv2
```
python3 main.py --mode prune --model mobilenetv2 --batch-size 128 --restore ./checkpoints/mobilenetv2.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv3
```
python3 main.py --mode prune --model mobilenetv3 --batch-size 128 --restore ./checkpoints/mobilenetv3.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
## 测试
efficientnet
```
python3 main.py --mode test --model efficientnet --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-efficientnet/cifar10_efficientnet_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv2
```
python3 main.py --mode test --model mobilenetv2 --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-mobilenetv2/cifar10_mobilenetv2_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv3
```
python3 main.py --mode test --model mobilenetv3 --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-mobilenetv3/cifar10_mobilenetv3_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
## result
### 精度
method l1
| model | Base Acc | Pruned Acc | 
| :------: | :------: |:------: |
| efficientnet | 0.9300 | 0.9248 | 
| mobilenetv2 | 0.9222 | 0.9205 | 
| mobilenetv3 | 0.9034 | 0.8963 | 

method lamp
| model | Base Acc | Pruned Acc | 
| :------: | :------: |:------: |
| efficientnet | 0.9300 | 0.9256 | 
| mobilenetv2 | 0.9222 | 0.9225 | 
| mobilenetv3 | 0.9034 | 0.9044 | 

method group_norm
| model | Base Acc | Pruned Acc | 
| :------: | :------: |:------: |
| efficientnet | 0.9300 | 0.8977 | 
| mobilenetv2 | 0.9222 | 0.8953 | 
| mobilenetv3 | 0.9034 | 0.8852 | 

## 应用场景
### 算法类别
图像分类
### 热点应用行业
交通,金融,医疗,教育,家居
## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/mobilenet_prune
## 参考资料
* [Torch-Pruning](https://github.com/VainF/Torch-Pruning)

