# mobilenet_prune
## 模型介绍
基于torch-pruning对mobilenetv2、mobilenetv3、efficientnet进行剪枝。
## 模型结构
模型结构见官方论文：
EfficientNet
https://arxiv.org/pdf/1905.11946.pdf
mobilenetv2
https://arxiv.org/pdf/1801.04381.pdf
mobilenetv3
https://arxiv.org/pdf/1905.02244.pdf
## 数据集
torchvision.datasets.CIFAR10
## 剪枝及微调
### 环境配置
在[光源](https://www.sourcefind.cn/#/service-details)可拉取剪枝及微调的docker镜像，在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载torch安装包。mobilenet_prune推荐的镜像如下：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py37-latest
```
获取最新的dtk并安装依赖
```
cd /opt
wget http://10.0.50.210:8000/jenkins/rocm/23.04.1/centos7/DTK-23.04.1-rc4-centos7-x86_64.tar.gz
tar -zxvf DTK-23.04.1-rc4-centos7-x86_64.tar.gz
source /opt/dtk-23.04.1/env.sh
cd mobilenet_prune
pip3 install -r requirements.txt
```

### 剪枝
efficientnet
```
python3 main.py --mode prune --model efficientnet --batch-size 128 --restore ./checkpoints/efficientnet.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv2
```
python3 main.py --mode prune --model mobilenetv2 --batch-size 128 --restore ./checkpoints/mobilenetv2.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv3
```
python3 main.py --mode prune --model mobilenetv3 --batch-size 128 --restore ./checkpoints/mobilenetv3.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
### 测试
efficientnet
```
python3 main.py --mode test --model efficientnet --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-efficientnet/cifar10_efficientnet_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv2
```
python3 main.py --mode test --model mobilenetv2 --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-mobilenetv2/cifar10_mobilenetv2_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
mobilenetv3
```
python3 main.py --mode test --model mobilenetv3 --batch-size 128 --restore ./run/cifar10/prune/cifar10-global-l1-mobilenetv3/cifar10_mobilenetv3_l1.pt --dataset cifar10  --method l1 --speed-up 2.11 --global-pruning
```
## 性能和准确率数据
method l1
| model | Base Acc | Pruned Acc | infer time(ms)| pruned infer time(ms)| 
| :------: | :------: |:------: |:------: |:------: |
| efficientnet | 0.9300 | 0.9248 | 0.00023220938958693296 | 0.00023220938958693296 | 
| mobilenetv2 | 0.9222 | 0.9205 | 0.00018807348320260643 | 0.00018807348320260643 | 
| mobilenetv3 | 0.9034 | 0.8963 | 0.00019642823620233683 | 0.00019642823620233683 | 

method lamp
| model | Base Acc | Pruned Acc | infer time(ms)| pruned infer time(ms)| 
| :------: | :------: |:------: |:------: |:------: |
| efficientnet | 0.9300 | 0.9256 | 0.00023166481370572002 | 0.00023166481370572002 | 
| mobilenetv2 | 0.9222 | 0.9225 | 0.00021445175451226533 | 0.00021445175451226533 | 
| mobilenetv3 | 0.9034 | 0.9044 | 0.0001933462681947276 | 0.0001933462681947276 | 

method group_norm
| model | Base Acc | Pruned Acc | infer time(ms)| pruned infer time(ms)| 
| :------: | :------: |:------: |:------: |:------: |
| efficientnet | 0.9300 | 0.8977 | 0.00022248145109042525 | 0.00022248145109042525 | 
| mobilenetv2 | 0.9222 | 0.8953 | 0.00020749805739615112 | 0.00020749805739615112 | 
| mobilenetv3 | 0.9034 | 0.8852 | 0.00019550215750932694 | 0.00019550215750932694 | 

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/mobilenet_prune
## 参考
* [Torch-Pruning](https://github.com/VainF/Torch-Pruning)

