# Welcome to Projects of MMPose

Hey there! This is the place for you to contribute your awesome keypoint detection techniques to MMPose!

We know the unit tests in core package can be a bit intimidating, so we've made it easier and more efficient for you to implement your algorithms here.

And the **best part**?

- Projects in this folder are designed to be **easier to merge**!

- Projects in this folder are **NOT** strictly required for **writing unit tests**!

- We want to make it **as painless as possible** for you to contribute and make MMPose even greater.

If you're not sure where to start, check out our [example project](./example_project) to see how to add your algorithms easily. And if you have any questions, take a look at our [FAQ](./faq.md).

We also provide some documentation listed below to help you get started:

- [New Model Guide](https://mmpose.readthedocs.io/en/latest/guide_to_framework.html#step3-model)

  A guide to help you add new models to MMPose.

- [Contribution Guide](https://mmpose.readthedocs.io/en/latest/contribution_guide.html)

  A guide for new contributors on how to add their projects to MMPose.

- [Discussions](https://github.com/open-mmlab/mmpose/discussions)

  We encourage you to start a discussion and share your ideas!

## Project List

- **[:zap:RTMPose](./rtmpose)**: Real-Time Multi-Person Pose Estimation toolkit based on MMPose <sup>
  <a href="https://openxlab.org.cn/apps/detail/mmpose/RTMPose">
  <i>TRY IT NOW</i>
  </a>
  </sup>

  <div align="center">
  <img src="https://github.com/open-mmlab/mmpose/assets/13503330/5b637d76-41dd-4376-9a7f-854cd120799d" width=800 height=200 />
  </div><br/>

- **[🎳RTMO](./rtmo)**: Towards High-Performance One-Stage Real-Time Multi-Person Pose Estimation <sup>
  <a href="https://openxlab.org.cn/apps/detail/mmpose/RTMPose">
  <i>TRY IT NOW</i>
  </a>
  </sup>

  <div align="center">
  <img src="https://github.com/open-mmlab/mmpose/assets/26127467/61120930-09e5-4457-aa2c-b2f131d4f710" width=800  />
  </div><br/>

- **[♾️PoseAnything](./pose_anything/)**: A Graph-Based Approach for Category-Agnostic Pose Estimation

  <div align=center>
  <img src="https://github.com/open-mmlab/mmpose/assets/26127467/47acbd42-e812-4994-b287-b2a2b5ccbd80" width="800"/>
  </div><br/>

- **[:art:MMPose4AIGC](./mmpose4aigc)**: Guide AI image generation with MMPose

  <div align=center>
  <img src="https://user-images.githubusercontent.com/13503330/222403836-c65ba905-4bdd-4a44-834c-ff8d5959649d.png" width="800"/>
  </div><br/>

- **[:bulb:YOLOX-Pose](./yolox_pose)**: Enhancing YOLO for Multi Person Pose Estimation Using Object Keypoint Similarity Loss

  <div align=center>
  <img src="https://user-images.githubusercontent.com/26127467/226655503-3cee746e-6e42-40be-82ae-6e7cae2a4c7e.jpg" width="800" style="width: 800px; height: 200px; object-fit: cover"/>
  </div><br/>

- **[📖Awesome MMPose](./awesome-mmpose/)**: A list of Tutorials, Papers, Datasets related to MMPose

  <div align=center>
  <img src="https://user-images.githubusercontent.com/13503330/231416285-5467d313-0732-4ada-97e1-12be6ec69a28.png" width="800"/>
  </div><br/>

- **[💃Just-Dance](./just_dance)**: Enhancing Dance scoring system for comparing dance performances in videos. <sup>
  <a href="https://openxlab.org.cn/apps/detail/mmpose/just_dance-mmpose">
  <i>TRY IT NOW</i>
  </a>
  </sup>

  <div align=center>
  <img src="https://github.com/open-mmlab/mmpose/assets/26127467/a80978ad-c66d-4bac-bf56-1fa191716f1c" width="800" style="width: 800px; height: 200px; object-fit: cover"/>
  </div><br/>

- **What's next? Join the rank of <span style="color:blue"> *MMPose contributors* </span> by creating a new  project**!
