# RTMO 
本项目的步骤适用于mmpose中的RTMO算法，库中其它姿态估计算法的使用方式以此类推。
## 论文
`RTMO: Towards High-Performance One-Stage Real-Time Multi-Person Pose Estimation`
- https://arxiv.org/pdf/2312.07526.pdf

## 模型结构
为了提高关键点预测速度，无法选择计算量较大的模型，于是，作者选择了ResNet-50以及对GPU计算更为友好的CSPDarknet，同时去掉yolo系列经典模型结构中计算量最大的最大特征图的检测头。

<div align=center>
    <img src="./doc/bockbone.png"/>
</div>

## 算法原理
借鉴yolopose的基本思想，先利用onestage方法生成BBox，但此时作者提出了改进思想，不在生成BBox的同时生成Kpt，而是对BBox所在的姿态特征图进行特征变换和维度转换，利用全连接层来控制关键点的个数，对BBox的坐标进行xy分离、位置编码和维度转换操作，再将两者相乘得到特征融合的结果，对此结果的关键点进行有监督训练，经过论文中提出的损失监督，便获得更好的关键点预测结果。

<div align=center>
    <img src="./doc/rtmo.png"/>
</div>

## 环境配置
```
mv mmpose-rtmo_pytorch mmpose # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换
docker run -it --shm-size=32G -v $PWD/mmpose:/home/mmpose -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name rtmo <your IMAGE ID> bash
cd mmpose
pip install -r requirements.txt
pip install -v -e . # 安装mmpose=1.3.0
# 训练时会自动下载目标检测权重到项目默认指定位置：yolox_s_8x8_300e_coco_20211121_095711-4592a793.pth
```
### Dockerfile（方法二）
```
cd mmpose/docker
docker build --no-cache -t rtmo:latest .
docker run --shm-size=32G --name rtmo -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../mmpose:/home/mmpose -it rtmo:latest bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
cd mmpose
pip install -v -e . # 安装mmpose=1.3.0
# 训练时会自动下载目标检测权重到项目默认指定位置：yolox_s_8x8_300e_coco_20211121_095711-4592a793.pth
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.1
python:python3.10
torch:2.1.0
torchvision:0.16.0
apex:1.1.0
mmcv:2.0.1
# cd mmpose & pip install -v -e . # 安装mmpose=1.3.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
pip install -r requirements.txt
```
## 数据集
`COCO2017`
[原链接](http://cocodataset.org/#download) | [SCNet](http://113.200.138.88:18080/aidatasets/coco2017)高速下载通道。

项目中已提供用于试验训练的迷你数据集，[`coco.zip`](./data/coco.zip)解压即可使用，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
data/coco/
├── annotations/
│   ├── person_keypoints_train2017.json
│   ├── person_keypoints_val2017.json
│   └── ...
├── train2017/
│   ├── xxx.png
│   ├── xxx.png
│   └── ...
├── val2017/
│   ├── xxx.png
│   ├── xxx.png
│   └── ...
```
`更多资料可参考源项目的README_origin.md`
## 训练
### 单机多卡
```
cd mmpose
sh train.sh
# if bug: Timeout while waiting for Database: /root/.cache/miopen/2.15.3.0b020ba8a/gfx92678.ukdb. rc=00000005
# then: rm -rf /root/.cache/miopen/2.15.3.0b020ba8a/*
```
## 推理
```
python demo/inferencer_demo.py tests/data/coco/ --pose2d configs/body_2d_keypoint/rtmo/coco/rtmo-s_8xb32-600e_coco-640x640.py --pose2d-weights checkpoint/epoch_xxx.pth --vis-out-dir vis_results # 采用coco2017自己训练的权重推理
# 官方默认权重推理：python demo/inferencer_demo.py tests/data/coco/000000000785.jpg --pose2d rtmo --vis-out-dir vis_results
```

## result
输入人物图片：

<div align=center>
    <img src="./doc/000000197388.png"/>
</div>

识别出人物关键点：

<div align=center>
    <img src="./doc/000000197388_result.png"/>
</div>

### 精度
测试数据："tests/data/coco/"，测试算法为RTMO-s，其bockbone为CSPDarknet，其中V100的精度为论文中作者公开结果，推理框架：pytorch。

|  device   |  AP  | AP50 | AP75 | APM  | APL  |  AR  |
|:---------:|:----:|:----:|:----:|:----:|:----:|:----:|
| DCU Z100SM | 67.8 | 87.8 | 73.9 | 61.6 | 77.1 | 71.6 |
| GPU V100  | 66.9 | 88.8 | 73.6 | 61.1 | 75.7 | 70.9 |

## 应用场景
### 算法类别
`姿态估计`
### 热点应用行业
`制造,广媒,能源,医疗,家居,教育`
## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/mmpose-rtmo_pytorch.git
## 参考资料
- https://github.com/open-mmlab/mmpose.git
- https://zhuanlan.zhihu.com/p/649761492
