#  RetinaNet
## 模型介绍
RetinaNet是一种基于特征金字塔网络（Feature Pyramid Network）和Focal Loss损失函数的目标检测模型，由Facebook AI Research团队在2018年提出。RetinaNet旨在解决传统目标检测算法（如Faster R-CNN）在检测小目标时表现不佳的问题。

与传统的目标检测算法相比，RetinaNet具有更高的检测精度和更快的检测速度。它对小目标的检测表现尤为优秀，在各种视觉任务中都取得了很好的效果，例如物体检测、行人重识别等。

## 模型结构
RetinaNet的网络结构主要分为两个部分：特征提取网络和检测头。

1. 特征提取网络：RetinaNet采用了ResNet作为特征提取网络，通过不同深度的ResNet模块对输入图像进行特征提取，得到一系列的特征金字塔图。这些特征金字塔图代表了不同尺度的物体信息，可以用于检测不同大小的目标。
2. 检测头：RetinaNet的检测头由两个分支组成，一个分支用于预测目标的置信度，另一个分支用于预测目标的边界框。每个分支都由一系列卷积层和全连接层组成，最终输出一个特定数量的预测值。置信度分支使用Focal Loss损失函数来处理正负样本不均衡问题，边界框分支使用Smooth L1 Loss损失函数来计算边界框的误差。

在检测过程中，RetinaNet首先在特征金字塔图上进行目标检测，然后在检测结果中使用非极大值抑制（NMS）来消除重叠的边界框，并保留置信度最高的边界框。

## 目标精度

 34.0% mAP

## MLPerf代码参考版本

版本：v2.1

原始代码位置：https://github.com/mlcommons/training_results_v2.1/tree/master/NVIDIA/benchmarks/bert/implementations/pytorch

## 数据集
模型训练的数据集来自训练数据：Open Images，该数据一个大规模的图像数据集，由Google在2016年发布。该数据集包含了超过900万张标注图像，其中每张图像都包含了多个物体的边界框和类别标签，可用于各种计算机视觉任务，例如物体检测、物体识别、场景理解等。

### Download dataset

该数据集的来源为[OpenImages-v6](https://storage.googleapis.com/openimages/web/index.html)，按下述进行数据下载，数据大小约为352G；

    cd ./scripts
    pip3  install fiftyone
    ./download_openimages_mlperf.sh -d <DATAPATH>
### Download the pretrained backbone

该网络采用的预训练模型为来自ImageNet的ResNeXt50_32x4d，可通过下述进行获取；

    ./download_backbone.sh

## 训练

### 测试规模

单机8卡进行性能&&精度测试

### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:mlperf_retinanet_mpirun

python依赖安装：

    pip3 install -r requirement.txt
    python3 setup.py install
    #注：运行该模式需要特定版本的apex，相应whl包在本目录中提供
    pip3 install apex-0.1-cp37-cp37m-linux_x86_64.whl
    cd ./cocoapi-0.7.0/PythonAPI; python3 setup.py install

### 训练
训练命令：

    nohup bash sbatch.sh >& bs16_epoch6.log &
    #输出结果见bs16_epoch6.log
    #注：可通过修改dcu.sh中DATASET_DIR参数按需修改输入数据的位置

## 测试结果
采用上述输入数据，加速卡采用Z100L*8，可最终达到官方收敛要求；

## 历史版本
* https://developer.hpccube.com/codes/modelzoo/mlperf_retinanet
## 参考
* https://mlcommons.org/en/
* https://github.com/mlcommons
