# ResNet50

## 论文

Deep Residual Learning for Image Recognition

* https://arxiv.org/abs/1512.03385

## 模型结构

ResNet50是一种用于图像识别的深度神经网络模型，该模型由一系列卷积层、池化层、全局平均池化层和全连接层组成。该模型的特殊之处在于它包含多个残差块，每个残差块由多个卷积层和跳跃连接组成。

![img](ResNet50.png)

## 算法原理

在ResNet50中，输入图像通过一系列卷积层和池化层进行特征提取，然后通过多个残差块进行深度特征学习。每个残差块包含多个卷积层和跳跃连接，跳跃连接允许信息在残差块内和残差块之间的传递，从而解决了深度神经网络中出现的梯度消失问题。最后，全局平均池化层将特征映射到一个固定长度的向量，该向量再通过全连接层进行分类或回归等任务。

![img](Residual_Block.png)

## 环境配置

**Docker (方法一)**

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:mlperf-resnet50-mpirun-latest
    # <Image ID>用上面拉取docker镜像的ID替换
    # <Host Path>主机端路径
    # <Container Path>容器映射路径
    docker run -it --name mlperf_bert --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash

**Dockerfile (方法二)**

    docker build --no-cache -t mlperf_resnet50:latest .
    docker run -it --name mlperf_resnet50 --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
    # <Image ID>用上面拉取docker镜像的ID替换
    # <Host Path>主机端路径
    # <Container Path>容器映射路径

镜像版本依赖：

* DTK驱动：dtk22.10.1
* python: python3.8.2

注明：目前本镜像仅支持Z100/Z100L系列卡

测试目录:

```
/root/resnet50
```

## 数据集

需使用ImageNET数据集，下载地址：http://image-net.org/challenges/LSVRC/2012/2012-downloads (require an account)

具体处理方式可详见：https://github.com/mlcommons/training/tree/master/image_classification

处理好的预训练模型结果如下，镜像中已经给出，无需额外下载

    mlperf_resnet50
    ├── checkpoint
    ├── ckpt-0.data-00000-of-00001
    ├── ckpt-0.index
    ├── ckpt-500.data-00000-of-00001
    ├── ckpt-500.index

## 训练

### 单机多卡

单机8卡进行性能&&精度测试

```
bash 8dcu_multi.sh >& output.log &
```

## result

![result](result.png)

### 精度

采用上述输入数据，加速卡采用Z100L * 8，可最终达到官方收敛要求，即达到目标精度75.90% classification；

| 卡数 | 类型     | 进程数 | 达到精度              |
| ---- | -------- | ------ | --------------------- |
| 8    | 混合精度 | 8      | 75.90% classification |

## 应用场景

### 算法类别

`图像分类`

### 热点应用行业

`制造,政府,医疗,科研`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/mlperf_resnet50_tensorflow

## 参考资料

* https://mlcommons.org/en/
* https://github.com/mlcommons
* https://github.com/mlcommons/training/tree/master/image_classification/tensorflow2

