# ResNet50(Residual Network with 50-layer)

## 模型介绍

ResNet50是一种用于图像识别的深度神经网络模型。

## 模型结构

ResNet50网络模型由一系列卷积层、池化层、全局平均池化层和全连接层组成。该模型的特殊之处在于它包含多个残差块，每个残差块由多个卷积层和跳跃连接组成。

在ResNet50中，输入图像通过一系列卷积层和池化层进行特征提取，然后通过多个残差块进行深度特征学习。每个残差块包含多个卷积层和跳跃连接，跳跃连接允许信息在残差块内和残差块之间的传递，从而解决了深度神经网络中出现的梯度消失问题。最后，全局平均池化层将特征映射到一个固定长度的向量，该向量再通过全连接层进行分类或回归等任务。

## 目标精度

75.90% classification

## MLPerf代码参考版本

版本：mlperf_benchmark 

原始代码位置：https://github.com/mlcommons/training/tree/master/image_classification/tensorflow2

## 数据集

需使用ImageNET数据集，下载地址：http://image-net.org/challenges/LSVRC/2012/2012-downloads (require an account)

具体处理方式可详见：https://github.com/mlcommons/training/tree/master/image_classification

## 训练

### 环境配置

单机8卡进行性能&&精度测试

### 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：


    docker pull docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:mlperf-resnet50-mpirun-latest

python依赖安装：

    pip install -r requirement.txt

### 训练

训练命令：

    bash 8dcu_multi.sh >& output.log &

### 预训练模型

在本目录下我们提供了一个预训练模型如下：

    mlperf_resnet50
    ├── checkpoint
    ├── ckpt-0.data-00000-of-00001
    ├── ckpt-0.index
    ├── ckpt-500.data-00000-of-00001
    ├── ckpt-500.index

## 测试结果

采用上述输入数据，加速卡采用Z100L*8，可最终达到官方收敛要求；

## 历史版本

* https://developer.hpccube.com/codes/modelzoo/mlperf_resnet50

## 参考

* https://mlcommons.org/en/
* https://github.com/mlcommons
