#ifndef HIP_INCLUDE_HIP_PROFILE_ROCTX_H
#define HIP_INCLUDE_HIP_PROFILE_ROCTX_H

#include <stdint.h>

#define ROCTX_VERSION_MAJOR 1
#define ROCTX_VERSION_MINOR 0

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
////////////////////////////////////////////////////////////////////////////////
// Returning library version
uint32_t roctx_version_major();
uint32_t roctx_version_minor();

////////////////////////////////////////////////////////////////////////////////
// Returning the last error
const char *roctracer_error_string();

////////////////////////////////////////////////////////////////////////////////
// Markers annotating API

// A marker created by given ASCII massage
void roctxMarkA(const char *message);
#define roctxMark(message) roctxMarkA(message)

////////////////////////////////////////////////////////////////////////////////
// Ranges annotating API

// Returns the 0 based level of a nested range being started by given message associated to this range.
// A negative value is returned on the error.
int roctxRangePushA(const char *message);
#define roctxRangePush(message) roctxRangePushA(message)

// Marks the end of a nested range.
// A negative value is returned on the error.
int roctxRangePop();

// ROCTX range id type
typedef uint64_t roctx_range_id_t;

// Starts a process range
roctx_range_id_t roctxRangeStartA(const char *message);
#define roctxRangeStart(message) roctxRangeStartA(message)

// Stop a process range
void roctxRangeStop(roctx_range_id_t id);

#ifdef __cplusplus
} // extern "C" block
#endif // __cplusplus

#endif // HIP_INCLUDE_HIP_PROFILE_HIPTX_H
