
//! hip_vector_types.h : Defines the HIP vector types.

#ifndef HIP_INCLUDE_HIP_HIP_VECTOR_TYPES_H
#define HIP_INCLUDE_HIP_HIP_VECTOR_TYPES_H

#include <hip/hip_common.h>


#if (defined(__HIP_PLATFORM_HCC__) || defined(__HIP_PLATFORM_AMD__)) && !(defined(__HIP_PLATFORM_NVCC__) || defined(__HIP_PLATFORM_NVIDIA__))
#if __cplusplus
#include <hip/hsa_detail/hip_vector_types.hpp>
#else
#include <hip/hsa_detail/hip_vector_types.h>
#endif
#elif (defined(__HIP_PLATFORM_NVCC__) || defined(__HIP_PLATFORM_NVIDIA__)) && !(defined(__HIP_PLATFORM_HCC__) || defined(__HIP_PLATFORM_AMD__))
#include <vector_types.h>
#else
#error("Must define exactly one of __HIP_PLATFORM_HCC__ or __HIP_PLATFORM_NVCC__");
#endif

#endif
