
#ifndef HIP_INCLUDE_HIP_HSA_DETAIL_SURFACE_FUNCTIONS_H
#define HIP_INCLUDE_HIP_HSA_DETAIL_SURFACE_FUNCTIONS_H

#include <hip/hsa_detail/hip_surface_types.h>

#define __SURFACE_FUNCTIONS_DECL__ static inline __device__
template <class T>
__SURFACE_FUNCTIONS_DECL__ void surf2Dread(T* data, hipSurfaceObject_t surfObj, int x, int y,
                                           int boundaryMode = hipBoundaryModeZero) {
    hipArray* arrayPtr = (hipArray*)surfObj;
    size_t width = arrayPtr->width;
    size_t height = arrayPtr->height;
    int32_t xOffset = x / sizeof(T);
    T* dataPtr = (T*)arrayPtr->data;
    if ((xOffset > width) || (xOffset < 0) || (y > height) || (y < 0)) {
        if (boundaryMode == hipBoundaryModeZero) {
            *data = 0;
        }
    } else {
        *data = *(dataPtr + y * width + xOffset);
    }
}

template <class T>
__SURFACE_FUNCTIONS_DECL__ void surf2Dwrite(T data, hipSurfaceObject_t surfObj, int x, int y,
                                            int boundaryMode = hipBoundaryModeZero) {
    hipArray* arrayPtr = (hipArray*)surfObj;
    size_t width = arrayPtr->width;
    size_t height = arrayPtr->height;
    int32_t xOffset = x / sizeof(T);
    T* dataPtr = (T*)arrayPtr->data;
    if (!((xOffset > width) || (xOffset < 0) || (y > height) || (y < 0))) {
        *(dataPtr + y * width + xOffset) = data;
    }
}

#endif //HIP_INCLUDE_HIP_HSA_DETAIL_SURFACE_FUNCTIONS_H
