/**
 *  @file  hsa_detail/hip_vector_types.h
 *  @brief Defines vector types for c 
 */

#ifndef HIP_INCLUDE_HIP_HSA_DETAIL_HIP_VECTOR_TYPES_H
#define HIP_INCLUDE_HIP_HSA_DETAIL_HIP_VECTOR_TYPES_H


#include "hip/hsa_detail/host_defines.h"

#if !defined(__align__)
#define __align__(x) __attribute__((aligned(x)))
#endif

#if defined(__clang__) && defined(__HIP__)
struct  __host__ __device__ char1
{
    signed char x;
};

struct  __host__ __device__ uchar1
{
    unsigned char x;
};


struct  __host__ __device__ __align__(2) char2
{
    signed char x, y;
};

struct  __host__ __device__ __align__(2) uchar2
{
    unsigned char x, y;
};

struct  __host__ __device__ char3
{
    signed char x, y, z;
};

struct  __host__ __device__ uchar3
{
    unsigned char x, y, z;
};

struct  __host__ __device__ __align__(4) char4
{
    signed char x, y, z, w;
};

struct  __host__ __device__ __align__(4) uchar4
{
    unsigned char x, y, z, w;
};

struct  __host__ __device__ short1
{
    short x;
};

struct  __host__ __device__ ushort1
{
    unsigned short x;
};

struct  __host__ __device__ __align__(4) short2
{
    short x, y;
};

struct  __host__ __device__ __align__(4) ushort2
{
    unsigned short x, y;
};

struct  __host__ __device__ short3
{
    short x, y, z;
};

struct __host__ __device__ ushort3
{
    unsigned short x, y, z;
};

struct  __host__ __device__ __align__(8) short4 
{
   short x,y,z, w; 
};

struct  __host__ __device__ __align__(8) ushort4 
{
   unsigned short x,y,z, w; 
};

struct __host__ __device__ int1
{
    int x;
};

struct __host__ __device__ uint1
{
    unsigned int x;
};

struct __host__ __device__ int2
{
   int x,y; 
};

struct __host__ __device__ uint2
{
   unsigned int x,y; 
};

struct __host__ __device__ int3
{
    int x, y, z;
};

struct __host__ __device__ uint3
{
    unsigned int x, y, z;
};

struct __host__ __device__ __align__(16) int4
{
    int x, y, z, w;
};

struct __host__ __device__ __align__(16) uint4
{
    unsigned int x, y, z, w;
};

struct __host__ __device__ long1
{
    long int x;
};

struct __host__ __device__ ulong1
{
    unsigned long x;
};

struct __host__ __device__ __align__(2*sizeof(long int)) long2
{
    long int x, y;
};

struct __host__ __device__ __align__(2*sizeof(unsigned long int)) ulong2
{
    unsigned long int x, y;
};

struct __host__ __device__ long3
{
    long int x, y, z;
};

struct __host__ __device__ ulong3
{
    unsigned long int x, y, z;
};

struct __host__ __device__ __align__(16) long4
{
    long int x, y, z, w;
};

struct __host__ __device__ __align__(16) ulong4
{
    unsigned long int x, y, z, w;
};

struct __host__ __device__ float1
{
    float x;
};

struct __host__ __device__ float2
{
    float x,y;
};

struct __host__ __device__ float3
{
    float x, y, z;
};

struct __host__ __device__ __align__(16) float4
{
    float x, y, z, w;
};

struct __host__ __device__ longlong1
{
    long long int x;
};

struct __host__ __device__ ulonglong1
{
    unsigned long long int x;
};

struct __host__ __device__ __align__(16) longlong2
{
    long long int x, y;
};

struct __host__ __device__ __align__(16) ulonglong2
{
    unsigned long long int x, y;
};

struct __host__ __device__  longlong3
{
    long long int x, y, z;
};

struct __host__ __device__  ulonglong3
{
    unsigned long long int x, y, z;
};

struct __host__ __device__  __align__(16) longlong4
{
    long long int x, y, z ,w;
};

struct __host__ __device__ __align__(16) ulonglong4
{
    unsigned long long int x, y, z, w;
};

struct __host__ __device__  double1
{
    double x;
};

struct __host__ __device__  __align__(16) double2
{
    double x, y;
};

struct __host__ __device__  double3
{
    double x, y, z;
};

struct __host__ __device__  __align__(16) double4
{
    double x, y, z, w;
};

#endif //defined(__clang__) && defined(__HIP__)

/*******************************************************************************
*                                                                              *
*                                                                              *
*                                                                              *
*******************************************************************************/

#if defined(_MSC_VER)
#include <mmintrin.h>
#include <xmmintrin.h>
#include <emmintrin.h>
#include <immintrin.h>

typedef union { char data; } char1;
typedef union { char data[2]; } char2;
typedef union { char data[4]; } char4;
typedef union { char4 data; } char3;
typedef union { __m64 data; } char8;
typedef union { __m128i data; } char16;

typedef union { unsigned char data; } uchar1;
typedef union { unsigned char data[2]; } uchar2;
typedef union { unsigned char data[4]; } uchar4;
typedef union { uchar4 data; } uchar3;
typedef union { __m64 data; } uchar8;
typedef union { __m128i data; } uchar16;

typedef union { short data; } short1;
typedef union { short data[2]; } short2;
typedef union { __m64 data; } short4;
typedef union { short4 data; } short3;
typedef union { __m128i data; } short8;
typedef union { __m128i data[2]; } short16;

typedef union { unsigned short data; } ushort1;
typedef union { unsigned short data[2]; } ushort2;
typedef union { __m64 data; } ushort4;
typedef union { ushort4 data; } ushort3;
typedef union { __m128i data; } ushort8;
typedef union { __m128i data[2]; } ushort16;

typedef union { int data; } int1;
typedef union { __m64 data; } int2;
typedef union { __m128i data; } int4;
typedef union { int4 data; } int3;
typedef union { __m128i data[2]; } int8;
typedef union { __m128i data[4];} int16;

typedef union { unsigned int data; } uint1;
typedef union { __m64 data; } uint2;
typedef union { __m128i data; } uint4;
typedef union { uint4 data; } uint3;
typedef union { __m128i data[2]; } uint8;
typedef union { __m128i data[4]; } uint16;

#if !defined(_WIN64)
typedef union { int data; } long1;
typedef union { __m64 data; } long2;
typedef union { __m128i data; } long4;
typedef union { long4 data; } long3;
typedef union { __m128i data[2]; } long8;
typedef union { __m128i data[4]; } long16;

typedef union { unsigned int data; } ulong1;
typedef union { __m64 data; } ulong2;
typedef union { __m128i data; } ulong4;
typedef union { ulong4 data; } ulong3;
typedef union { __m128i data[2]; } ulong8;
typedef union { __m128i data[4]; } ulong16;
#else // defined(_WIN64)
typedef union { __m64 data; } long1;
typedef union { __m128i data; } long2;
typedef union { __m128i data[2]; } long4;
typedef union { long4 data; } long3;
typedef union { __m128i data[4]; } long8;
typedef union { __m128i data[8]; } long16;

typedef union { __m64 data; } ulong1;
typedef union { __m128i data; } ulong2;
typedef union { __m128i data[2]; } ulong4;
typedef union { ulong4 data; } ulong3;
typedef union { __m128i data[4]; } ulong8;
typedef union { __m128i data[8]; } ulong16;
#endif // defined(_WIN64)

typedef union { __m64 data; } longlong1;
typedef union { __m128i data; } longlong2;
typedef union { __m128i data[2]; } longlong4;
typedef union { longlong4 data; } longlong3;
typedef union { __m128i data[4]; } longlong8;
typedef union { __m128i data[8]; } longlong16;

typedef union { __m64 data; } ulonglong1;
typedef union { __m128i data; } ulonglong2;
typedef union { __m128i data[2]; } ulonglong4;
typedef union { ulonglong4 data; } ulonglong3;
typedef union { __m128i data[4]; } ulonglong8;
typedef union { __m128i data[8]; } ulonglong16;

typedef union { float data; } float1;
typedef union { __m64 data; } float2;
typedef union { __m128 data; } float4;
typedef union { float4 data; } float3;
typedef union { __m256 data; } float8;
typedef union { __m256 data[2]; } float16;

typedef union { double data; } double1;
typedef union { __m128d data; } double2;
typedef union { __m256d data; } double4;
typedef union { double4 data; } double3;
typedef union { __m256d data[2]; } double8;
typedef union { __m256d data[4]; } double16;

#else // !defined(_MSC_VER)

typedef union { char data; } char1;
typedef union { char data[2]; } char2;
typedef union { char data[4]; } char4;
typedef union { char data[8]; } char8;
typedef union { char data[16]; } char16;
typedef union { char4 data; } char3;

typedef union { unsigned char data; } uchar1;
typedef union { unsigned char data[2]; } uchar2;
typedef union { unsigned char data[4]; } uchar4;
typedef union { unsigned char data[8]; } uchar8;
typedef union { unsigned char data[16]; } uchar16;
typedef union { uchar4 data; } uchar3;

typedef union { short data; } short1;
typedef union { short data[2]; } short2;
typedef union { short data[4]; } short4;
typedef union { short data[8]; } short8;
typedef union { short data[16]; } short16;
typedef union { short4 data; } short3;

typedef union { unsigned short data; } ushort1;
typedef union { unsigned short data[2]; } ushort2;
typedef union { unsigned short data[4]; } ushort4;
typedef union { unsigned short data[8]; } ushort8;
typedef union { unsigned short data[16]; } ushort16;
typedef union { ushort4 data; } ushort3;

typedef union { int data; } int1;
typedef union { int data[2]; } int2;
typedef union { int data[4]; } int4;
typedef union { int data[8]; } int8;
typedef union { int data[16]; } int16;
typedef union { int4 data; } int3;

typedef union { unsigned int data; } uint1;
typedef union { unsigned int data[2]; } uint2;
typedef union { unsigned int data[4]; } uint4;
typedef union { unsigned int data[8]; } uint8;
typedef union { unsigned int data[16]; } uint16;
typedef union { uint4 data; } uint3;

typedef union { long data; } long1;
typedef union { long data[2]; } long2;
typedef union { long data[4]; } long4;
typedef union { long data[8]; } long8;
typedef union { long data[16]; } long16;
typedef union { long4 data; } long3;

typedef union { unsigned long data; } ulong1;
typedef union { unsigned long data[2]; } ulong2;
typedef union { unsigned long data[4]; } ulong4;
typedef union { unsigned long data[8]; } ulong8;
typedef union { unsigned long data[16]; } ulong16;
typedef union { ulong4 data; } ulong3;

typedef union { long long data; } longlong1;
typedef union { long long data[2]; } longlong2;
typedef union { long long data[4]; } longlong4;
typedef union { long long data[8]; } longlong8;
typedef union { long long data[16]; } longlong16;
typedef union { longlong4 data; } longlong3;

typedef union { unsigned long long data; } ulonglong1;
typedef union { unsigned long long data[2]; } ulonglong2;
typedef union { unsigned long long data[4]; } ulonglong4;
typedef union { unsigned long long data[8]; } ulonglong8;
typedef union { unsigned long long data[16]; } ulonglong16;
typedef union { ulonglong4 data; } ulonglong3;

typedef union { float data; } float1;
typedef union { float data[2]; } float2;
typedef union { float data[4]; } float4;
typedef union { float data[8]; } float8;
typedef union { float data[16]; } float16;
typedef union { float4 data; } float3;

typedef union { double data; } double1;
typedef union { double data[2]; } double2;
typedef union { double data[4]; } double4;
typedef union { double data[8]; } double8;
typedef union { double data[16]; } double16;
typedef union { double4 data; } double3;


#endif // defined(_MSC_VER)

#endif //HIP_INCLUDE_HIP_HSA_DETAIL_HIP_VECTOR_TYPES_H
