

/**
 *  @file  hsa_detail/hip_surface_types.h
 *  @brief Defines surface types for HIP runtime.
 */

#ifndef HIP_INCLUDE_HIP_HSA_DETAIL_HIP_SURFACE_TYPES_H
#define HIP_INCLUDE_HIP_HSA_DETAIL_HIP_SURFACE_TYPES_H

#include <hip/hsa_detail/driver_types.h>

/**
 * An opaque value that represents a hip surface object
 */
typedef unsigned long long hipSurfaceObject_t;

/**
 * hip surface reference
 */
struct surfaceReference {
    hipSurfaceObject_t surfaceObject;
};

/**
 * hip surface boundary modes
 */
enum hipSurfaceBoundaryMode {
    hipBoundaryModeZero = 0,
    hipBoundaryModeTrap = 1,
    hipBoundaryModeClamp = 2
};

#endif /* !HIP_INCLUDE_HIP_HSA_DETAIL_HIP_SURFACE_TYPES_H */
