
#ifndef HIP_DEVICE_EXT_FUNCTION__H
#define HIP_DEVICE_EXT_FUNCTION__H


/**
 *  HIP extend convert device function
 */

#if !defined(__HIPCC_RTC__)

#if defined(__STDC__) && defined(__STDC_VERSION__)
#if (__STDC_VERSION__ >= 199901L)

#include <stdint.h>

__device__ static inline uint8_t __float2uint8_rd(float x) {
    return (uint8_t) __ocml_floor_f32(x);
}

__device__ static inline uint8_t __float2uint8_rn(float x) {
    return (uint8_t) __ocml_rint_f32(x);
}

__device__ static inline uint8_t __float2uint8_ru(float x) {
    return (uint8_t) __ocml_ceil_f32(x);
}

__device__ static inline uint8_t __float2uint8_rz(float x) {
    return (uint8_t) __ocml_trunc_f32(x);
}

__device__ static inline uint16_t __float2uint16_rd(float x) {
    return (uint16_t) __ocml_floor_f32(x);
}

__device__ static inline uint16_t __float2uint16_rn(float x) {
    return (uint16_t) __ocml_rint_f32(x);
}

__device__ static inline uint16_t __float2uint16_ru(float x) {
    return (uint16_t) __ocml_ceil_f32(x);
}

__device__ static inline uint16_t __float2uint16_rz(float x) {
    return (uint16_t) __ocml_trunc_f32(x);
}


#endif //(__STDC_VERSION__ >= 199901L)
#endif //defined(__STDC__) && defined(__STDC_VERSION__)

#endif //!defined(__HIPCC_RTC__)

#endif //HIP_DEVICE_EXT_FUNCTION__H
