/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;

public class DesugarAtomicInteger {
    private DesugarAtomicInteger() {
    }

    public static int getAndUpdate(AtomicInteger atomic, IntUnaryOperator updateFunction) {
        int next;
        int prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = updateFunction.applyAsInt(prev))) {
        }
        return prev;
    }

    public static int updateAndGet(AtomicInteger atomic, IntUnaryOperator updateFunction) {
        int next;
        int prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = updateFunction.applyAsInt(prev))) {
        }
        return next;
    }

    public static int getAndAccumulate(AtomicInteger atomic, int x, IntBinaryOperator accumulatorFunction) {
        int next;
        int prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = accumulatorFunction.applyAsInt(prev, x))) {
        }
        return prev;
    }

    public static int accumulateAndGet(AtomicInteger atomic, int x, IntBinaryOperator accumulatorFunction) {
        int next;
        int prev;
        while (!atomic.compareAndSet(prev = atomic.get(), next = accumulatorFunction.applyAsInt(prev, x))) {
        }
        return next;
    }
}

