/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Era;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.JapaneseDate;
import java.time.chrono.Ser;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public final class JapaneseEra
implements Era,
Serializable {
    static final int ERA_OFFSET = 2;
    public static final JapaneseEra MEIJI = new JapaneseEra(-1, LocalDate.of(1868, 1, 1), "Meiji", "M");
    public static final JapaneseEra TAISHO = new JapaneseEra(0, LocalDate.of(1912, 7, 30), "Taisho", "T");
    public static final JapaneseEra SHOWA = new JapaneseEra(1, LocalDate.of(1926, 12, 25), "Showa", "S");
    public static final JapaneseEra HEISEI = new JapaneseEra(2, LocalDate.of(1989, 1, 8), "Heisei", "H");
    private static final int N_ERA_CONSTANTS = HEISEI.getValue() + 2;
    private static final long serialVersionUID = 1466499369062886794L;
    private static final JapaneseEra[] KNOWN_ERAS = new JapaneseEra[N_ERA_CONSTANTS];
    private final transient int eraValue;
    private final transient LocalDate since;
    private final transient String name;
    private final transient String abbreviation;

    static JapaneseEra getCurrentEra() {
        return KNOWN_ERAS[KNOWN_ERAS.length - 1];
    }

    static long shortestYearsOfEra() {
        int min = 999999999 - JapaneseEra.getCurrentEra().since.getYear() + 1;
        int lastStartYear = JapaneseEra.KNOWN_ERAS[0].since.getYear();
        for (int i = 1; i < KNOWN_ERAS.length; ++i) {
            JapaneseEra era = KNOWN_ERAS[i];
            int lastYearsOfEra = era.since.getYear() - lastStartYear + 1;
            min = Math.min(min, lastYearsOfEra);
            lastStartYear = era.since.getYear();
        }
        return min;
    }

    static long shortestDaysOfYear() {
        long min = ChronoField.DAY_OF_YEAR.range().getSmallestMaximum();
        for (JapaneseEra era : KNOWN_ERAS) {
            min = Math.min(min, (long)(era.since.lengthOfYear() - era.since.getDayOfYear() + 1));
            if (era.next() == null) continue;
            min = Math.min(min, (long)(era.next().since.getDayOfYear() - 1));
        }
        return min;
    }

    private JapaneseEra(int eraValue, LocalDate since, String name, String abbreviation) {
        this.eraValue = eraValue;
        this.since = since;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    LocalDate getSince() {
        return this.since;
    }

    public static JapaneseEra of(int japaneseEra) {
        if (japaneseEra < JapaneseEra.MEIJI.eraValue || japaneseEra + 2 > KNOWN_ERAS.length) {
            throw new DateTimeException("Invalid era: " + japaneseEra);
        }
        return KNOWN_ERAS[JapaneseEra.ordinal(japaneseEra)];
    }

    public static JapaneseEra valueOf(String japaneseEra) {
        Objects.requireNonNull(japaneseEra, "japaneseEra");
        for (JapaneseEra era : KNOWN_ERAS) {
            if (!era.getName().equals(japaneseEra)) continue;
            return era;
        }
        throw new IllegalArgumentException("japaneseEra is invalid");
    }

    public static JapaneseEra[] values() {
        return Arrays.copyOf(KNOWN_ERAS, KNOWN_ERAS.length);
    }

    @Override
    public String getDisplayName(TextStyle style, Locale locale) {
        if (this.getValue() > N_ERA_CONSTANTS - 2) {
            Objects.requireNonNull(locale, "locale");
            return style.asNormal() == TextStyle.NARROW ? this.getAbbreviation() : this.getName();
        }
        return Era.super.getDisplayName(style, locale);
    }

    static JapaneseEra from(LocalDate date) {
        if (date.isBefore(JapaneseDate.MEIJI_6_ISODATE)) {
            throw new DateTimeException("JapaneseDate before Meiji 6 are not supported");
        }
        for (int i = KNOWN_ERAS.length - 1; i >= 0; --i) {
            JapaneseEra era = KNOWN_ERAS[i];
            if (date.compareTo(era.since) < 0) continue;
            return era;
        }
        return null;
    }

    private static int ordinal(int eraValue) {
        return eraValue + 2 - 1;
    }

    @Override
    public int getValue() {
        return this.eraValue;
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ERA) {
            return JapaneseChronology.INSTANCE.range(ChronoField.ERA);
        }
        return Era.super.range(field);
    }

    String getAbbreviation() {
        return this.abbreviation;
    }

    String getName() {
        return this.name;
    }

    JapaneseEra next() {
        return this == JapaneseEra.getCurrentEra() ? null : JapaneseEra.of(this.eraValue + 1);
    }

    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(5, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.getValue());
    }

    static JapaneseEra readExternal(DataInput in) throws IOException {
        byte eraValue = in.readByte();
        return JapaneseEra.of(eraValue);
    }

    static {
        JapaneseEra.KNOWN_ERAS[0] = MEIJI;
        JapaneseEra.KNOWN_ERAS[1] = TAISHO;
        JapaneseEra.KNOWN_ERAS[2] = SHOWA;
        JapaneseEra.KNOWN_ERAS[3] = HEISEI;
    }
}

