/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HijrahChronology
extends AbstractChronology
implements Serializable {
    private final transient String typeId;
    private final transient String calendarType;
    private static final long serialVersionUID = 3127340209035924785L;
    public static final HijrahChronology INSTANCE;
    private volatile transient boolean initComplete;
    private transient int[] hijrahEpochMonthStartDays;
    private transient int minEpochDay;
    private transient int maxEpochDay;
    private transient int hijrahStartEpochMonth;
    private transient int minMonthLength;
    private transient int maxMonthLength;
    private transient int minYearLength;
    private transient int maxYearLength;

    private HijrahChronology(String id) throws DateTimeException {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("calendar id is empty");
        }
        this.typeId = id;
        this.calendarType = "islamic-umalqura";
    }

    private void checkCalendarInit() {
        if (!this.initComplete) {
            this.loadCalendarData();
            this.initComplete = true;
        }
    }

    @Override
    public String getId() {
        return this.typeId;
    }

    @Override
    public String getCalendarType() {
        return this.calendarType;
    }

    @Override
    public HijrahDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public HijrahDate date(int prolepticYear, int month, int dayOfMonth) {
        return HijrahDate.of(this, prolepticYear, month, dayOfMonth);
    }

    @Override
    public HijrahDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public HijrahDate dateYearDay(int prolepticYear, int dayOfYear) {
        HijrahDate date = HijrahDate.of(this, prolepticYear, 1, 1);
        if (dayOfYear > date.lengthOfYear()) {
            throw new DateTimeException("Invalid dayOfYear: " + dayOfYear);
        }
        return date.plusDays(dayOfYear - 1);
    }

    @Override
    public HijrahDate dateEpochDay(long epochDay) {
        return HijrahDate.ofEpochDay(this, epochDay);
    }

    @Override
    public HijrahDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public HijrahDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    @Override
    public HijrahDate dateNow(Clock clock) {
        return this.date(LocalDate.now(clock));
    }

    @Override
    public HijrahDate date(TemporalAccessor temporal) {
        if (temporal instanceof HijrahDate) {
            return (HijrahDate)temporal;
        }
        return HijrahDate.ofEpochDay(this, temporal.getLong(ChronoField.EPOCH_DAY));
    }

    public ChronoLocalDateTime<HijrahDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        this.checkCalendarInit();
        if (prolepticYear < (long)this.getMinimumYear() || prolepticYear > (long)this.getMaximumYear()) {
            return false;
        }
        int len = this.getYearLength((int)prolepticYear);
        return len > 354;
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof HijrahEra)) {
            throw new ClassCastException("Era must be HijrahEra");
        }
        return yearOfEra;
    }

    @Override
    public HijrahEra eraOf(int eraValue) {
        switch (eraValue) {
            case 1: {
                return HijrahEra.AH;
            }
        }
        throw new DateTimeException("invalid Hijrah era");
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(HijrahEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        this.checkCalendarInit();
        if (field instanceof ChronoField) {
            ChronoField f = field;
            switch (f) {
                case DAY_OF_MONTH: {
                    return ValueRange.of(1L, 1L, this.getMinimumMonthLength(), this.getMaximumMonthLength());
                }
                case DAY_OF_YEAR: {
                    return ValueRange.of(1L, this.getMaximumDayOfYear());
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return ValueRange.of(1L, 5L);
                }
                case YEAR: 
                case YEAR_OF_ERA: {
                    return ValueRange.of(this.getMinimumYear(), this.getMaximumYear());
                }
                case ERA: {
                    return ValueRange.of(1L, 1L);
                }
            }
            return field.range();
        }
        return field.range();
    }

    @Override
    public HijrahDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (HijrahDate)super.resolveDate(fieldValues, resolverStyle);
    }

    int checkValidYear(long prolepticYear) {
        if (prolepticYear < (long)this.getMinimumYear() || prolepticYear > (long)this.getMaximumYear()) {
            throw new DateTimeException("Invalid Hijrah year: " + prolepticYear);
        }
        return (int)prolepticYear;
    }

    void checkValidDayOfYear(int dayOfYear) {
        if (dayOfYear < 1 || dayOfYear > this.getMaximumDayOfYear()) {
            throw new DateTimeException("Invalid Hijrah day of year: " + dayOfYear);
        }
    }

    void checkValidMonth(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid Hijrah month: " + month);
        }
    }

    int[] getHijrahDateInfo(int epochDay) {
        this.checkCalendarInit();
        if (epochDay < this.minEpochDay || epochDay >= this.maxEpochDay) {
            throw new DateTimeException("Hijrah date out of range");
        }
        int epochMonth = this.epochDayToEpochMonth(epochDay);
        int year = this.epochMonthToYear(epochMonth);
        int month = this.epochMonthToMonth(epochMonth);
        int day1 = this.epochMonthToEpochDay(epochMonth);
        int date = epochDay - day1;
        int[] dateInfo = new int[]{year, month + 1, date + 1};
        return dateInfo;
    }

    long getEpochDay(int prolepticYear, int monthOfYear, int dayOfMonth) {
        this.checkCalendarInit();
        this.checkValidMonth(monthOfYear);
        int epochMonth = this.yearToEpochMonth(prolepticYear) + (monthOfYear - 1);
        if (epochMonth < 0 || epochMonth >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + prolepticYear + ", month: " + monthOfYear);
        }
        if (dayOfMonth < 1 || dayOfMonth > this.getMonthLength(prolepticYear, monthOfYear)) {
            throw new DateTimeException("Invalid Hijrah day of month: " + dayOfMonth);
        }
        return this.epochMonthToEpochDay(epochMonth) + (dayOfMonth - 1);
    }

    int getDayOfYear(int prolepticYear, int month) {
        return this.yearMonthToDayOfYear(prolepticYear, month - 1);
    }

    int getMonthLength(int prolepticYear, int monthOfYear) {
        int epochMonth = this.yearToEpochMonth(prolepticYear) + (monthOfYear - 1);
        if (epochMonth < 0 || epochMonth >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + prolepticYear + ", month: " + monthOfYear);
        }
        return this.epochMonthLength(epochMonth);
    }

    int getYearLength(int prolepticYear) {
        return this.yearMonthToDayOfYear(prolepticYear, 12);
    }

    int getMinimumYear() {
        return this.epochMonthToYear(0);
    }

    int getMaximumYear() {
        return this.epochMonthToYear(this.hijrahEpochMonthStartDays.length - 1) - 1;
    }

    int getMaximumMonthLength() {
        return this.maxMonthLength;
    }

    int getMinimumMonthLength() {
        return this.minMonthLength;
    }

    int getMaximumDayOfYear() {
        return this.maxYearLength;
    }

    int getSmallestMaximumDayOfYear() {
        return this.minYearLength;
    }

    private int epochDayToEpochMonth(int epochDay) {
        int ndx = Arrays.binarySearch(this.hijrahEpochMonthStartDays, epochDay);
        if (ndx < 0) {
            ndx = -ndx - 2;
        }
        return ndx;
    }

    private int epochMonthToYear(int epochMonth) {
        return (epochMonth + this.hijrahStartEpochMonth) / 12;
    }

    private int yearToEpochMonth(int year) {
        return year * 12 - this.hijrahStartEpochMonth;
    }

    private int epochMonthToMonth(int epochMonth) {
        return (epochMonth + this.hijrahStartEpochMonth) % 12;
    }

    private int epochMonthToEpochDay(int epochMonth) {
        return this.hijrahEpochMonthStartDays[epochMonth];
    }

    private int yearMonthToDayOfYear(int prolepticYear, int month) {
        int epochMonthFirst = this.yearToEpochMonth(prolepticYear);
        return this.epochMonthToEpochDay(epochMonthFirst + month) - this.epochMonthToEpochDay(epochMonthFirst);
    }

    private int epochMonthLength(int epochMonth) {
        return this.hijrahEpochMonthStartDays[epochMonth + 1] - this.hijrahEpochMonthStartDays[epochMonth];
    }

    private void loadCalendarData() {
        try {
            int year;
            HashMap<Integer, int[]> years = new HashMap<Integer, int[]>();
            int[][] monthLengths = HijrahChronology.hijrahUmalquraMonthLengths();
            int minYear = 1300;
            int maxYear = 1300 + monthLengths.length - 1;
            String id = "Hijrah-umalqura";
            String type = "islamic-umalqura";
            String version = "1.8.0_1";
            int isoStart = (int)LocalDate.of(1882, 11, 12).toEpochDay();
            for (year = 1300; year <= maxYear; ++year) {
                int[] numbers = monthLengths[year - 1300];
                if (numbers.length != 12) {
                    throw new IllegalArgumentException("wrong number of months on line: " + Arrays.toString(numbers) + "; count: " + numbers.length);
                }
                years.put(year, numbers);
            }
            if (!this.getId().equals("Hijrah-umalqura")) {
                throw new IllegalArgumentException("Configuration is for a different calendar: Hijrah-umalqura");
            }
            if (!this.getCalendarType().equals("islamic-umalqura")) {
                throw new IllegalArgumentException("Configuration is for a different calendar type: islamic-umalqura");
            }
            if ("1.8.0_1" == null || "1.8.0_1".isEmpty()) {
                throw new IllegalArgumentException("Configuration does not contain a version");
            }
            if (isoStart == 0) {
                throw new IllegalArgumentException("Configuration does not contain a ISO start date");
            }
            this.hijrahStartEpochMonth = 15600;
            this.minEpochDay = isoStart;
            this.hijrahEpochMonthStartDays = this.createEpochMonths(this.minEpochDay, 1300, maxYear, years);
            this.maxEpochDay = this.hijrahEpochMonthStartDays[this.hijrahEpochMonthStartDays.length - 1];
            for (year = 1300; year < maxYear; ++year) {
                int length = this.getYearLength(year);
                this.minYearLength = Math.min(this.minYearLength, length);
                this.maxYearLength = Math.max(this.maxYearLength, length);
            }
        }
        catch (Exception ex) {
            throw new DateTimeException("Unable to initialize HijrahCalendar: " + this.typeId, ex);
        }
    }

    private int[] createEpochMonths(int epochDay, int minYear, int maxYear, Map<Integer, int[]> years) {
        int numMonths = (maxYear - minYear + 1) * 12 + 1;
        int epochMonth = 0;
        int[] epochMonths = new int[numMonths];
        this.minMonthLength = Integer.MAX_VALUE;
        this.maxMonthLength = Integer.MIN_VALUE;
        for (int year = minYear; year <= maxYear; ++year) {
            int[] months = years.get(year);
            for (int month = 0; month < 12; ++month) {
                int length = months[month];
                epochMonths[epochMonth++] = epochDay;
                if (length < 29 || length > 32) {
                    throw new IllegalArgumentException("Invalid month length in year: " + minYear);
                }
                epochDay += length;
                this.minMonthLength = Math.min(this.minMonthLength, length);
                this.maxMonthLength = Math.max(this.maxMonthLength, length);
            }
        }
        epochMonths[epochMonth++] = epochDay;
        if (epochMonth != epochMonths.length) {
            throw new IllegalStateException("Did not fill epochMonths exactly: ndx = " + epochMonth + " should be " + epochMonths.length);
        }
        return epochMonths;
    }

    /*
     * Opcode count of 15957 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static int[][] hijrahUmalquraMonthLengths() {
        return new int[][]{{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 29}, {30, 30, 30, 29, 30, 30, 29, 29, 30, 29, 29, 30}, {29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29, 29}, {29, 30, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29}, {29, 29, 30, 30, 29, 30, 30, 29, 30, 30, 29, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 30, 30, 30, 29, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 29, 30, 30, 30, 29, 29}, {30, 30, 29, 30, 29, 29, 30, 29, 30, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 30, 30, 29}, {30, 29, 30, 29, 29, 30, 29, 29, 30, 30, 30, 30}, {29, 30, 29, 30, 29, 29, 29, 30, 29, 30, 30, 30}, {29, 30, 30, 29, 30, 29, 29, 29, 30, 29, 30, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30}, {30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 29, 30, 30, 30, 29, 30}, {30, 29, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30}, {30, 30, 29, 30, 29, 29, 30, 29, 29, 30, 30, 29}, {30, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29, 29}, {30, 29, 29, 30, 30, 29, 30, 30, 29, 30, 30, 29}, {29, 29, 30, 29, 30, 29, 30, 30, 30, 29, 30, 29}, {30, 29, 30, 29, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 30, 30, 29, 30, 29, 29, 30}, {29, 29, 30, 29, 30, 30, 30, 30, 29, 30, 29, 29}, {30, 29, 29, 30, 29, 30, 30, 30, 29, 30, 30, 29}, {29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30, 29}, {30, 29, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 29, 30, 29, 29}, {30, 29, 30, 30, 30, 30, 29, 30, 29, 29, 30, 29}, {29, 30, 29, 30, 30, 30, 29, 30, 30, 29, 29, 30}, {29, 29, 30, 29, 30, 30, 29, 30, 30, 30, 29, 29}, {30, 29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 29, 29, 30, 30, 29, 30}, {30, 29, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 29}, {30, 29, 29, 30, 30, 29, 30, 30, 29, 30, 30, 29}, {29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30, 30}, {29, 29, 30, 29, 30, 29, 29, 30, 29, 30, 30, 30}, {29, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 29, 29, 30, 30}, {29, 30, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 29, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 30}, {30, 30, 29, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {30, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 29, 30, 29, 30, 29, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 30, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 29, 30, 30, 30, 29, 30, 30, 29}, {30, 29, 29, 29, 30, 29, 30, 30, 29, 30, 30, 30}, {29, 30, 29, 29, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 29}, {30, 29, 29, 30, 30, 30, 29, 30, 30, 29, 30, 29}, {29, 30, 29, 29, 30, 30, 29, 30, 30, 30, 29, 30}, {29, 29, 30, 29, 29, 30, 30, 29, 30, 30, 30, 29}, {30, 29, 29, 30, 29, 29, 30, 30, 29, 30, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 29}, {30, 30, 29, 30, 30, 29, 30, 30, 29, 29, 30, 29}, {29, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 29, 30}, {30, 29, 30, 30, 29, 30, 30, 29, 29, 30, 29, 29}, {30, 29, 30, 30, 29, 30, 30, 30, 29, 29, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 29}, {30, 29, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30}, {30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30}, {30, 30, 29, 30, 29, 29, 30, 29, 29, 30, 29, 30}, {30, 30, 30, 29, 30, 29, 29, 30, 29, 29, 30, 29}, {30, 30, 30, 29, 30, 30, 29, 29, 30, 29, 29, 30}, {29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 29, 30, 30, 30, 29, 30, 29, 29, 30}, {30, 29, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 29, 30, 30}, {30, 30, 29, 30, 29, 30, 29, 29, 30, 29, 29, 30}, {30, 30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 29}, {30, 30, 29, 30, 30, 29, 30, 30, 29, 29, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 30, 30, 29, 29, 30}, {29, 30, 29, 29, 30, 29, 30, 30, 30, 29, 30, 29}, {30, 29, 30, 29, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 29, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 29, 30, 30, 30, 29, 29}, {29, 30, 29, 29, 30, 29, 30, 30, 30, 30, 29, 30}, {29, 29, 30, 29, 29, 29, 30, 30, 30, 30, 29, 30}, {30, 29, 29, 30, 29, 29, 29, 30, 30, 30, 29, 30}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 29, 30, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30}, {29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29}, {30, 29, 29, 30, 29, 29, 30, 30, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30, 30}, {29, 30, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 30, 30, 29, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 29, 30, 29, 30, 29, 29, 30}, {30, 29, 30, 30, 30, 29, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {29, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 30, 29, 30, 29, 29, 30, 29, 29, 30}, {29, 30, 30, 30, 29, 30, 30, 29, 29, 30, 29, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29}, {30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 30, 29}, {30, 30, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30}, {30, 29, 30, 30, 29, 29, 30, 29, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29, 30}, {29, 29, 30, 29, 30, 29, 30, 29, 30, 30, 30, 29}, {30, 29, 29, 30, 29, 29, 30, 29, 30, 30, 30, 30}, {29, 30, 29, 29, 30, 29, 29, 30, 29, 30, 30, 30}, {29, 30, 30, 29, 29, 30, 29, 29, 30, 29, 30, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 30, 30, 29, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29}, {29, 30, 29, 30, 29, 30, 29, 30, 30, 30, 29, 30}, {29, 30, 29, 29, 30, 29, 29, 30, 30, 30, 29, 30}, {30, 29, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30}, {30, 30, 29, 30, 29, 29, 29, 30, 29, 30, 30, 29}, {30, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 30, 29, 29, 30, 29, 30, 29}, {29, 30, 30, 29, 30, 30, 30, 29, 29, 30, 29, 29}, {30, 29, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 29, 30, 30, 30, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 30, 30, 30, 29, 30, 29, 29, 30, 29}, {29, 30, 29, 30, 30, 30, 29, 30, 30, 29, 29, 30}, {29, 29, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29}, {30, 29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 29, 30, 29}, {30, 29, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30}, {29, 30, 29, 29, 30, 30, 29, 30, 29, 30, 30, 29}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 30, 30}, {29, 30, 29, 30, 29, 30, 29, 29, 29, 30, 30, 30}, {29, 30, 30, 29, 30, 29, 29, 30, 29, 29, 30, 30}, {29, 30, 30, 30, 29, 30, 29, 29, 30, 29, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 29, 30, 30, 29, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 30, 29, 29, 29, 30, 29, 30, 30}, {30, 30, 29, 30, 29, 30, 29, 29, 29, 30, 30, 29}, {30, 30, 29, 30, 30, 29, 30, 29, 29, 29, 30, 30}, {29, 30, 29, 30, 30, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29}, {29, 30, 29, 29, 30, 30, 29, 30, 30, 29, 30, 30}, {29, 29, 30, 29, 29, 30, 30, 29, 30, 29, 30, 30}, {30, 29, 29, 30, 29, 30, 29, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 29, 30, 30, 30, 29, 30, 29, 30}, {29, 29, 29, 30, 29, 30, 30, 30, 29, 30, 30, 29}, {30, 29, 29, 29, 30, 29, 30, 30, 29, 30, 30, 30}, {29, 29, 30, 29, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 30}, {29, 30, 29, 30, 29, 30, 30, 29, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 29}, {30, 29, 29, 30, 30, 30, 29, 30, 30, 29, 30, 29}, {29, 30, 29, 29, 30, 30, 30, 29, 30, 30, 29, 30}, {29, 29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30}, {30, 29, 29, 29, 30, 29, 30, 30, 29, 30, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 29, 30, 30, 29}, {30, 30, 29, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {29, 30, 30, 29, 29, 30, 29, 30, 29, 29, 30, 30}, {29, 30, 30, 30, 29, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 30, 30, 29, 30, 30, 29, 29, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 30, 29, 29, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 29, 30, 29, 29, 30, 29, 30}, {30, 30, 29, 30, 30, 29, 29, 30, 29, 29, 30, 29}, {30, 30, 30, 29, 30, 30, 29, 29, 30, 29, 29, 30}, {29, 30, 30, 29, 30, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 29, 30, 30, 30, 29, 30, 29, 29, 30}, {29, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 29, 29, 30, 29, 30, 29, 30, 29, 30}, {30, 30, 29, 30, 29, 29, 30, 29, 30, 29, 29, 30}, {30, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 29}, {30, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 29, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30}, {29, 30, 29, 29, 30, 29, 30, 30, 30, 29, 30, 29}, {30, 29, 30, 29, 29, 29, 30, 30, 30, 29, 30, 30}, {29, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30, 30}, {30, 29, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30}, {29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 30, 30, 29, 30}, {29, 30, 29, 29, 29, 30, 29, 30, 30, 30, 30, 29}, {30, 29, 30, 29, 29, 29, 30, 29, 30, 30, 30, 29}, {30, 30, 29, 29, 30, 29, 29, 30, 30, 29, 30, 29}, {30, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 30, 30, 29, 29, 30, 29}, {29, 30, 30, 29, 30, 29, 30, 30, 30, 29, 29, 30}, {29, 30, 29, 29, 30, 29, 30, 30, 30, 29, 30, 29}, {30, 29, 30, 29, 29, 30, 29, 30, 30, 30, 29, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 30, 30, 29, 30}, {30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29, 29}, {30, 29, 30, 30, 30, 29, 30, 30, 29, 30, 29, 29}, {29, 30, 29, 30, 30, 29, 30, 30, 30, 29, 29, 30}, {29, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 29, 30, 29, 30, 29, 30, 30, 29, 30, 29}, {30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 29}, {30, 30, 30, 29, 30, 30, 29, 30, 29, 29, 29, 30}, {29, 30, 30, 29, 30, 30, 30, 29, 30, 29, 29, 29}, {30, 29, 30, 30, 29, 30, 30, 29, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 30, 29, 30, 30, 29, 30}, {29, 30, 29, 30, 29, 29, 30, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {30, 30, 29, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 30, 29, 30, 30, 29, 30, 29, 30, 29, 29, 29}, {30, 30, 29, 30, 30, 30, 29, 30, 29, 30, 29, 29}, {29, 30, 30, 29, 30, 30, 29, 30, 30, 29, 30, 29}, {29, 30, 29, 30, 29, 30, 29, 30, 30, 29, 30, 30}, {29, 29, 30, 29, 30, 29, 29, 30, 30, 30, 29, 30}, {29, 30, 30, 29, 29, 29, 30, 29, 30, 29, 30, 30}, {30, 29, 30, 30, 29, 29, 29, 30, 29, 30, 29, 30}, {30, 29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29}, {30, 29, 30, 30, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 29, 30, 29, 30, 30, 30, 29}, {30, 29, 29, 30, 29, 29, 30, 29, 30, 30, 30, 29}, {30, 30, 29, 29, 30, 29, 29, 29, 30, 30, 30, 30}, {29, 30, 29, 30, 29, 29, 30, 29, 29, 30, 30, 30}, {29, 30, 30, 29, 30, 29, 29, 30, 29, 30, 29, 30}, {29, 30, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29}, {30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 29}, {29, 30, 29, 30, 29, 30, 29, 30, 30, 30, 29, 30}, {29, 29, 30, 29, 30, 29, 29, 30, 30, 30, 29, 30}};
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    static {
        try {
            INSTANCE = new HijrahChronology("Hijrah-umalqura");
            AbstractChronology.registerChrono(INSTANCE, "Hijrah");
            AbstractChronology.registerChrono(INSTANCE, "islamic");
        }
        catch (DateTimeException ex) {
            throw new RuntimeException("Unable to initialize Hijrah-umalqura calendar", ex.getCause());
        }
    }
}

