#!/bin/bash
# start timing
start=$(date +%s)
start_fmt=$(date +%Y-%m-%d\ %r)
echo "STARTING TIMING RUN AT $start_fmt"

echo "running benchmark"

mpirun -np 8 --allow-run-as-root --bind-to none -x LD_LIBRARY_PATH -x PATH `pwd`/dcu.sh localhost

sleep 3

# end timing
end=$(date +%s)
end_fmt=$(date +%Y-%m-%d\ %r)
echo "ENDING TIMING RUN AT $end_fmt"

# report result
result=$(( $end - $start ))
result_name="OBJECT_DETECTION"

echo "RESULT,$result_name,,$result,dcu,$start_fmt"
