#!/bin/bash

# runs benchmark and reports time to convergence
# to use the script:
#   run_and_time.sh

set -e

export HSA_FORCE_FINE_GRAIN_PCIE=1
export MIOPEN_FIND_MODE=5

source config_DGXA100.sh
# start timing
start=$(date +%s)
start_fmt=$(date +%Y-%m-%d\ %r)
echo "STARTING TIMING RUN AT $start_fmt"

# run benchmark
set -x

echo "running benchmark"

#DATASET_DIR='/data'
#ln -sTf "${DATASET_DIR}/coco2017" /coco
#echo `ls /data`
#echo `ls /coco`
#echo `ls /pkl_coco`

export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
GPU=8
python3 -m torch.distributed.launch --nproc_per_node=$GPU tools/train_mlperf.py \
  ${EXTRA_PARAMS} \
  --config-file 'configs/e2e_mask_rcnn_R_50_FPN_1x.yaml' \
  DTYPE 'float16' \
  PATHS_CATALOG 'maskrcnn_benchmark.bak/config/paths_catalog_dbcluster.py' \
  MODEL.WEIGHT './R-50.pkl' \
  DISABLE_REDUCED_LOGGING True \
  ${EXTRA_CONFIG} ; ret_code=$?


set +x

sleep 3
if [[ $ret_code != 0 ]]; then exit $ret_code; fi

# end timing
end=$(date +%s)
end_fmt=$(date +%Y-%m-%d\ %r)
echo "ENDING TIMING RUN AT $end_fmt"

# report result
result=$(( $end - $start ))
result_name="OBJECT_DETECTION"

echo "RESULT,$result_name,,$result,nvidia,$start_fmt"


