# BERT
## 论文

BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding

* https://arxiv.org/abs/1810.04805

## 模型结构
BERT模型的核心是Transformer编码器，BERT-large是BERT模型的一个更大、更复杂的版本，其包含24个Transformer编码器，每个编码器有1024个隐藏层，总共包含340M个参数。在预训练阶段，BERT-large使用更多的未标记的文本数据进行预训练，并使用Masked Language Model（MLM）和Next Sentence Prediction（NSP）两个任务来优化模型。

下图为BERT的模型结构示意图

![figure1](figure1.png)

## 算法原理

BERT用大量的无监督文本通过自监督训练的方式训练，把文本中包含的语言知识（包括：词法、语法、语义等特征）以参数的形式编码到Transformer-encoder layer中，即用了Masked LM及Next Sentence Prediction两种方法分别捕捉词语和句子级别的representation。

## 目标精度

0.72 Mask-LM accuracy

## MLPerf代码参考版本

版本：v2.1 

原始代码位置：
* https://github.com/mlcommons/training_results_v2.1/tree/main/Baidu/benchmarks/bert/implementations/8_node_64_A100_PaddlePaddle

## 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:mlperf_paddle_bert_mpirun
    # <Image ID>用上面拉取docker镜像的ID替换
    # <Host Path>主机端路径
    # <Container Path>容器映射路径
    docker run -it --name mlperf_bert --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash

镜像版本依赖：
* DTK驱动：dtk21.04
* python: python3.6.8

测试目录:

```
/root/mlperf-paddle_bert.20220919-training-bert/training/bert
```

## 预训练模型

/workspace/bert_data文件夹存放预训练模型如下：

    ├── /workpalce/bert_data/phase1
    └── └──model.ckpt-28252.tf_pickled #预训练模型 

## 数据集

模型训练的数据集来自Wikipedia 2020/01/01，即一种常用的自然语言处理数据集，它包含了维基百科上的文章和对应的摘要（即第一段内容），可用于各种文本相关的任务，例如文本分类、文本摘要、命名实体识别等。

下载+预处理数据可按照下述进行，最终获得的输入数据如下图所示：

    ./input_preprocessing/prepare_data.sh --outputdir /workspace/bert_data 
![dataset](dataset.png)

对于预训练模型需要基于已下载数据进行如下处理：

     python3 models/load_tf_checkpoint.py \
        /workspace/bert_data/phase1/model.ckpt-28252 \
        /workspace/bert_data/phase1/model.ckpt-28252.tf_pickled

可得到/workspace/bert_data文件夹存放预训练模型如下：

    ├── /workpalce/bert_data/phase1
    └── └──model.ckpt-28252.tf_pickled #预训练模型 

## 训练

### 单机多卡

单机8卡进行性能&&精度测试

    bash run_8gpu.sh
    
    #不同环境的配置及数据的存放路径会有不同，请根据实际情况进行调整run_benchmark_8gpu.sh脚本中的如下内容：
    BASE_DATA_DIR=${BASE_DATA_DIR:-"/public/DL_DATA/mlperf/bert"} //调整为具体的数据的路径

### result

采用上述输入数据，加速卡采用Z100L * 8，可最终达到官方收敛要求，即达到目标精度0.72 Mask-LM accuracy；

| 卡数 | 类型     | 进程数 | 达到精度              |
| ---- | -------- | ------ | --------------------- |
| 8    | 混合精度 | 8      | 0.72 Mask-LM accuracy |

## 应用场景

### 算法类别

自然语言处理

### 热点应用行业

互联网、广告

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/mlperf_bert-large

## 参考
* https://mlcommons.org/en/
* https://github.com/mlcommons
