# BERT（Bidirectional Encoder Representations from Transformers）
## 模型介绍
一种基于Transformer架构的预训练语言模型，由Google在2018年提出。BERT模型通过大规模的自监督预训练，学习了丰富的语言表示，可以应用于各种自然语言处理任务。

BERT模型的核心是Transformer编码器，它可以对输入的文本数据进行编码，并生成对应的上下文表示。BERT模型使用双向编码器，即同时考虑输入序列的左侧和右侧上下文，可以捕捉更全面的语言表示。在预训练阶段，BERT模型使用了两种不同的预训练任务：Masked Language Model（MLM）和Next Sentence Prediction（NSP）。

在MLM任务中，BERT模型会随机将一些单词替换成“[MASK]”标记，然后尝试预测这些标记所对应的单词。在NSP任务中，BERT模型需要判断两个句子是否是连续的。通过这两种任务的预训练，BERT模型可以学习到丰富的语言表示，从而可以应用于各种自然语言处理任务。

## 模型结构
BERT-large是BERT模型的一个更大、更复杂的版本。与BERT-base相比，BERT-large具有更多的层数、更多的参数和更深的网络结构，可以学习更深层次和更复杂的语言表示。

BERT-large包含24个Transformer编码器，每个编码器有1024个隐藏层，总共包含340M个参数。在预训练阶段，BERT-large使用更多的未标记的文本数据进行预训练，并使用Masked Language Model（MLM）和Next Sentence Prediction（NSP）两个任务来优化模型。BERT-large的预训练阶段比BERT-base更复杂，并且需要更长的时间来训练。

## 目标精度

0.72 Mask-LM accuracy

## MLPerf代码参考版本

版本：v2.1 

原始代码位置：
* https://github.com/mlcommons/training_results_v2.1/tree/main/Baidu/benchmarks/bert/implementations/8_node_64_A100_PaddlePaddle

## 数据集
模型训练的数据集来自Wikipedia 2020/01/01，即一种常用的自然语言处理数据集，它包含了维基百科上的文章和对应的摘要（即第一段内容），可用于各种文本相关的任务，例如文本分类、文本摘要、命名实体识别等。

下载+预处理数据可按照下述进行，最终获得的输入数据如下图所示：

    ./input_preprocessing/prepare_data.sh --outputdir /workspace/bert_data 
    python3 models/load_tf_checkpoint.py \
        /workspace/bert_data/phase1/model.ckpt-28252 \
        /workspace/bert_data/phase1/model.ckpt-28252.tf_pickled
![dataset](dataset.png)

## 训练

### 测试规模

单机8卡进行性能&&精度测试

### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

    docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:mlperf_paddle_bert_mpirun
python依赖安装（如已经拉取镜像可忽略下述依赖安装步骤）：

    pip3 install -r requirement.txt

### 预训练模型
/workspace/bert_data文件夹存放预训练模型如下：

    ├── /workpalce/bert_data/phase1
    └── └──model.ckpt-28252.tf_pickled #预训练模型 

### 训练
训练命令：

    bash run_8gpu.sh
    
    #不同环境的配置及数据的存放路径会有不同，请根据实际情况进行调整run_benchmark_8gpu.sh脚本中的如下内容：
    BASE_DATA_DIR=${BASE_DATA_DIR:-"/public/DL_DATA/mlperf/bert"} //调整为具体的数据的路径

## 测试结果
采用上述输入数据，加速卡采用Z100L*8，可最终达到官方收敛要求；

## 源码仓库及问题反馈
* https://developer.hpccube.com/codes/modelzoo/mlperf_bert-large

## 参考
* https://mlcommons.org/en/
* https://github.com/mlcommons
