# Mistral
## 论文
暂无

## 模型结构
基于transformer结构
<div align=center>
    <img src="./doc/transformers.jpg" witdh=300 height=400/>
</div>

## 算法原理
‌Mistral模型是由法国初创公司Mistral AI开发的高性能开源大语言模型系列，以小参数规模实现优异性能为核心突破，涵盖7B、MoE混合专家架构及最新代理开发专用模型等多版本演进。‌ 该系列以滑动窗口注意力、完全开源协议和量化友好设计为技术亮点，在代码生成、推理效率等场景表现卓越。‌‌‌‌

高性能小参数架构：
- Mistral 7B（70亿参数）在常识推理、代码生成等基准测试中超越Llama 2 13B，消费级硬件即可流畅运行。‌‌
- 混合专家（MoE）版本如Mixtral 8x7B，每token激活2个专家层，总参数45B但计算效率对标12B密集模型，实现性能与资源消耗的平衡

‌优化的注意力机制：
- ‌滑动窗口注意力（SWA）‌：默认窗口大小4K tokens，通过局部注意力缓存降低显存占用，实测支持32K长上下文处理。‌‌‌
- 部分新版模型（如mistral-7b-instruct-v0.2）已取消SWA机制，采用标准注意力模式。‌‌

## 环境配置
`-v 路径`、`docker_nam`e和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250521-fixpy-rocblas0521-beta2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/mistral_pytorch
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t mistral:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/mistral_pytorch
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
vllm: 0.8.5
torch: 2.4.1+das.opt2.dtk2504
deepspeed: 0.14.2+das.opt2.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

## 数据集
无

## 训练
### Llama Factory 微调方法(推荐)
1. 训练库安装（**非mistral_pytorch目录下**），安装**主线版本**，`Llama-Factory`具体安装方法请参考仓库的README。
```
git clone https://developer.sourcefind.cn/codes/OpenDAS/llama-factory
```

2. 通过[预训练权重](#预训练权重)下载预训练模型，当前用例使用[Mistral-7B-Instruct-v0.3](https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3)模型。

#### 全参微调

SFT训练脚本示例，参考`llama-factory/train_full`下对应yaml文件。

**参数修改**：
- **--model_name_or_path**: 修改为待训练模型地址，如 `/data/mistralai/Mistral-7B-Instruct-v0.3`
- **--dataset**: 微调训练集名称，可选数据集请参考 `llama-factory/data/dataset_info.json`
- **--template**: 将 default 修改为 `mistral`
- **--output_dir**: 模型保存地址

其他参数如：`--learning_rate`、`--save_steps`可根据自身硬件及需求进行修改。

#### lora微调

SFT训练脚本示例，参考`llama-factory/train_lora`下对应yaml文件。
参数解释同[#全参微调](#全参微调)

## 推理
### vllm
#### offline
```bash
python infer_vllm.py --model_name_or_path /path_of/mistralai/Mistral-7B-Instruct-v0.3
```

### server
1. 启动服务
```bash
vllm serve mistralai/Mistral-7B-Instruct-v0.3 --tokenizer_mode mistral --config_format mistral --load_format mistral --served-model-name Mistral-7B-Instruct --trust-remote-code --enforce-eager
```

2. 测试client
```
curl http://<your-node-url>:8000/v1/chat/completions \
    -H "Content-Type: application/json" \
    -d '{
        "model": "Mistral-7B-Instruct",
        "messages": [
            {
                "role": "user",
                "content": "Explain Machine Learning to me in a nutshell."
                }
            ],
         "temperature": 0.15
    }'
```

## result
Prompt: "Explain Machine Learning to me in a nutshell."
<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
训练框架：[Llama-Factory](https://developer.sourcefind.cn/codes/OpenDAS/llama-factory)

训练脚本：[mistral_lora_sft.yaml](llama-factory/train_lora/mistral_lora_sft.yaml)

|   device   |   train_loss   |
|:----------:|:-------:|
| DCU K100AI | 0.8139 |
|  GPU A800  | 0.8146 |


## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [Mistral-7B-v0.3](http://huggingface.co/mistralai/Mistral-7B-v0.3)
- [Mistral-7B-Instruct-v0.3](https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mistral_pytorch

## 参考资料
- https://huggingface.co/mistralai
- https://github.com/hiyouga/LLaMA-Factory/
