# Mistral
## 论文
暂无

## 模型结构
<div align=center>
    <img src="./doc/transformers.jpg" witdh=300 height=400/>
</div>

## 算法原理



## 环境配置
`-v 路径`、`docker_nam`e和`imageID`根据实际情况修改

### Docker（方法一）
```bash
dcoker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250521-fixpy-rocblas0521-beta2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/mistral_pytorch
pip install mistral_inference
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t mistral:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/mistral_pytorch
pip install mistral_inference
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
torch: 2.4.1+das.opt2.dtk2504
deepspeed: 0.14.2+das.opt2.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install mistral_inference
```

## 数据集
无

## 训练
### Llama Factory 微调方法(推荐)
1. 训练库安装（**非mistral_pytorch目录下**），安装**主线版本**，`Llama-Factory`具体安装方法请参考仓库的README。
```
git clone https://developer.sourcefind.cn/codes/OpenDAS/llama-factory
```

2. 通过[预训练权重](#预训练权重)下载预训练模型，当前用例使用[Mistral-7B-Instruct-v0.3](https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3)模型。

#### 全参微调

SFT训练脚本示例，参考`llama-factory/train_full`下对应yaml文件。

**参数修改**：
- **--model_name_or_path**: 修改为待训练模型地址，如 `/data/mistralai/Mistral-7B-Instruct-v0.3`
- **--dataset**: 微调训练集名称，可选数据集请参考 `llama-factory/data/dataset_info.json`
- **--template**: 将 default 修改为 `mistral`
- **--output_dir**: 模型保存地址

其他参数如：`--learning_rate`、`--save_steps`可根据自身硬件及需求进行修改。

#### lora微调

SFT训练脚本示例，参考`llama-factory/train_lora`下对应yaml文件。
参数解释同[#全参微调](#全参微调)

## 推理
### mistral-chat
```bash
mistral-chat /path_of/mistral_models/7B-Instruct-v0.3 --instruct --max_tokens 256
```

### offline
```bash
python infer_mistral.py --model_name_or_path /path_of/model
```

## result
<div align=center>
    <img src="./doc/results.jpg"/>
</div>

### 精度
暂无

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [Mistral-7B-v0.3](http://huggingface.co/mistralai/Mistral-7B-v0.3)
- [Mistral-7B-Instruct-v0.3](https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mistral_pytorch

## 参考资料
- https://huggingface.co/mistralai
- https://github.com/hiyouga/LLaMA-Factory/
