# Mistral-Small
## 论文
暂无

## 模型结构
基于transformer结构
<div align=center>
    <img src="./doc/transformers.jpg" witdh=300 height=400/>
</div>

## 算法原理
Mistral Small 3.1 (25.03) 是一款多用途模型，专为编程、数学推理、文档理解和对话等各种任务而设计。2503 增加了最先进的视觉理解，在不影响文本性能的情况下增强了长达128k个tokens的长上下文功能。该模型有240亿个参数，在文本和视觉任务中都达到了顶级的能力。

- 视觉：视觉功能使模型能够分析图像，并提供基于文本之外的视觉内容的见解。
- 多语言：支持数十种语言，包括英语，法语，德语，希腊语，印地语，印度尼西亚语，意大利语，日语，韩语，马来语，尼泊尔语，波兰语，葡萄牙语，罗马尼亚语，俄语，塞尔维亚语，西班牙语，瑞典语，土耳其语，乌克兰语，越南语，阿拉伯语，孟加拉语，中文，波斯语。
- 以代理为中心：提供一流的代理功能，具备原生函数调用和 JSON 输出能力。
- 高级推理：最先进的对话和推理能力。
- 分词器：使用了一个词汇量为 131k 的 Tekken tokenizer


## 环境配置
`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250612-fixpy-rocblas0611-rc2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/mistral-small_pytorch
pip install mistral_common>=1.5.4
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t mistral-small:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/mistral-small_pytorch
pip install mistral_common>=1.5.4
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
vllm: 0.8.5
torch: 2.4.1+das.opt2.dtk2504
deepspeed: 0.14.2+das.opt2.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install mistral_common>=1.5.4
```

## 数据集
无

## 训练
### Llama Factory 微调方法(推荐)
1. 训练库安装（**非mistral-small_pytorch目录下**），安装**主线版本**，`Llama-Factory`具体安装方法请参考仓库的README。
```bash
git clone https://developer.sourcefind.cn/codes/OpenDAS/llama-factory
```

2. 通过[预训练权重](#预训练权重)下载预训练模型，当前用例使用[Mistral-Small-3.1-24B-Instruct-2503](https://huggingface.co/mistralai/Mistral-Small-3.1-24B-Instruct-2503)模型。

#### 全参微调
SFT训练脚本示例，参考`llama-factory/train_full`下对应yaml文件。

**参数修改**：
- **--model_name_or_path**: 修改为待训练模型地址，如 `/data/mistralai/Mistral-Small-3.1-24B-Instruct-2503`
- **--dataset**: 微调训练集名称，可选数据集请参考 `llama-factory/data/dataset_info.json`
- **--template**: 将 default 修改为 `mistral_small`
- **--output_dir**: 模型保存地址

其他参数如：`--learning_rate`、`--save_steps`可根据自身硬件及需求进行修改。

#### lora微调
SFT训练脚本示例，参考`llama-factory/train_lora`下对应yaml文件。
参数解释同[#全参微调](#全参微调)

## 推理
### vllm 推理
#### offline

```bash
python infer_vllm.py --model_name_or_path /path_of/model
```

## result
Prompt: "Give me 5 non-formal ways to say 'See you later' in French."
<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
训练框架：[Llama-Factory](https://developer.sourcefind.cn/codes/OpenDAS/llama-factory)

训练脚本：[mistral_small_lora_sft.yaml](llama-factory/train_lora/mistral_small_lora_sft.yaml)

|   device   |   train_loss   |
|:----------:|:-------:|
| DCU K100AI | 0.7417 |
|  GPU A800  | 0.7424 |

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [Mistral-Small-3.1-24B-Base-2503](https://huggingface.co/mistralai/Mistral-Small-3.1-24B-Base-2503)
- [Mistral-Small-3.1-24B-Instruct-2503](https://huggingface.co/mistralai/Mistral-Small-3.1-24B-Instruct-2503)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mistral-small_pytorch

## 参考资料
- https://mistral.ai/news/mistral-small-3-1
