# MiroThinker-v1.5
## 论文
[MiroThinker-v1.5](https://arxiv.org/abs/2511.11793)

## 模型简介
MiroThinkerv1.5是全球领先的搜索智能体，旨在提升工具增强推理与信息获取能力。与以往仅扩展模型规模或上下文长度的智能体不同，MiroThinker在模型层面引入了交互式扩展机制，将模型系统性训练为能够处理更深层次、更频繁的智能体‑环境交互，以此作为性能提升的第三维度。交互式扩展借助环境反馈与外部信息获取，实现错误修正与执行路径优化。实证结果验证了交互式扩展的有效性：在多项基准测试中，随着模型与环境的交互深度与频率逐步提升，其性能呈现出可预测的持续进步。

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name MiroThinker --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve miromind-ai/MiroThinker-v1.5-235B --trust-remote-code --dtype float16 -tp 8 --max-model-len 32768 --gpu-memory-utilization 0.95  --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "miromind-ai/MiroThinker-v1.5-235B",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| MiroThinker-v1.5-235B | 235B | BW1000 | 8 | [下载地址](https://huggingface.co/miromind-ai/MiroThinker-v1.5-235B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mirothinker-v1.5_vllm

## 参考资料
- https://huggingface.co/miromind-ai/MiroThinker-v1.5-235B
