# Ministral_pytorch
## 论文
暂无

## 模型结构
Ministral 8B 架构的详细信息如下：
<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
Mistral AI为本地智能、设备计算和边缘用例引入了两种新的先进模型Ministral 3B 和 Ministral 8B。
主要特点有：
- 使用 128k 上下文窗口和交错滑动窗口注意力进行训练
- 在大量多语言和代码数据上进行训练
- 支持函数调用，词汇量为 131k，使用 V3-Tekken 标记化器


## 环境配置
`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250521-fixpy-rocblas0521-beta2
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/ministral_pytorch
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t ministral:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/ministral_pytorch
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
vllm: 0.8.5
torch: 2.4.1+das.opt2.dtk2504
deepspeed: 0.14.2+das.opt2.dtk2504
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

## 数据集
无

## 训练
### Llama Factory 微调方法(推荐)
1. 训练库安装（**非ministral_pytorch目录下**），`Llama-Factory`具体安装方法请参考仓库的README。
```
git clone https://developer.sourcefind.cn/codes/OpenDAS/llama-factory
```

2. 通过[预训练权重](#预训练权重)下载预训练模型，当前用例使用[Ministral-8B-Instruct-2410](https://huggingface.co/mistralai/Ministral-8B-Instruct-2410)模型。

#### 全参微调

SFT训练脚本示例，参考`llama-factory/train_full`下对应yaml文件。

**参数修改**：
- **--model_name_or_path**: 修改为待训练模型地址，如 `/data/Ministral-8B-Instruct-2410`
- **--dataset**: 微调训练集名称，可选数据集请参考 `llama-factory/data/dataset_info.json`
- **--template**: 将 default 修改为 `ministral`
- **--output_dir**: 模型保存地址

其他参数如：`--learning_rate`、`--save_steps`可根据自身硬件及需求进行修改。

#### lora微调
SFT训练脚本示例，参考`llama-factory/train_lora`下对应yaml文件。
参数解释同[#全参微调](#全参微调)

## 推理
### vllm推理方法
#### offline
```bash
## 必须添加HF_ENDPOINT环境变量
export HF_ENDPOINT=https://hf-mirror.com

python infer_vllm.py --model_name mistralai/Ministral-8B-Instruct-2410
```

#### server

1. 启动server
```bash
vllm serve mistralai/Ministral-8B-Instruct-2410 --tokenizer-mode mistral --config-format mistral --load-format mistral
```

2. client测试:
```bash
curl --location 'http://<your-node-url>:8000/v1/chat/completions' \
--header 'Content-Type: application/json' \
--header 'Authorization: Bearer token' \
--data '{
    "model": "mistralai/Ministral-8B-Instruct-2410",
    "messages": [
      {
        "role": "user",
        "content": "Do we need to think for 10 seconds to find the answer of 1 + 1?"
      }
    ]
}'

```

## result
Prompt: "Do we need to think for 10 seconds to find the answer of 1 + 1?"
<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
训练框架：[Llama-Factory](https://developer.sourcefind.cn/codes/OpenDAS/llama-factory)

训练脚本：[ministral_lora_sft.yaml](llama-factory/train_lora/ministral_lora_sft.yaml)

|   device   |   train_loss   |
|:----------:|:-------:|
| DCU K100AI | 0.9068 |
|  GPU A800  |  |

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [Ministral-8B-Instruct-2410](https://huggingface.co/mistralai/Ministral-8B-Instruct-2410)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/ministral_pytorch

## 参考资料
- https://mistral.ai/news/ministraux