# MiniMax-M2
## 论文
[MiniMax-M2](https://www.minimax.io/news/minimax-m2)

## 模型简介
MiniMax-M2 重新定义了代理的效率。它是一个紧凑、快速且成本效益高的 MoE 模型（总参数量为 2300 亿，激活参数量为 100 亿），旨在在编码和代理任务中提供精英级性能，同时保持强大的通用智能。仅需 100 亿个激活参数，MiniMax-M2 就能提供当今领先模型所期望的复杂、端到端工具使用性能，但其精简的形式使其部署和扩展比以往任何时候都更容易。

- **卓越的智能：** 根据 Artificial Analysis 的基准测试，MiniMax-M2 在数学、科学、指令执行、编码和代理工具使用方面表现出高度竞争性的通用智能。其综合得分在全球开源模型中排名第一。
- **高级编码：** MiniMax-M2 专为端到端开发人员工作流程设计，在多文件编辑、编码-运行-修复循环和测试验证修复方面表现出色。在 Terminal-Bench 和 (Multi-)SWE-Bench 风格任务中的强大表现证明了其在终端、IDE 和 CI 中跨语言的实际有效性。
- **代理性能：** MiniMax-M2 能够在 shell、浏览器、检索和代码运行器中规划和执行复杂的长周期工具链。在 BrowseComp 风格的评估中，它能够始终如一地找到难以浮现的来源，保持证据可追溯，并优雅地从不稳定步骤中恢复。
- **高效设计：** 凭借 100 亿个激活参数（总共 2300 亿个参数），MiniMax-M2 提供了更低的延迟、更低的成本和更高的吞吐量，适用于交互式代理和批量采样——完美契合了向高度可部署但仍能在编码和代理任务中发光发热的模型转变的趋势。

<div align=center>
    <img src="./doc/Bench.png"/>
</div>


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.3 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |
| flash_attn | 2.6.1+das.opt1.dtk2504.20251222.g859b5024 |
| flash_mla | 1.0.0+das.opt1.dtk2604.20251218.gb14bad68.rccl |

当前仅支持镜像: harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name minimax_m2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理
1. 将FP8模型权重转换成BF16，转换方法如下：

```bash
python cast_model_dtype/fp8_cast_bf16.py --input-fp8-hf-path /path/of/MiniMax/MiniMax-M2/ --output-bf16-hf-path /path/of/MiniMax/MiniMax-M2-bf16
```
2. 相关模型文件拷贝：
```bash
cp config.json /path/of/MiniMax/MiniMax-M2-bf16
cp /path/of/MiniMax/MiniMax-M2/chat_template.jinja /path/of/MiniMax/MiniMax-M2-bf16
cp /path/of/MiniMax/MiniMax-M2/configuration.json /path/of/MiniMax/MiniMax-M2-bf16
cp /path/of/MiniMax/MiniMax-M2/generation_config.json  /path/of/MiniMax/MiniMax-M2-bf16
cp /path/of/MiniMax/MiniMax-M2/configuration_minimax_m2.py  /path/of/MiniMax/MiniMax-M2-bf16
cp /path/of/MiniMax/MiniMax-M2/tokenizer* /path/of/MiniMax/MiniMax-M2-bf16
cp /path/of/MiniMax/MiniMax-M2/vocab.json /path/of/MiniMax/MiniMax-M2-bf16
```

### vllm
#### 单机推理
```bash
## serve启动
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_MLA_DISABLE=0
export VLLM_USE_FLASH_MLA=1


vllm serve /path/of/MiniMax/MiniMax-M2-bf16/ \
    --trust-remote-code \
    --max-model-len 32768 \
    --served-model-name minimax \
    --dtype bfloat16 \
    -tp 8

## client访问
curl http://localhost:8000/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "minimax",
        "messages": [
            {
                "role": "user",
                "content": "牛顿提出了哪三大运动定律？请简要说明。"
            }
        ]
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/results.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| MiniMax-M2 | 230 B | K100AI | 8 | [下载地址](https://huggingface.co/MiniMaxAI/MiniMax-M2) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/minimax-m2_vllm

## 参考资料
- https://github.com/MiniMax-AI/MiniMax-M2
