# MiniCPM
2B小钢炮碾压Mistral-7B，消费级显卡可训练，超过或持平大部分7B规模模型，超越部分10B以上的模型，主体语言模型MiniCPM-2B仅有24亿（2.4B）的非词嵌入参数量, 总计2.7B参数量，整体性能超越 Llama2-13B、MPT-30B、Falcon-40B 等模型，以下步骤适于finetune及其推理。
## 论文
`未发表论文`

## 模型结构
[`minicpm`](./model/modeling_minicpm.py)基于原始transformer decoder结构进行魔改而成，细节请见代码，先对文本进行分词，并将每个词转换为词向量表示，然后通过多组attention和全连接层结构FeedForward提取特征，最后采用全连接层结构MLP改变输入张量的形状获得生成结果，为了进一步提供预测的准确率加入了强化学习DPO进行人类偏好对齐。

## 算法原理
[`minicpm`](./model/modeling_minicpm.py)算法主要将转换成向量的分词用qkv自相关和全连接层提取特征，然后利用全连接层输出监督训练结果，本算法进行大量细节上的魔改组合，具体算法原理可参考下图原始transformer模型结构右侧decoder部分进行初步理解。
<div align=center>
    <img src="./doc/transformer.png"/>
</div>

## 环境配置
```
mv MiniCPM_pytorch MiniCPM # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk23.10-py38
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：ffa1f63239fc
docker run -it --shm-size=32G -v $PWD/MiniCPM:/home/MiniCPM -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name minicpm <your IMAGE ID> bash
cd MiniCPM
pip install -r requirements.txt # finetune/requirements.txt
# deepspeed、flash_attn2、xformers可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+git299681e.abi0.dtk2310.torch2.1.0a0-cp38-cp38-linux_x86_64.whl
pip install flash_attn-2.0.4_torch2.1_dtk2310-cp38-cp38-linux_x86_64.whl
# xformers
tar -xvf xformers.tar
cd xformers
pip install xformers==0.0.23 --no-deps
bash patch_xformers.rocm.sh
```
### Dockerfile（方法二）
```
cd MiniCPM/docker
docker build --no-cache -t minicpm:latest .
docker run --shm-size=32G --name minicpm -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../MiniCPM:/home/MiniCPM -it minicpm bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
# deepspeed、flash_attn2、xformers可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+git299681e.abi0.dtk2310.torch2.1.0a0-cp38-cp38-linux_x86_64.whl
pip install flash_attn-2.0.4_torch2.1_dtk2310-cp38-cp38-linux_x86_64.whl
# xformers
tar -xvf xformers.tar
cd xformers
pip install xformers==0.0.23 --no-deps
bash patch_xformers.rocm.sh
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk23.10
python:python3.8
torch:2.1.0
torchvision:0.16.0
triton:2.1.0
apex:0.1
deepspeed:0.12.3
flash_attn:2.0.4
xformers:0.0.23
```

```
# deepspeed、flash_attn2、xformers可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+git299681e.abi0.dtk2310.torch2.1.0a0-cp38-cp38-linux_x86_64.whl
pip install flash_attn-2.0.4_torch2.1_dtk2310-cp38-cp38-linux_x86_64.whl
# xformers
tar -xvf xformers.tar
cd xformers
pip install xformers==0.0.23 --no-deps
bash patch_xformers.rocm.sh
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
pip install -r requirements.txt # finetune/requirements.txt
```

## 数据集
`AdvertiseGen`
- https://cloud.tsinghua.edu.cn/f/b3f119a008264b1cabd1/?dl=1

```
# 校验文件完整性
md5sum data/AdvertiseGen.tar.gz 
# 解压数据集
tar xvf data/AdvertiseGen.tar.gz
```
数据预处理脚本脚本为：[`convert_data.py`](./convert_data.py)，数据目录结构如下：
```
data/AdvertiseGenChatML
    ├── train.json
    └── dev.json
```
`更多资料可参考源项目的README_origin.md`

## 训练
finetune所需预训练权重下载地址：https://modelscope.cn/models/OpenBMB/miniCPM-bf16

本步骤说明的预训练权重采用`MiniCPM-2B-sft-bf16`，请下载后放入目录checkpoint下面：checkpoint/miniCPM-bf16/
### 单机单卡（LoRA finetune）
```
cd MiniCPM
bash finetune/lora_finetune.sh # LoRA finetune，显存占用10619MiB。
# 受限于模型/数据规模，模型可能出现幻觉性问题，若仅仅采用LoRA finetune幻觉性问题较为严重。
```
### 单机多卡（全参数finetune）
```
bash finetune/sft_finetune.sh # 全参数finetune，显存占用30245MiB。
```
更多资料可参考源项目的[`finetune`](./finetune/README.md)


## 推理
```
python infer.py
# 若采用官方默认权重推理：代码里设置path = 'checkpoint/miniCPM-bf16'
```

## result
```
#问题
山东省最高的山是哪座山, 它比黄山高还是矮？差距多少？
#生成答案
山东省最高的山是泰山，海拔1545米。
相对于黄山（海拔1864米），泰山海拔较低，相差约319米。
```
### 精度
测试数据（LoRA finetune）：[`AdvertiseGen`](./data/AdvertiseGenChatML/dev.json)，推理框架：pytorch。

|  device   | train_loss |
|:---------:|:----------:|
| DCU Z100L |   5.1066   |
| GPU V100S |   5.1052   |

## 应用场景
### 算法类别
`对话问答`
### 热点应用行业
`制造,广媒,金融,能源,医疗,家居,教育`
## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/minicpm_pytorch.git
## 参考资料
- https://github.com/OpenBMB/MiniCPM.git
- https://shengdinghu.notion.site/MiniCPM-c805a17c5c8046398914e47f0542095a
- https://hf-mirror.com/ #Huggingface镜像官网下载教程
- https://hf-mirror.com/datasets #Huggingface镜像数据地址
