# MiniCPM
基于源MiniCPM修改的分类算法，可用于情感分类等场景，2B小钢炮碾压Mistral-7B，消费级显卡可训练，超过或持平大部分7B规模模型，超越部分10B以上的模型，主体语言模型MiniCPM-2B仅有24亿（2.4B）的非词嵌入参数量, 总计2.7B参数量，整体性能超越 Llama2-13B、MPT-30B、Falcon-40B 等模型。
## 论文
`未发表论文`

## 模型结构
[`minicpm`](./model/modeling_minicpm.py)基于原始transformer decoder结构对特征进行大量旋转编码、融合等特征变化操作而成，细节请见代码。

## 算法原理
[`minicpm`](./model/modeling_minicpm.py)算法主要将转换成向量的分词用qkv自相关和全连接层提取特征，然后利用全连接层输出监督训练结果，本算法进行大量细节上的魔改组合，具体算法原理可参考下图原始transformer模型结构右侧decoder部分进行理解。
<div align=center>
    <img src="./doc/transformer.png"/>
</div>

## 环境配置
```
mv minicpm_classify_pytorch MiniCPM_classify # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换
docker run -it --shm-size=32G -v $PWD/MiniCPM_classify:/home/MiniCPM_classify -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name minicpm_classify <your IMAGE ID> bash
cd /home/MiniCPM_classify
pip install -r finetune/requirements.txt # finetune/requirements.txt
```
### Dockerfile（方法二）
```
cd MiniCPM_classify/docker
docker build --no-cache -t minicpm_classify:latest .
docker run --shm-size=32G --name minicpm_classify -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../MiniCPM_classify:/home/MiniCPM_classify -it minicpm_classify bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk24.04.1
python:python3.10
torch:2.1.0
torchvision:0.16.0
triton:2.1.0
apex:0.1
deepspeed:0.12.3
flash_attn:2.0.4
xformers:0.0.23
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
pip install -r finetune/requirements.txt # finetune/requirements.txt
```

## 数据集
本项目包含一个mini数据集AdvertiseGenChatML，实际项目将自有数据按其中的train、dev文件格式制作即可，数据目录结构如下：
```
data/AdvertiseGenChatML
    ├── train.json
    └── dev.json
```
`更多资料可参考源项目的README_origin.md`

## 训练
finetune所需预训练权重下载地址：[modelscope](https://modelscope.cn/models/OpenBMB/miniCPM-bf16)

本步骤说明的预训练权重采用`miniCPM-bf16`，请下载后放入目录checkpoint下面：checkpoint/miniCPM-bf16/

`微调时项目会默认使用checkpoint/miniCPM-bf16下的配置文件和模型文件：`[`configuration_minicpm`](./checkpoint/miniCPM-bf16/configuration_minicpm.py)和[`modeling_minicpm`](./checkpoint/miniCPM-bf16/modeling_minicpm.py)，默认类别数为2。
### 单机单卡（LoRA finetune）
```
cd MiniCPM_classify
cp modeling_minicpm.py ./checkpoint/miniCPM-bf16/ # 采用修改后的分类模型文件替换预训练权重中的模型文件进行微调训练
bash finetune/lora_finetune.sh # LoRA finetune，显存占用10619MiB。
```
### 单机多卡（全参数finetune）
```
bash finetune/sft_finetune.sh # 全参数finetune，显存占用30245MiB。
```
更多资料可参考源项目的[`finetune`](./finetune/README.md)

## 推理
```
python infer.py # 默认类别数为2
# 若采用官方默认权重推理：代码里设置path = 'checkpoint/miniCPM-bf16'
# 采用自己的微调结果推理：代码里设置path = "output/AdvertiseGenLoRA/xxx/checkpoint-3000"
```

## result
```
# 输入
简约而不简单的牛仔外套，白色的衣身十分百搭。衣身多处有做旧破洞设计，打破单调乏味，增加一丝造型看点。衣身后背处有趣味刺绣装饰，丰富层次感，彰显别样时尚。
# 输出
0 # 默认设置为0代表积极，1代表消极。
```
### 精度
DCU Z100L精度与英伟达v100一致。

## 应用场景
### 算法类别
`情感分类`
### 热点应用行业
`制造,广媒,金融,能源,医疗,家居,教育`
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/minicpm_classify_pytorch.git
## 参考资料
- https://github.com/OpenBMB/MiniCPM.git
- https://shengdinghu.notion.site/MiniCPM-c805a17c5c8046398914e47f0542095a
- https://hf-mirror.com/ #Huggingface镜像官网下载教程
- https://hf-mirror.com/datasets #Huggingface镜像数据地址
