# MiniCPM-V-2_6
## 论文

[MiniCPM-V: A GPT-4V Level MLLM on Your Phone](https://arxiv.org/abs/2408.01800)


## 模型结构

该模型包括三个关键模块：视觉编码器、压缩层和LLM。输入图像首先由利用自适应视觉编码方法的视觉编码器编码。具体来说，模型采用SigLIP SoViT-400m/14作为视觉编码器。然后由压缩层压缩视觉令牌，压缩层采用具有一层交叉注意的感知器重采样器结构。最后，压缩的视觉标记与文本输入一起被馈送到LLM中，用于条件文本生成。


<div align=center>
    <img src="./Pic/arch.png"/>
</div>

## 算法原理

为了解决幻觉问题，采用了最近的RLAIF-V方法，其中关键是从用于直接偏好优化(DPO)的开源模型中获得可扩展的高质量反馈。减少幻觉的RLAIF-V框架：(1)响应生成使用策略模型为指令生成多个响应。（2）反馈收集以分而治之的方式评估每个响应的正确性。（3）DPO在偏好数据集上优化模型

<div align=center>
    <img src="./Pic/theory.png"/>
</div>

## 环境配置
### Docker（方法一）
推荐使用docker方式运行， 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04
docker run -it --shm-size=1024G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal --network=host --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name minicpm_v  <your IMAGE ID> bash # <your IMAGE ID>为以上拉取的docker的镜像ID替换

git clone http://developer.sourcefind.cn/codes/modelzoo/minicpm-v-2_6_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
Tips:以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。

### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
docker build -t internvl:latest .
docker run --shm-size 500g --network=host --name=minicpm_v --privileged --device=/dev/kfd --network=host --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash


git clone http://developer.sourcefind.cn/codes/modelzoo/minicpm-v-2_6_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动:dtk24.04.3
python:3.10
torch:2.3.0
transformers==4.48.3
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirement.txt安装：
```

git clone http://developer.sourcefind.cn/codes/modelzoo/minicpm-v-2_6_pytorch.git

cd /path/your_code_data/

pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```
## 数据集

ms-swift 自带数据集 AI-ModelScope/LaTeX_OCR:human_handwrite#20000

## 训练

使用ms-swift框架微调
```
git clone https://github.com/modelscope/ms-swift.git

cd ms-swift

pip install -e . -i https://pypi.tuna.tsinghua.edu.cn/simple
```

### 单机多卡

sh finetune.sh

## 推理

### 单机多卡

```
CUDA_VISIBLE_DEVICES=0,1,2,3 minicpm-v_version.py
```

## result


<div align=left>
    <img src="./Pic/result.png"/>
</div>

### 精度

无



## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`科研,教育,政府,金融`

## 预训练权重

预训练权重快速下载中心：[SCNet AIModels](https://www.scnet.cn/ui/aihub/models) 

项目中的预训练权重可从快速下载通道下载：[openbmb/MiniCPM-V-2_6](https://www.scnet.cn/ui/aihub/models/sugon_scnet/openbmb/MiniCPM-V-2_6)

HF/github下载地址为：[openbmb/MiniCPM-V-2_6](https://huggingface.co/openbmb/MiniCPM-V-2_6)

魔搭下载路径：
- [openbmb/MiniCPM-V-2_6 魔搭下载](https://www.modelscope.cn/models/OpenBMB/MiniCPM-V-2_6/files)

## 源码仓库及问题反馈
-  http://developer.sourcefind.cn/codes/modelzoo/minicpm-v-2_6_pytorch.git

## 参考资料

- https://github.com/OpenBMB/MiniCPM-o

