# MinerU

## 论文
`
MinerU: An Open-Source Solution for Precise Document Content Extraction
`
- https://arxiv.org/abs/2409.18839

## 模型结构
MinerU是一个功能强大的PDF文档内容提取工具，它利用了先进的PDF-Extract-Kit模型库，能够有效地从各种类型的文档中提取内容。
MinerU的框架设计简洁而高效，主要包括文档预处理、文档内容解析、文档内容后处理和格式转换四个阶段。
<div align=center>
    <img src="./assets/workflow.png"/>
</div>

## 算法原理
MinerU处理过程如下：

（1）文档预处理

文档预处理主要有两个目标。一是筛选出无法处理的 PDF 文件，例如非 PDF 格式文件、加密文档以及受密码保护的文件，确保后续处理流程的顺利进行。
二是获取 PDF 文档的元数据，这些元数据在后续的处理过程中具有重要作用。

（2）文档内容解析

PDF - Extract - Kit 是 MinerU 用于解析文档的核心模型库，包含多种先进的开源 PDF 文档解析算法。与其他开源算法库不同，它致力于在处理现实世界多样化数据时确保准确性和速度。
当特定领域的现有开源算法无法满足实际需求时，PDF - Extract - Kit 会通过数据工程构建高质量、多样化的数据集来进一步微调模型，从而显著增强模型对不同数据的鲁棒性。

（3）文档内容后处理

文档内容后处理阶段主要解决内容排序问题。由于模型输出的文本、图像、表格和公式框之间可能存在重叠，
以及通过 OCR 或 API 获得的文本行之间也经常重叠，这给文本和元素的排序带来了巨大挑战。

（4）格式转换

最后，在格式转换阶段，MinerU将处理后的PDF数据转换为用户所需的机器可读格式（如Markdown或JSON）。


## 环境配置

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
# <your IMAGE ID>为以上拉取的docker的镜像ID替换
docker run -it --name mineru --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v $PWD/MinerU_pytorch:/home/MinerU_pytorch <your IMAGE ID> /bin/bash
cd /home/MinerU_pytorch
pip install -e .[core] -i https://mirrors.aliyun.com/pypi/simple/
pip install numpy==1.24.3
#以下torchvision-0.19.1、torch-2.4.1、triton-3.0.0whl可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/
pip install torchvision-0.19.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.4.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install triton-3.0.0+das.opt4.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
cd sglang-v0.4.6.post5.dev/sgl-kernel
python setup_hip.py install
cd ..
pip install -e "python[all_hip]"

```
### Dockerfile（方法二）
```
cd /home/MinerU_pytorch
docker build --no-cache -t MinerU:latest .
docker run -it --name MinerU_test --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v $PWD/MinerU_pytorch:/home/MinerU_pytorch MinerU /bin/bash
cd /home/MinerU_pytorch
pip install -e .[core] -i https://mirrors.aliyun.com/pypi/simple/
pip install numpy==1.24.3
#以下torchvision-0.19.1、torch-2.4.1、triton-3.0.0whl可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/
pip install torchvision-0.19.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.4.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install triton-3.0.0+das.opt4.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
cd sglang-v0.4.6.post5.dev/sgl-kernel
python setup_hip.py install
cd ..
pip install -e "python[all_hip]"
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk25.04
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
flash-attn:2.6.1
vllm:0.7.2

```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/MinerU_pytorch
pip install -e .[core] -i https://mirrors.aliyun.com/pypi/simple/
pip install torchvision-0.19.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.4.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install triton-3.0.0+das.opt4.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install lmslim-0.2.1+das.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install flash_attn-2.6.1+das.opt4.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
pip install vllm-0.7.2+das.opt1.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
cd sglang-v0.4.6.post5.dev/sgl-kernel
python setup_hip.py install
cd ..
pip install -e "python[all_hip]"
pip install pytest==8.3.5 pytest-asyncio==0.26.0 numpy==1.24.3
pip install amdsmi-24.5.3+02cbffb.dirty-py3-none-any.whl
```

## 数据集
`无`

## 训练
`无`

## 推理

模型源配置
```
#添加HF镜像方便下载模型
#export HF_ENDPOINT=https://hf-mirror.com
#默认在首次运行时自动从 HuggingFace 下载所需模型。
#若无法访问 HuggingFace，可通过以下方式切换模型源：
mineru -p <input_path> -o <output_path> --source modelscope
#或设置环境变量：
export MINERU_MODEL_SOURCE=modelscope

#如需使用本地模型，可使用交互式命令行工具选择模型下载：
mineru-models-download --help
#下载完成后，模型路径会在当前终端窗口输出，并自动写入用户目录下的 mineru.json
```
### 单机单卡
```

#Run pipeline    
cd /home/MinerU_pytorch
HIP_VISIBLE_DEVICES=0 python demo/demo.py
  
#Using sglang to Accelerate VLM Model Inference
 #Through the sglang-server/client Mode
#注意：运行的时候需要加 --attention-backend triton选项，别的kernel不支持
HIP_VISIBLE_DEVICES=0 mineru-sglang-server --attention-backend triton --port 30000
    
#Use Client in another terminal:
mineru -p <input_path> -o <output_path> -b vlm-sglang-client -u http://127.0.0.1:30000
```

更多资料可参考源项目中的[`README_ori`](./README_orgin.md)。

## result
解析示例：

layout:

<div align=center>
    <img src="./assets/layout.png"/>
</div>

解析结果：

<div align=center>
    <img src="./assets/result.png"/>
</div>



### 精度

DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`OCR`
### 热点应用行业
`科研,教育,政府,广媒`
## 预训练权重
魔搭社区下载地址为：[OpenDataLab/PDF-Extract-Kit-1.0](https://modelscope.cn/models/OpenDataLab/PDF-Extract-Kit-1.0)

Hugging Face下载地址为：[OpenDataLab/PDF-Extract-Kit-1.0](https://huggingface.co/opendatalab/PDF-Extract-Kit-1.0)

注意：`自动下载模型建议加镜像源下载：export HF_ENDPOINT=https://hf-mirror.com`

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mineru_pytorch
## 参考资料
- https://github.com/opendatalab/MinerU

