from transformers import AutoModelForCausalLM, AutoTokenizer

# 加载预训练的Metamath模型和分词器
model_name = "/home/practice/model/metamath_7b/MetaMath-7B-V1.0"
tokenizer = AutoTokenizer.from_pretrained(model_name)
model = AutoModelForCausalLM.from_pretrained(model_name)

# 准备输入文本
input_text = "3 + 4 × 2 = ?"

# 使用分词器将输入文本编码为模型所需的格式
input_ids = tokenizer.encode(input_text, return_tensors="pt")

# 使用模型进行推理
outputs = model.generate(input_ids)

# 将模型输出解码为文本
output_text = tokenizer.decode(outputs[0], skip_special_tokens=True)

print(output_text)
