## MetaMath

## 论文

`MetaMath: Bootstrap Your Own Mathematical Questions for Large Language Models`

- [https://arxiv.org/abs/2309.12284]


## 模型架构

MetaMath对LLama-2模型进行了MetaMathQA数据集上的微调。LLama-2采用基于Transformer的解码器架构，集成了自注意力、位置编码、多头注意力机制、前馈网络、残差连接和层归一化等技术。该模型通过在大规模语料上的预训练和微调，有效学习语言模式和知识，并在特定任务上展现出卓越的性能。

## 算法原理

MetaMath是专门针对数学推理进行微调的语言模型。具体来说，从多个角度重写数学问题来引导启动数学问题，形成了一个名为MetaMathQA的新数据集。然后在MetaMathQA上对LLaMA-2模型进行微调。在两个流行的数学推理基准测试（即GSM8K和MATH）上的实验结果表明，MetaMath在一系列开源LLMs中取得了显著的性能优势。
<div align=center>
    <img src="./imgs/metamath.svg"/>
</div>

## 环境配置

### Docker（方法一）

此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取 docker 镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it --shm-size=1024G -v /parastor/home/MetaMath:/home/MetaMath -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name xver  <your IMAGE ID> bash  # <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
cd /home/MetaMath
pip install -r requirement.txt -iasd https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com

```

### Dockerfile（方法二）

此处提供 dockerfile 的使用方法

```
docker build  -t Metamath-df:latest .
docker run -it --shm-size=1024G -v /parastor/home/Metamath:/home/Metamath -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name Metamath  Metamath-df  bash
pip install -r requirement.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com

```

### Anaconda（方法三）

此处提供本地配置、编译的详细步骤，例如：

关于本项目 DCU 显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk24.04
python：python3.10
torch: 2.1.0
torchvision: 0.16.0
bitsandbytes: 0.42.0
```

`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照 requirements.txt 安装：

```
pip install -r requirements.txt
```

## 数据集
使用MetaMathQA数据集，具体文件为MetaMathQA-395K.json,可从[Huggingface](https://hf-mirror.com/datasets/meta-math/MetaMathQA/tree/main)下载。
本次训练使用MetaMathQA的迷你数据集[MetaMathQA-40K](https://huggingface.co/datasets/meta-math/MetaMathQA-40K)

## 模型下载
MetaMath-7B下载地址(https://hf-mirror.com/meta-math/MetaMath-7B-V1.0)
## 训练
该模型由于体量大小，最低三卡运行，推荐使用四卡训练微调
### 单机多卡

```
bash run.sh
```

## result

使用的加速卡:4张 DCU-K100AI-64G

<div align=center>
    <img src="./imgs/dcu.png"/>
</div>

### 精度
测试数据：[MATH_test.jsonl]，使用的加速卡:K100-64G,2卡训练。

根据测试结果情况填写表格：
| device | acc | 
| :------: | :------: | 
| DCU-K100AI | 0.1506 | 
| GPU-A800 | 0.1396 | 



### 算法类别

数学推理

### 热点应用行业

`数学,教育,金融`


## 源码仓库及问题反馈

- https://github.com/meta-math/MetaMath

## 参考资料

- https://github.com/meta-math/MetaMath
- https://huggingface.co/meta-math/MetaMath-7B-V1.0

