#! /bin/bash

# Runs the "345M" parameter model

DATA_PATH="./data"
CHECKPOINT_PATH="./checkpoint"
DS_CONFIG="./examples/ds_config.json"

MICRO_BATCH_SIZE=1
GLOBAL_BATCH_SIZE=8

deepspeed --num_gpus 4 pretrain_vit.py \
       --num-layers 24 \
       --hidden-size 1024 \
       --num-attention-heads 16 \
       --micro-batch-size ${MICRO_BATCH_SIZE} \
       --global-batch-size ${GLOBAL_BATCH_SIZE} \
       --seq-length 1024 \
       --max-position-embeddings 1024 \
       --train-iters 500000 \
       --lr-decay-iters 320000 \
       --save $CHECKPOINT_PATH \
       --load $CHECKPOINT_PATH \
       --data-path $DATA_PATH \
       --data-impl mmap \
       --split 949,50,1 \
       --distributed-backend nccl \
       --lr 0.00015 \
       --min-lr 1.0e-5 \
       --lr-decay-style cosine \
       --weight-decay 1e-2 \
       --clip-grad 1.0 \
       --lr-warmup-fraction .01 \
       --log-interval 100 \
       --save-interval 10000 \
       --eval-interval 1000 \
       --eval-iters 10 \
       --fp16 \
       --padded_vocab_size 224\
       --deepspeed \
       --deepspeed_config $DS_CONFIG \
# --eval-only True \
# --do_test True \
