# ViT 

## 论文
`An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale`
- https://arxiv.org/abs/2010.11929

## 模型结构
Vision Transformer先将图像用卷积进行分块以降低计算量，再对每一块进行展平处理变成序列，然后将序列添加位置编码和cls token，再输入多层Transformer结构提取特征，最后将cls tooken取出来通过一个MLP（多层感知机）用于分类。
<div align=center>
    <img src="./doc/vit.png"/>
</div>

## 算法原理
图像领域借鉴《Transformer is all you need！》算法论文中的Encoder结构提取特征，Transformer的核心思想是利用注意力模块attention提取特征：
<div align=center>
    <img src="./doc/attention.png"/>
</div>

## 环境配置
```
mv megatron-deepspeed-vit_pytorch megatron-deepspeed-vit # 去框架名后缀
```
### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
# <your IMAGE ID>用以上拉取的docker的镜像ID a4dd5be0ca23替换
docker run --shm-size 10g --network=host --name=megatron --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal -v $PWD/megatron-deepspeed-vit:/home/megatron-deepspeed-vit -it <your IMAGE ID> bash
pip install -r requirements.txt
```
### Dockerfile（方法二）
```
cd megatron-deepspeed-vit/docker
docker build --no-cache -t megatron:latest .
docker run --rm --shm-size 10g --network=host --name=megatron --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal -v $PWD/../../megatron-deepspeed-vit:/home/megatron-deepspeed-vit -it megatron:latest bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/
```
DTK驱动：dtk24.04.1
python：python3.10
torch:2.1.0
torchvision:0.16.0
torchaudio:2.1.2
deepspeed:0.12.3
apex:1.1.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

2、其它非特殊库参照requirements.txt安装
```
pip install -r requirements.txt
```
## 数据集

`ILSVRC 2012`

- https://image-net.org/challenges/LSVRC/index.php

`imagenet 2012` 的解压与整理方法参照链接：
https://www.jianshu.com/p/a42b7d863825

项目提供用于试验训练的迷你数据集[tiny-imagenet-200](http://cs231n.stanford.edu/tiny-imagenet-200.zip)，下载解压后将名字tiny-imagenet-200改为data，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
data
    |
    train
        |
        n01440764
        n01806143
        ...
    val
        |
        n01440764
        n01824575
        ...
    test
        |
        images
            |
            test_x.JPEG
            test_xxx.JPEG
            ...
```
## 训练
### 单机多卡
```
cd megatron-deepspeed-vit
# sh examples/dspvit_1node_minidata.sh #用于快速试验迷你数据集
sh examples/dspvit_1node.sh # 训练完整imagenet2012
# 训练过程中报：Message: 'is_pipe_partitioned= False',不影响训练，为deepspeed本身bug，如需要屏蔽可参照deepspeed github官网issue进行源码修改来解决。
```
### 单机单卡
```
sh examples/dspvit_1dcu.sh
```

## result
<div align=center>
    <img src="./doc/classify.png"/>
</div>

## 应用场景

### 算法类别

`图像分类`

### 热点应用行业

`制造,环保,医疗,气象`

## 预训练权重


## 源码仓库及问题反馈

- https://developer.hpccube.com/codes/modelzoo/megatron-deepspeed-vit_pytorch

## 参考资料
- https://github.com/bigscience-workshop/Megatron-DeepSpeed

- https://www.deepspeed.ai/getting-started/

- https://deepspeed.readthedocs.io/en/latest/index.html
