# Matting-Anything
Matting-Anything 一种交互式自然图像抠图模型。

## 论文
`Matting Anything`
- https://arxiv.org/abs/2306.05399

## 模型结构
<!-- 此处一句话简要介绍模型结构 -->
Matting Anything Model (MAM) 一个通用框架，能够使用单个模型解决各种类型的图像抠图场景。

<div align=center>
    <img src="./doc/Architecture.png"/>
    <div >Matting-Anything</div>
</div>


## 算法原理

MAM 基于 Segment Anything Model (SAM) 的基础上，利用 SAM 输出带有mask的特征图，进一步迭代细化得到最终的 alpha matte。因为冻结了 SAM 部分的参数，整个框架只有 MAM 模块的270万个参数。Matting Anything 整个框架集成了框、点或文本提示等交互方式，而且还启用了SD模型用来生成虚拟背景图片，增加了抠图的可玩性和互动性。


## 环境配置
```
mv matting-anything_pytoch matting-anything # 去框架名后缀
# docker的-v 路径、docker_name和imageID根据实际情况修改
# pip安装时如果出现下载慢可以尝试别的镜像源
```
### Docker（方法一）
<!-- 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤 -->
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/jupyterlab-pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10-scnet # 本镜像imageID为：38b7960be788
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --network=host --name docker_name imageID bash
cd /your_code_path/matting-anything
pip install -r requirements.txt
# Install segment-anything
python -m pip install -e segment-anything
# Install GroundingDINO
python -m pip install -e GroundingDINO
# Install diffusers
pip install --upgrade diffusers[torch]
```
### Dockerfile（方法二）
<!-- 此处提供dockerfile的使用方法 -->
```
cd /your_code_path/matting-anything/docker
docker build --no-cache -t codestral:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --network=host --name docker_name imageID bash
cd /your_code_path/matting-anything
pip install -r requirements.txt
# Install segment-anything
python -m pip install -e segment-anything
# Install GroundingDINO
python -m pip install -e GroundingDINO
# Install diffusers
pip install --upgrade diffusers[torch]
```
### Anaconda（方法三）
<!-- 此处提供本地配置、编译的详细步骤，例如： -->

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04.1
python: python3.10
pytorch: 2.1.0
```
`Tips：以上DTK驱动、python、pytorch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
# Install segment-anything
python -m pip install -e segment-anything
# Install GroundingDINO
python -m pip install -e GroundingDINO
# Install diffusers
pip install --upgrade diffusers[torch]
```
## 数据集


## 训练


## 推理
下载 [sam_vit_h_4b8939.pth](https://github.com/facebookresearch/segment-anything?tab=readme-ov-file#model-checkpoints)
或者从 [SCNet](http://113.200.138.88:18080/aimodels/findsource-dependency/sam_vit_h_4b8939) 上快速下载；

下载 [GroundingDINO-T](https://github.com/IDEA-Research/GroundingDINO/releases/download/v0.1.0-alpha/groundingdino_swint_ogc.pth) 或者从 [SCNet](http://113.200.138.88:18080/aimodels/idea-research/GroundingDINO.git) 上快速下载；

下载 [MAM](https://drive.google.com/drive/folders/1Bor2jRE0U-U6PIYaCm6SZY7qu_c1GYfq?usp=sharing) 或者从 [SCNet](http://113.200.138.88:18080/aimodels/findsource-dependency/matting-anything.git) 上快速下载。

sam_vit_h_4b8939.pth 放在 ./segment-anything/checkpoints 下；\
GroundingDINO-T、MAM 放在 ./checkpoints 下。

可视化webui推理：
```
export HF_ENDPOINT=https://hf-mirror.com
python gradio_app.py --listen
```
<div align=center>
    <img src="./doc/webui_result.png" width=600/>
    <div >webui界面</div>
</div>

1、上传图片；\
2、选择目标或者区域，可通过标点、画框或者文本输入；\
3、选择替换的背景，可选自有真实图片或者通过文本提示生成的图片。\
4、运行。\
ps：请勿频繁操作；参数自行调整。

## result
<!-- 此处填算法效果测试图（包括输入、输出） -->

<div align=center>
    <img src="./doc/demo.jpg" width=600/>
    <div >输入</div>
</div>
<div align=center>
    <img src="./doc/matte.png" width=600/>
    <div >抠图结果</div>
</div>
<div align=center>
    <img src="./doc/result.png" width=600/>
    <div >替换背景</div>
</div>


### 精度
无。

<!-- | 加速卡 | lpips | clip sim |
| :-----| :----- | :---- |
| K100_AI | 0.115 | 0.977 | -->
<!-- | 单元格 | 单元格 | 单元格 | -->


## 应用场景
### 算法类别

<!-- 超出以上分类的类别命名也可参考此网址中的类别名：https://huggingface.co/ \ -->
`AIGC`

### 热点应用行业
<!-- 应用行业的填写需要做大量调研，从而为使用者提供专业、全面的推荐，除特殊算法，通常推荐数量>=3。 -->
`零售,制造,电商,医疗,教育`


## 源码仓库及问题反馈
<!-- - 此处填本项目gitlab地址 -->
- https://developer.sourcefind.cn/codes/modelzoo/matting-anything_pytorch
## 参考资料
- https://github.com/SHI-Labs/Matting-Anything

