import os
from utils.utils_image import split_imageset


if __name__ == "__main__":
    ROOT_PATH = os.getcwd()
    print("The root is", ROOT_PATH)

    ori_img_path = os.path.join(ROOT_PATH, 'trainset/')
    if not os.path.exists(ori_img_path):
        print("the ori_img_path {} is not exists.".format(ori_img_path))

    save_img_path = os.path.join(ROOT_PATH, 'trainsets/trainH')
    if not os.path.exists(save_img_path):
        os.makedirs(save_img_path)

    split_imageset(ori_img_path, save_img_path, n_channels=3, p_size=512, p_overlap=96, p_max=800)
    print("split {} to {} finished.".format(ori_img_path, save_img_path))
