# MAMBA

## 论文

Mamba: Linear-Time Sequence Modeling with Selective State Spaces

https://arxiv.org/abs/2312.00752

## 模型结构

![图片1](图片1.png)

## 算法原理

![图片3](图片3.jpg)

![图片2](图片2.jpg)

```
	原始的SSM通过A B C H矩阵的变化得到y，但是由于不同的输入X都对应相同的A B C H矩阵，因此MAMBA模型对x进行处理得到不同的A' B' C' H'矩阵来作为mamba模块
```

## 环境配置

### Docker(方式一)

推荐使用docker方式运行，提供[光源](https://www.sourcefind.cn/#/main-page)拉取的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

docker run -dit --network=host --name=mamba_pytorch --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1  image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker exec -it mamba_pytorch /bin/bash
pip install -r requirements.txt  -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
```

### Dockerfile(方式二)

```
docker build -t mamba:latest .
docker run -dit --network=host --name=mamba_pytorch --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 qwen:latest
docker exec -it mamba_pytorch /bin/bash
pip install -r requirements.txt  -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
```

### conda(方式三)

```
conda create -n mamba_pytorch python=3.10
pip install -r requirements.txt  -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
```



### 注意

requirements-test.txt为较为完整的依赖版本,可以参考。@http之类的三方库主要依赖torch，可以从[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)下载对应版本的依赖库

按照上述方式配置好环境以后还需要编译&安装依赖项

```
cd causal-conv1d-1.4.0
python setup.py  install 
cd ..
python setup.py  install 
```

## 数据集

这里直接通过lm_eval从hugginface下载可能有问题，可以先通过modelscope获得hub镜像源后再通过原始代码下载

```
from modelscope.msdatasets import MsDataset
ds =  MsDataset.load('modelscope/hellaswag', subset_name='default')
```

```
#数据集目录
hellaswag/
└── default
    └── 0.1.0
        ├── 362ac471216900f3f7c021863caac4eb7886347d0f76d90b6b4361f59ffea4d7
        │   ├── cache-081f361bf081c0bf.arrow
        │   ├── cache-5d43362a7601c065.arrow
        │   ├── dataset_info.json
        │   ├── hellaswag-test.arrow
        │   ├── hellaswag-train.arrow
        │   └── hellaswag-validation.arrow
        ├── 362ac471216900f3f7c021863caac4eb7886347d0f76d90b6b4361f59ffea4d7_builder.lock
        └── 362ac471216900f3f7c021863caac4eb7886347d0f76d90b6b4361f59ffea4d7.incomplete_info.lock
```



## 模型下载

[官方mamaba与mamba2模型](https://huggingface.co/state-spaces)

目前mamba已经支持transformer，可以只下载带-hf后缀的模型进行使用，如果使用非hf格式的模型，还需要下载EleutherAI/gpt-neox-20b模型的tokenizer才可以使用

## 训练

```
#官方这里只给了训练的样例，没有更具体的例子
./run.sh
#验证 这里使用hellaswag任务作为示例，可选有lambada_openai,hellaswag,piqa,arc_easy,arc_challenge,winogrande,openbookqa
./run-eval.sh
```

## 推理

```
#可以通过传递--promt参数来进行具体的问答，也可以传递--batch参数来进行批量推理
./inf.sh  其中--model-name为hugginface模型名或者本地模型路径
```

## result

![图片4](图片4.jpg)

## 精度

|                 eval                  |       acc       |    acc_norm     |
| :-----------------------------------: | :-------------: | :-------------: |
| 数据集hellaswag，参数 batch64 float16 | 0.3080 ± 0.0046 | 0.3525 ± 0.0048 |

![图片5](图片5.jpg)

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`科研,教育,政府,金融`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/mamba_pytorch

## 参考资料

https://github.com/state-spaces/mamba/tree/main
