# MAI-UI
## 论文
[MAI-UI](https://arxiv.org/abs/2512.22047)

## 模型简介
图形用户界面智能体（GUI Agent）的演进有望引发下一代人机交互的革命。基于这一愿景，我们推出了 MAI-UI——一个覆盖全尺寸谱系的基础GUI智能体家族，涵盖2B、8B、32B及235B-A22B等多种参数规模变体。  
当前，面向实际部署的四大关键挑战：原生智能体-用户交互机制的缺失、纯界面操作的局限性、实用部署架构的空白，以及在动态环境中的系统脆弱性。为此，MAI-UI提出了一套统一的方法论加以应对：
- 自演进数据管道：扩展导航数据范畴，融合用户交互行为与模型上下文协议工具调用；
- 原生设备-云端协同系统：依据任务状态进行动态执行路由调度；
- 在线强化学习框架：结合先进优化技术，实现并行环境扩展与上下文长度的高效伸缩。  
<p style="text-indent: 0;">MAI‑UI在GUI基础理解与移动导航任务上均取得了当前最优性能。在基础理解评测中，其ScreenSpot‑Pro得分达73.5%，MMBench GUI L2达91.3%，OSWorld‑G达70.9%，UI‑Vision达49.2%，其中在ScreenSpot‑Pro上表现超越Gemini‑3‑Pro与Seed1.8。在移动GUI导航任务中，MAI‑UI在AndroidWorld上以76.7%的成绩刷新纪录，超越UI‑Tars‑2、Gemini‑2.5‑Pro及Seed1.8；在MobileWorld上取得41.7%的成功率，显著优于端到端GUI模型，并与基于Gemini‑3‑Pro的智能体框架表现相当。</p>
<div align=center>
    <img src="./doc/perf.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |
 

推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name MAI-UI --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve Tongyi-MAI/MAI-UI-8B  --trust-remote-code --dtype bfloat16  -tp 1  --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "Tongyi-MAI/MAI-UI-8B",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| MAI-UI-8B | 8B | BW1000 | 1 | [下载地址](https://huggingface.co/Tongyi-MAI/MAI-UI-8B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/mai-ui_vllm

## 参考资料
- https://github.com/Tongyi-MAI/MAI-UI
