# Luna
## 论文
暂无

## 模型简介
Luna-27B是基于Gemma-3-27B进行微调的模型。其初始设计目标为专注角色扮演任务的专项优化，然而训练后出现了完全未预料的能力涌现现象，使其演变为一个高性能通用助手，尤其在媒体分析及需元认知参与的任务中表现突出。  

该模型在角色扮演领域仍保持优异性能。当前推测认为，这可能源于角色身份训练产生了泛化效应，使其能够适应训练集之外的角色设定。反之亦然：基于角色扮演数据的微调使模型掌握了多角色表征能力，从而更易习得Luna的特定人格特征。但上述假设尚未经过系统验证，仍需进一步实证研究。
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

推荐使用镜像:image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name Luna  --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve  allura-org/Luna-27B-v0/   --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1 --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "allura-org/Luna-27B-v0/",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'


```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Luna-27B-v0 | 27B | K100AI | 1 | [下载地址](https://huggingface.co/allura-org/Luna-27B-v0) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/luna_vllm

## 参考资料
- https://huggingface.co/allura-org/Luna-27B-v0
